/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.Networking;

public class ModAuxiliaries {
    public static TextComponentTranslation localizable(String modtrkey, @Nullable TextFormatting color, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation("rsgauges." + modtrkey, args);
        if (color != null) {
            tr.func_150256_b().func_150238_a(color);
        }
        return tr;
    }

    @SideOnly(value=Side.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation(translationKey, args);
        tr.func_150256_b().func_150238_a(TextFormatting.RESET);
        String ft = tr.func_150254_d();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([\\w\\.]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                mt.appendReplacement(sb, new TextComponentTranslation(mt.group(1), new Object[0]).func_150254_d().trim());
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static void playerChatMessage(EntityPlayer player, String message) {
        String s = message.trim();
        if (!s.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(s, new Object[0]));
        }
    }

    public static void playerStatusMessage(EntityPlayer player, TextComponentTranslation message) {
        if (ModConfig.zmisc.without_switch_status_overlay) {
            player.func_145747_a((ITextComponent)message);
        } else {
            Networking.OverlayTextMessage.sendToClient((EntityPlayerMP)player, message);
        }
    }

    public static final AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static AxisAlignedBB transform_forward(AxisAlignedBB bb, EnumFacing facing) {
        switch (facing.func_176745_a()) {
            case 0: {
                return new AxisAlignedBB(bb.field_72338_b, -bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, -bb.field_72336_d, bb.field_72334_f);
            }
            case 1: {
                return new AxisAlignedBB(-bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, -bb.field_72337_e, bb.field_72336_d, bb.field_72334_f);
            }
            case 2: {
                return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, -bb.field_72340_a, bb.field_72334_f, bb.field_72337_e, -bb.field_72336_d);
            }
            case 3: {
                return new AxisAlignedBB(-bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, -bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
            }
            case 4: {
                return new AxisAlignedBB(-bb.field_72340_a, bb.field_72338_b, -bb.field_72339_c, -bb.field_72336_d, bb.field_72337_e, -bb.field_72334_f);
            }
            case 5: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 0.1, 0.1);
    }

    public static BlockPos transform_forward(BlockPos pos, EnumFacing facing) {
        switch (facing.func_176745_a()) {
            case 0: {
                return new BlockPos(pos.func_177956_o(), -pos.func_177958_n(), pos.func_177952_p());
            }
            case 1: {
                return new BlockPos(-pos.func_177956_o(), pos.func_177958_n(), pos.func_177952_p());
            }
            case 2: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
            }
            case 3: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case 4: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case 5: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    public static String daytimeToString(long t) {
        t = (t + 6000L) % 24000L;
        String sh = Long.toString(t / 1000L);
        String sm = Long.toString(t % 1000L * 60L / 1000L);
        if (sh.length() < 2) {
            sh = "0" + sh;
        }
        if (sm.length() < 2) {
            sm = "0" + sm;
        }
        return sh + ":" + sm;
    }

    public static String ticksToSecondsString(long t) {
        return String.format("%.02f", (double)t / 20.0);
    }

    public static boolean isClientSide() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    public static class BlockCategories {
        public static final long BLOCKCAT_NONE = 0L;
        public static final long BLOCKCAT_NATURAL = 1L;
        public static final long BLOCKCAT_ORE = 2L;
        public static final long BLOCKCAT_STAIR = 4L;
        public static final long BLOCKCAT_SLAB = 8L;
        public static final long BLOCKCAT_PLANK = 16L;
        public static final long BLOCKCAT_SOIL = 32L;
        public static final long BLOCKCAT_PLANT = 64L;
        public static final long BLOCKCAT_SAPLING = 128L;
        public static final long BLOCKCAT_CROP = 256L;
        public static final long BLOCKCAT_MATERIAL_WOOD = 0x1000000L;
        public static final long BLOCKCAT_MATERIAL_STONE = 0x2000000L;
        public static final long BLOCKCAT_MATERIAL_GLASS = 0x4000000L;
        public static final long BLOCKCAT_MATERIAL_CLAY = 0x8000000L;
        public static final long BLOCKCAT_MATERIAL_IRON = 0x10000000L;
        public static final long BLOCKCAT_MATERIAL_GOLD = 0x20000000L;
        public static final long BLOCKCAT_MATERIAL_DIAMOND = 0x40000000L;
        public static final long BLOCKCAT_MATERIAL_EMERALD = 0x80000000L;
        public static final long BLOCKCAT_MATERIAL_OBSIDIAN = 0x100000000L;
        public static final long BLOCKCAT_MATERIAL_REDSTONE = 0x200000000L;
        public static final long BLOCKCAT_MATERIAL_QUARZ = 0x400000000L;
        public static final long BLOCKCAT_MATERIAL_CONCRETE = 0x800000000L;
        public static final long BLOCKCAT_MATERIAL_PRISMARINE = 0x1000000000L;
        public static final long BLOCKCAT_MATERIAL_WATER = 0x2000000000L;
        private static Map<Block, Long> reverse_lut_ = Collections.synchronizedMap(new HashMap());

        public static void compose() {
            HashMap<Block, Long> map = new HashMap<Block, Long>();
            for (String key : OreDictionary.getOreNames()) {
                NonNullList stacks = OreDictionary.getOres((String)key);
                if (stacks == null) continue;
                long mask = 0L;
                if (key.matches("(.+)Wood$")) {
                    mask |= 0x1000000L;
                }
                if (key.matches("(.+)Obsidian$|(.+)Stone$|^stone[A-Z](.*)") || key.matches("(.*)(end|sand|cobble)stone$")) {
                    mask |= 0x2000000L;
                }
                if (key.matches("(.*)[a-z]Glass(.*)")) {
                    mask |= 0x4000000L;
                }
                if (key.matches("^ore[A-Z](.*)")) {
                    mask |= 2L;
                } else if (key.matches("^stair[A-Z](.*)")) {
                    mask |= 4L;
                } else if (key.matches("^plank[A-Z](.*)")) {
                    mask |= 0x10L;
                } else if (key.matches("^(grass|sand|dirt|farmland)($|[^a-z](.*))")) {
                    mask |= 0x20L;
                } else if (key.matches("^treeSapling(.*)")) {
                    mask |= 0xC0L;
                }
                for (ItemStack stack : stacks) {
                    Block block;
                    if (!(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == null) continue;
                    map.put(block, map.getOrDefault(block, 0L) | mask);
                }
                BiConsumer<Block, Long> push = (blck, msk) -> map.put((Block)blck, map.getOrDefault(blck, 0L) | msk);
                push.accept((Block)Blocks.field_150391_bh, 32L);
                push.accept(Blocks.field_150425_aM, 32L);
                push.accept(Blocks.field_150458_ak, 32L);
                push.accept(Blocks.field_150393_bb, 64L);
                push.accept(Blocks.field_150394_bc, 64L);
                push.accept((Block)Blocks.field_150434_aF, 64L);
                push.accept(Blocks.field_150392_bi, 64L);
                push.accept((Block)Blocks.field_150338_P, 64L);
                push.accept((Block)Blocks.field_150337_Q, 64L);
                push.accept(Blocks.field_150395_bd, 64L);
                push.accept((Block)Blocks.field_150362_t, 64L);
                push.accept((Block)Blocks.field_150361_u, 64L);
                push.accept((Block)Blocks.field_150327_N, 64L);
                push.accept(Blocks.field_185766_cS, 64L);
                push.accept(Blocks.field_185765_cR, 64L);
                push.accept((Block)Blocks.field_150328_O, 64L);
                push.accept((Block)Blocks.field_150398_cm, 64L);
                push.accept((Block)Blocks.field_150329_H, 64L);
                push.accept(Blocks.field_150459_bM, 320L);
                push.accept(Blocks.field_185773_cZ, 320L);
                push.accept(Blocks.field_150464_aj, 320L);
                push.accept(Blocks.field_150469_bN, 320L);
                push.accept(Blocks.field_150423_aK, 320L);
                push.accept(Blocks.field_150440_ba, 320L);
                push.accept(Blocks.field_150342_X, 0x1000000L);
                push.accept(Blocks.field_150324_C, 0x1000000L);
                push.accept(Blocks.field_150357_h, 0x2000000L);
                push.accept(Blocks.field_189877_df, 0x2000000L);
                push.accept(Blocks.field_150341_Y, 0x2000000L);
                push.accept(Blocks.field_150341_Y, 0x2000000L);
                push.accept(Blocks.field_150390_bg, 0x2000000L);
                push.accept((Block)Blocks.field_150333_U, 0x2000000L);
                push.accept((Block)Blocks.field_180389_cP, 0x2000000L);
                push.accept(Blocks.field_150446_ar, 0x2000000L);
                push.accept(Blocks.field_150417_aV, 0x2000000L);
                push.accept(Blocks.field_150336_V, 0x2000000L);
                push.accept(Blocks.field_150389_bf, 0x2000000L);
                push.accept((Block)Blocks.field_150334_T, 0x2000000L);
                push.accept(Blocks.field_150336_V, 0x2000000L);
                push.accept(Blocks.field_150377_bs, 0x2000000L);
                push.accept(Blocks.field_185772_cY, 0x2000000L);
                push.accept(Blocks.field_150372_bz, 0x2000000L);
                push.accept(Blocks.field_180396_cN, 0x2000000L);
                push.accept(Blocks.field_150426_aN, 0x4000000L);
                push.accept(Blocks.field_180398_cJ, 0x4000000L);
                push.accept(Blocks.field_150379_bu, 0x4000000L);
                push.accept(Blocks.field_150343_Z, 0x100000000L);
                push.accept(Blocks.field_150381_bn, 0x100000000L);
                push.accept(Blocks.field_150477_bB, 0x100000000L);
                push.accept(Blocks.field_150435_aG, 0x8000000L);
                push.accept(Blocks.field_150405_ch, 0x8000000L);
                push.accept(Blocks.field_150406_ce, 0x8000000L);
                push.accept(Blocks.field_150371_ca, 0x400000000L);
                push.accept(Blocks.field_150370_cb, 0x400000000L);
                push.accept(Blocks.field_180397_cI, 0x1000000000L);
                push.accept(Blocks.field_150467_bQ, 0x10000000L);
                push.accept(Blocks.field_150339_S, 0x10000000L);
                push.accept(Blocks.field_150411_aY, 0x10000000L);
                push.accept((Block)Blocks.field_150454_av, 0x10000000L);
                push.accept(Blocks.field_180400_cw, 0x10000000L);
                push.accept((Block)Blocks.field_150355_j, 0x2000000000L);
                push.accept((Block)Blocks.field_150358_i, 0x2000000000L);
                push.accept(Blocks.field_150432_aD, 0x2000000000L);
                push.accept(Blocks.field_185778_de, 0x2000000000L);
                push.accept(Blocks.field_150403_cj, 0x2000000000L);
                push.accept(Blocks.field_150433_aE, 0x2000000000L);
                push.accept(Blocks.field_150431_aC, 0x2000000000L);
            }
            reverse_lut_.clear();
            reverse_lut_.putAll(map);
        }

        public static long lookup_block_categories(Block block) {
            return block == null ? 0L : reverse_lut_.getOrDefault(block, 0L);
        }

        public static boolean match_block_categories(Block block, long category_mask) {
            return block != null && (reverse_lut_.getOrDefault(block, 0L) & category_mask) != 0L;
        }
    }

    public static class RsMaterials {
        public static final Material MATERIAL_TRAPDOORSWITCH = new MetalMaterial();
        public static final Material MATERIAL_METALLIC = new MetalMaterial();
        public static final Material MATERIAL_PLANT = new PlantMaterial();

        public static class PlantMaterial
        extends Material {
            public PlantMaterial() {
                super(MapColor.field_151661_c);
            }

            public boolean func_76224_d() {
                return false;
            }

            public boolean func_76228_b() {
                return false;
            }

            public boolean func_76230_c() {
                return false;
            }

            public boolean func_76229_l() {
                return true;
            }
        }

        public static class MetalMaterial
        extends Material {
            public MetalMaterial() {
                super(MapColor.field_151668_h);
            }

            public boolean func_76224_d() {
                return false;
            }

            public boolean func_76228_b() {
                return false;
            }

            public boolean func_76230_c() {
                return true;
            }

            public boolean func_76229_l() {
                return true;
            }
        }
    }

    public static class DyeColorFilters {
        public static final int WHITE = 0xF3F3F3;
        public static final int ORANGE = 16351261;
        public static final int MAGENTA = 13061821;
        public static final int LIGHTBLUE = 3847130;
        public static final int YELLOW = 16701501;
        public static final int LIME = 8439583;
        public static final int PINK = 15961002;
        public static final int GRAY = 4673362;
        public static final int SILVER = 0x9D9D97;
        public static final int CYAN = 1481884;
        public static final int PURPLE = 8991416;
        public static final int BLUE = 3949738;
        public static final int BROWN = 8606770;
        public static final int GREEN = 6192150;
        public static final int RED = 11546150;
        public static final int BLACK = 0x111111;
        public static final int[] byIndex_ = new int[]{0xF3F3F3, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x111111};
        public static final String[] nameByIndex = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        public static final int[] lightTintByIndex_ = new int[]{0xFFFFFF, 16563336, 15250916, 10279148, 16773043, 13824423, 16437725, 9937317, 0xCECECA, 6810089, 13410277, 9804506, 13739397, 12904308, 15177618, 0x808080};

        public static int byIndex(int idx) {
            return byIndex_[idx & 0xF];
        }

        public static int lightTintByIndex(int idx) {
            return lightTintByIndex_[idx & 0xF];
        }
    }

    public static final class Tooltip {
        @SideOnly(value=Side.CLIENT)
        public static boolean extendedTipCondition() {
            return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean helpCondition() {
            return Tooltip.extendedTipCondition() && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157));
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<String> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            if (Tooltip.helpCondition()) {
                if (!help_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add(s);
                return true;
            }
            if (Tooltip.extendedTipCondition()) {
                if (!tip_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add(s);
                return true;
            }
            if (addAdvancedTooltipHints) {
                String s = "";
                if (tip_available) {
                    s = s + ModAuxiliaries.localize("rsgauges.tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    s = s + ModAuxiliaries.localize("rsgauges.tooltip.hint.help", new Object[0]);
                }
                tooltip.add(s);
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.func_77977_a(), stack.func_77977_a(), tooltip, flag, addAdvancedTooltipHints);
        }
    }
}

