/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;

public class BlockSensitiveGlass
extends Block
implements ModContent.Colors.ColorTintSupport {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final int CONFIG_LIGHT_MASK_POWERED = 15;
    public static final int CONFIG_LIGHT_MASK_UNPOWERED = 240;
    public static final int CONFIG_SIDES_ALWAYS_RENDERED_POWERED = 256;
    public static final int CONFIG_SIDES_ALWAYS_RENDERED_UNPOWERED = 512;
    protected final int config;
    protected final int color_multiplier_value;

    public BlockSensitiveGlass(String registryName, int config, int colorMultiplierValue) {
        super(Material.field_151591_t);
        this.func_149647_a(ModRsGauges.CREATIVE_TAB_RSGAUGES);
        this.setRegistryName("rsgauges", registryName);
        this.func_149663_c("rsgauges." + registryName);
        this.func_149713_g(0);
        this.func_149715_a(0.0f);
        this.func_149711_c(0.3f);
        this.func_149752_b(2.0f);
        this.func_149675_a(false);
        this.config = config;
        this.color_multiplier_value = colorMultiplierValue;
    }

    public BlockSensitiveGlass(String registryName, int config) {
        this(registryName, config, -1);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if ((this.config & 0x300) == 768) {
            return true;
        }
        IBlockState neighbourState = world.func_180495_p(pos.func_177972_a(side));
        if (neighbourState == null || !(neighbourState.func_177230_c() instanceof BlockSensitiveGlass)) {
            return true;
        }
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if ((this.config & 0x100) != 0 && powered) {
            return true;
        }
        if ((this.config & 0x200) != 0 && !powered) {
            return true;
        }
        return (Boolean)neighbourState.func_177229_b((IProperty)POWERED) != powered;
    }

    public int func_149750_m(IBlockState state) {
        if (!ModConfig.zmisc.sensitive_glass_constant_server_light_level || ModAuxiliaries.isClientSide()) {
            return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? (this.config & 0xF) >> 0 : (this.config & 0xF0) >> 4;
        }
        return this.config & 0xF;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean func_181623_g() {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbourPos) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            if (!world.func_175640_z(pos)) {
                world.func_175684_a(pos, (Block)this, (this.config & 0xF) >> 0 == (this.config & 0xF0) >> 4 ? 1 : 4);
            }
        } else if (world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Override
    public boolean hasColorMultiplierRGBA() {
        return true;
    }

    @Override
    public int getColorMultiplierRGBA(@Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        return this.color_multiplier_value;
    }
}

