/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponentConnector;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazePredicateMany;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.PlacedMazeComponent;
import ivorius.ivtoolkit.maze.components.SetMazeComponent;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceWorldScriptMazeGenerator;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.IntAreas;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.VariableDomain;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.Connector;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.ConnectorFactory;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.ConnectorStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.PlacedStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazeReachability;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.WorldGenMaze;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.BlockedConnectorStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.LimitAABBStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.MazeRule;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.MazeRuleRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.script.WorldScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldScriptMazeGenerator
implements WorldScript<InstanceData> {
    public final List<MazeRule> rules = new ArrayList<MazeRule>();
    public String mazeID = "";
    public BlockPos structureShift = BlockPos.field_177992_a;
    public int[] roomSize = new int[]{3, 5, 3};
    public SavedMazeComponent mazeComponent = new SavedMazeComponent();

    public WorldScriptMazeGenerator() {
        this.mazeComponent.reachability.groupByDefault = false;
    }

    public static <C> void blockRooms(MorphingMazeComponent<C> component, Set<MazeRoom> rooms, C wallConnector) {
        component.add(WorldGenMaze.createCompleteComponent(rooms, Collections.emptyMap(), wallConnector));
    }

    public static <C> void enclose(MorphingMazeComponent<C> component, MazeRoom lower, MazeRoom higher, C wallConnector) {
        if (lower.getDimensions() != higher.getDimensions()) {
            throw new IllegalArgumentException();
        }
        HashSet<MazeRoom> rooms = new HashSet<MazeRoom>();
        int[] coords = lower.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            int lowest = lower.getCoordinate(i);
            int highest = higher.getCoordinate(i);
            int finalI = i;
            IntAreas.visitCoordsExcept(lower.getCoordinates(), higher.getCoordinates(), (TIntList)TIntArrayList.wrap((int[])new int[]{i++}), (Visitor<int[]>)((Visitor)ints -> {
                ints[finalI] = lowest;
                rooms.add(new MazeRoom(ints));
                ints[finalI] = highest;
                rooms.add(new MazeRoom(ints));
                return true;
            }));
        }
        WorldScriptMazeGenerator.blockRooms(component, rooms, wallConnector);
    }

    @Override
    public void generate(StructureSpawnContext context, RunTransformer transformer, InstanceData instanceData, BlockPos pos) {
        for (PlacedStructure placedComponent : instanceData.placedStructures) {
            WorldGenMaze.generate(context, placedComponent, pos);
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get((String)"reccomplex.worldscript.mazeGen");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(BlockPos realWorldPos, TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptMazeGenerator(this, realWorldPos, tableDelegate, navigator);
    }

    public String getMazeID() {
        return this.mazeID;
    }

    public void setMazeID(String mazeID) {
        this.mazeID = mazeID;
    }

    public BlockPos getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockPos structureShift) {
        this.structureShift = structureShift;
    }

    public int[] getRoomSize() {
        return (int[])this.roomSize.clone();
    }

    public void setRoomSize(int[] roomSize) {
        this.roomSize = roomSize;
    }

    public SavedMazeComponent getMazeComponent() {
        return this.mazeComponent;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.mazeID = compound.func_74779_i("mazeID");
        if (compound.func_150297_b("mazeComponent", 10)) {
            this.mazeComponent.readFromNBT(compound.func_74775_l("mazeComponent"));
        } else {
            NBTTagCompound rooms = compound.func_74775_l("rooms");
            this.mazeComponent.rooms.readFromNBT(rooms);
            if (compound.func_150297_b("roomNumbers", 11)) {
                this.mazeComponent.rooms.add(new Selection.Area(true, new int[]{0, 0, 0}, IvVecMathHelper.sub((int[])IvNBTHelper.readIntArrayFixedSize((String)"roomNumbers", (int)3, (NBTTagCompound)compound), (int[][])new int[][]{{1, 1, 1}})));
            }
            if (compound.func_150297_b("blockedRoomAreas", 9)) {
                NBTTagList blockedRoomsList = compound.func_150295_c("blockedRoomAreas", 10);
                for (int i = 0; i < blockedRoomsList.func_74745_c(); ++i) {
                    NBTTagCompound blockedRoomTag = blockedRoomsList.func_150305_b(i);
                    this.mazeComponent.rooms.add(new Selection.Area(false, IvNBTHelper.readIntArrayFixedSize((String)"min", (int)3, (NBTTagCompound)blockedRoomTag), IvNBTHelper.readIntArrayFixedSize((String)"max", (int)3, (NBTTagCompound)blockedRoomTag)));
                }
            }
            this.mazeComponent.exitPaths.clear();
            this.mazeComponent.exitPaths.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"mazeExits", SavedMazePathConnection::new));
            this.mazeComponent.defaultConnector.id = "Wall";
            this.mazeComponent.reachability.set(Collections.emptyList(), Collections.emptyList(), false);
        }
        this.structureShift = BlockPositions.readFromNBT((String)"structureShift", (NBTTagCompound)compound);
        this.roomSize = IvNBTHelper.readIntArrayFixedSize((String)"roomSize", (int)3, (NBTTagCompound)compound);
        this.rules.clear();
        this.rules.addAll(NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"rules").stream().map(MazeRuleRegistry.INSTANCE::read).collect(Collectors.toList()));
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("mazeID", this.mazeID);
        compound.func_74782_a("mazeComponent", (NBTBase)NBTCompoundObjects.write((NBTCompoundObject)this.mazeComponent));
        BlockPositions.writeToNBT((String)"structureShift", (BlockPos)this.structureShift, (NBTTagCompound)compound);
        compound.func_74783_a("roomSize", this.roomSize);
        NBTTagLists.writeTo((NBTTagCompound)compound, (String)"rules", this.rules.stream().map(MazeRuleRegistry.INSTANCE::write).collect(Collectors.toList()));
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        InstanceData instanceData = new InstanceData();
        instanceData.placedStructures.addAll(this.getPlacedRooms(context.random, context.transform, context.environment).stream().map(placedComponent -> WorldGenMaze.place(context.random, context.environment.child(), this.structureShift, this.roomSize, (PlacedMazeComponent<MazeComponentStructure<Connector>, Connector>)placedComponent, pos, context.transform)).filter(Objects::nonNull).collect(Collectors.toList()));
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    public List<PlacedMazeComponent<MazeComponentStructure<Connector>, Connector>> getPlacedRooms(Random random, AxisAlignedTransform2D transform, Environment environment) {
        if (this.mazeComponent.rooms.isEmpty()) {
            return null;
        }
        ConnectorFactory factory = new ConnectorFactory();
        Connector wallConnector = factory.get("Wall");
        Connector defaultConnector = this.mazeComponent.defaultConnector.toConnector(factory);
        Set<Connector> blockedConnections = Collections.singleton(wallConnector);
        int[] boundsHigher = this.mazeComponent.rooms.boundsHigher();
        int[] boundsLower = this.mazeComponent.rooms.boundsLower();
        int[] oneArray = new int[boundsHigher.length];
        Arrays.fill(oneArray, 1);
        int[] outsideBoundsHigher = IvVecMathHelper.add((int[][])new int[][]{boundsHigher, oneArray});
        int[] outsideBoundsLower = IvVecMathHelper.sub((int[])boundsLower, (int[][])new int[][]{oneArray});
        List transformedComponents = MazeGeneration.structures(StructureRegistry.INSTANCE, this.mazeID).flatMap(pair -> ((Structure)pair.getLeft()).declaredVariables().omega(environment, true).flatMap(domain -> WorldGenMaze.transforms((Structure)pair.getLeft(), (MazeGeneration)pair.getRight(), transform, factory, environment.copy((VariableDomain)domain), blockedConnections))).collect(Collectors.toList());
        SetMazeComponent maze = new SetMazeComponent();
        WorldScriptMazeGenerator.enclose(maze, new MazeRoom(outsideBoundsLower), new MazeRoom(outsideBoundsHigher), defaultConnector);
        WorldScriptMazeGenerator.blockRooms(maze, this.mazeComponent.rooms.compile(false).keySet(), defaultConnector);
        WorldGenMaze.buildExitPaths(environment, factory, this.mazeComponent.exitPaths, maze.rooms()).forEach(arg_0 -> WorldScriptMazeGenerator.lambda$getPlacedRooms$4((MorphingMazeComponent)maze, arg_0));
        maze.reachability().putAll((Multimap)WorldGenMaze.addExternalReachability((ImmutableMultimap.Builder<MazePassage, MazePassage>)ImmutableListMultimap.builder(), maze.exits(), blockedConnections).build());
        maze.reachability().putAll((Multimap)this.mazeComponent.reachability.build((ImmutableMultimap.Builder<MazePassage, MazePassage>)ImmutableListMultimap.builder(), AxisAlignedTransform2D.ORIGINAL, this.mazeComponent.boundsSize(), SavedMazeReachability.notBlocked(blockedConnections, maze.exits()), maze.exits().keySet()).build());
        ConnectorStrategy connectorStrategy = new ConnectorStrategy();
        List predicates = this.rules.stream().map(r -> r.build(this, blockedConnections, factory, transformedComponents, connectorStrategy)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        predicates.add(new LimitAABBStrategy(outsideBoundsHigher));
        predicates.add(new BlockedConnectorStrategy<Connector>(blockedConnections));
        int totalRooms = this.mazeComponent.rooms.compile(true).size();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<List> future = executor.submit(() -> WorldScriptMazeGenerator.lambda$getPlacedRooms$6((MorphingMazeComponent)maze, transformedComponents, connectorStrategy, predicates, random, totalRooms));
        executor.shutdown();
        try {
            return future.get(RCConfig.mazeTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new GenerationException("Maze generation timed out: " + this.mazeID);
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new GenerationException("Error generating maze; " + this.mazeID, t);
        }
    }

    private static /* synthetic */ List lambda$getPlacedRooms$6(MorphingMazeComponent maze, List transformedComponents, ConnectorStrategy connectorStrategy, List predicates, Random random, int totalRooms) throws Exception {
        return MazeComponentConnector.connect((MorphingMazeComponent)maze, (List)transformedComponents, (ConnectionStrategy)connectorStrategy, (MazePredicate)new MazePredicateMany(predicates), (Random)random, (int)(RCConfig.mazePlacementReversesPerRoom >= 0.0f ? MathHelper.func_76141_d((float)((float)totalRooms * RCConfig.mazePlacementReversesPerRoom + 0.5f)) : MazeComponentConnector.INFINITE_REVERSES));
    }

    private static /* synthetic */ void lambda$getPlacedRooms$4(MorphingMazeComponent maze, Map.Entry path) {
        Connector cfr_ignored_0 = (Connector)maze.exits().put(path.getKey(), path.getValue());
    }

    public static class GenerationException
    extends RuntimeException
    implements StructureGenerator.ExpectedException {
        public GenerationException(String message) {
            super(message);
        }

        public GenerationException(String message, Throwable cause) {
            super(message, cause);
        }

        @Override
        public boolean isExpected() {
            return this.getCause() == null;
        }
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<PlacedStructure> placedStructures = new ArrayList<PlacedStructure>();

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.placedStructures.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"placedStructures", PlacedStructure::new));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"placedStructures", this.placedStructures);
            return compound;
        }
    }
}

