/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayAverageMatcher
extends FactorLimit.Ray {
    public final PositionedBlockExpression destMatcher = new PositionedBlockExpression(RecurrentComplex.specialRegistry);
    public boolean up;

    public RayAverageMatcher() {
        this(null, false, "blocks:movement & !is:foliage");
    }

    public RayAverageMatcher(Float weight, boolean up, String destExpression) {
        super(weight);
        this.up = up;
        this.destMatcher.setExpression(destExpression);
    }

    public static BlockPos findFirstBlock(BlockPos.MutableBlockPos pos, Predicate<BlockPos> predicate, boolean up, int wHeight) {
        while (pos.func_177956_o() >= 0 && pos.func_177956_o() < wHeight) {
            if (predicate.test((BlockPos)pos)) {
                return pos;
            }
            IvMutableBlockPos.offset((BlockPos)pos, (BlockPos.MutableBlockPos)pos, (EnumFacing)(up ? EnumFacing.UP : EnumFacing.DOWN));
        }
        return null;
    }

    public static int getAverageGroundLevel(boolean up, int y, Set<BlockPos> surface, Predicate<BlockPos> predicate, int wHeight, double samples, Random random) {
        TIntArrayList list = new TIntArrayList(surface.size());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (BlockPos surfacePos : surface) {
            if (!(samples >= 1.0) && !(random.nextDouble() < samples)) continue;
            pos.func_181079_c(surfacePos.func_177958_n(), surfacePos.func_177956_o() + y, surfacePos.func_177952_p());
            BlockPos found = RayAverageMatcher.findFirstBlock(pos, predicate, up, wHeight);
            if (found == null) continue;
            list.add(found.func_177956_o() - surfacePos.func_177956_o());
        }
        if (list.isEmpty()) {
            return -1;
        }
        return RayAverageMatcher.robustAverage(list.toArray());
    }

    protected static int robustAverage(int ... values) {
        int average = 0;
        for (int val : values) {
            average += val;
        }
        average /= values.length;
        int averageDist = 0;
        for (int val : values) {
            averageDist += RayAverageMatcher.dist(val, average);
        }
        averageDist /= values.length;
        int newAverage = 0;
        int ignored = 0;
        for (int val : values) {
            if (RayAverageMatcher.dist(val, average) <= averageDist * 2) {
                newAverage += val;
                continue;
            }
            ++ignored;
        }
        return newAverage / (values.length - ignored);
    }

    protected static int dist(int val1, int val2) {
        return val1 > val2 ? val1 - val2 : val2 - val1;
    }

    public static Set<BlockPos> shifted(StructurePlaceContext context, IvBlockCollection collection, Set<BlockPos> surface) {
        int[] size = collection.area().areaSize();
        BlockPos lower = StructureBoundingBoxes.min((StructureBoundingBox)context.boundingBox);
        return surface.stream().map(p -> context.transform.apply(p, size).func_177971_a((Vec3i)lower)).collect(Collectors.toSet());
    }

    @Override
    public OptionalInt cast(WorldCache cache, StructurePlaceContext context, IvBlockCollection collection, Set<BlockPos> surface, int y) {
        int floorBlocks = surface.size();
        double samples = floorBlocks < 256 ? 1.0 : Math.pow(256.0f / (float)floorBlocks, 0.7f);
        Set<BlockPos> shiftedSurface = RayAverageMatcher.shifted(context, collection, surface);
        int averageGroundLevel = RayAverageMatcher.getAverageGroundLevel(this.up, y, shiftedSurface, blockPos -> (Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at(cache, blockPos)), cache.world.func_72800_K(), samples, context.random);
        return averageGroundLevel >= 0 ? OptionalInt.of(averageGroundLevel) : OptionalInt.empty();
    }

    @Override
    public String displayString() {
        return String.format("%s %s", RayAverageMatcher.directionArrow(this.up), IvTranslations.get((String)"reccomplex.placer.factors.limit.rays.average"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceSegmented(this.rayTableDataSource(navigator, delegate), TableDataSourceExpression.constructDefault(IvTranslations.get((String)"reccomplex.placer.factors.limit.rays.matcher.condition"), this.destMatcher, null), new TableDataSourceSupplied(() -> {
            TableCellBoolean cell = new TableCellBoolean(null, this.up, IvTranslations.get((String)"reccomplex.direction.up"), IvTranslations.get((String)"reccomplex.direction.down"));
            cell.addListener(v -> {
                this.up = v;
            });
            return new TitledCell(IvTranslations.get((String)"reccomplex.placer.factors.limit.rays.matcher.direction"), cell);
        }));
    }

    public static class Serializer
    implements JsonSerializer<RayAverageMatcher>,
    JsonDeserializer<RayAverageMatcher> {
        public RayAverageMatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "rayAverageMatcher");
            Float weight = JsonUtils.has(jsonObject, "weight") ? Float.valueOf(JsonUtils.getFloat(jsonObject, "weight")) : null;
            boolean up = JsonUtils.getBoolean(jsonObject, "up", true);
            String destExpression = JsonUtils.getString(jsonObject, "destExpression", "");
            return new RayAverageMatcher(weight, up, destExpression);
        }

        public JsonElement serialize(RayAverageMatcher src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.weight != null) {
                jsonObject.addProperty("weight", (Number)src.weight);
            }
            jsonObject.addProperty("up", Boolean.valueOf(src.up));
            jsonObject.addProperty("destExpression", src.destMatcher.getExpression());
            return jsonObject;
        }
    }
}

