/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.shadow.mcopts.translation;

import ivorius.reccomplex.shadow.mcopts.translation.Translations;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.StringUtils;

public abstract class ServerTranslations {
    @Nonnull
    public static TextComponentTranslation join(Object ... components) {
        return ServerTranslations.join(", ", components);
    }

    @Nonnull
    public static TextComponentTranslation join(String join, Object ... components) {
        return new TextComponentTranslation(StringUtils.repeat((String)"%s", (String)join, (int)components.length), components);
    }

    @Nonnull
    public static TextComponentTranslation join(List<?> components) {
        return ServerTranslations.join(components.toArray());
    }

    public <T> T object(BiFunction<String, Object[], T> fun, String key, Object ... params) {
        if (this.translateServerSide()) {
            return fun.apply(Translations.format(key, this.convertParams(params)), new Object[0]);
        }
        return fun.apply(key, params);
    }

    public CommandException commandException(String key, Object ... params) {
        return this.object(CommandException::new, key, params);
    }

    public CommandException wrongUsageException(String key, Object ... params) {
        return (CommandException)this.object(WrongUsageException::new, key, params);
    }

    public ITextComponent format(String key, Object ... params) {
        if (this.translateServerSide()) {
            return new TextComponentString(Translations.format(key, this.convertParams(params)));
        }
        return new TextComponentTranslation(key, params);
    }

    public ITextComponent get(String key) {
        if (this.translateServerSide()) {
            return new TextComponentString(Translations.get(key));
        }
        return new TextComponentTranslation(key, new Object[0]);
    }

    public String usage(String key) {
        if (this.translateServerSide()) {
            return Translations.get(key);
        }
        return key;
    }

    public Object[] convertParams(Object ... params) {
        if (this.translateServerSide()) {
            Object[] array = new Object[params.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = params[i] instanceof TextComponentTranslation ? Translations.format(((TextComponentTranslation)params[i]).func_150268_i(), this.convertParams(((TextComponentTranslation)params[i]).func_150271_j())) : (params[i] instanceof ITextComponent ? ((ITextComponent)params[i]).func_150260_c() : params[i]);
            }
            return array;
        }
        return params;
    }

    public abstract boolean translateServerSide();
}

