/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.rendering.grid.BlockQuadCache;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.ReadableInstanceData;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.StructureSaveHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OperationGenerateStructure
implements Operation {
    public GenericStructure structure;
    public AxisAlignedTransform2D transform;
    public BlockPos lowerCoord;
    public boolean generateAsSource;
    public String structureID;
    public String generationInfoID;
    protected GridQuadCache cachedShapeGrid;
    protected String seed;
    protected final ReadableInstanceData<GenericStructure.InstanceData> instanceData = new ReadableInstanceData();

    public OperationGenerateStructure() {
    }

    public OperationGenerateStructure(GenericStructure structure, String generationInfoID, AxisAlignedTransform2D transform, BlockPos lowerCoord, boolean generateAsSource) {
        this.structure = structure;
        this.generationInfoID = generationInfoID;
        this.transform = transform;
        this.lowerCoord = lowerCoord;
        this.generateAsSource = generateAsSource;
    }

    public OperationGenerateStructure dummy(GenericStructure structure) {
        OperationGenerateStructure op = new OperationGenerateStructure(structure, this.generationInfoID, this.transform, this.lowerCoord, this.generateAsSource).withSeed(this.seed).withStructureID(this.structureID);
        op.instanceData.set(this.instanceData);
        return op;
    }

    public String getStructureID() {
        return this.structureID;
    }

    public void setStructureID(String structureID) {
        this.structureID = structureID;
    }

    public OperationGenerateStructure withStructureID(String structureIDForSaving) {
        this.structureID = structureIDForSaving;
        return this;
    }

    public OperationGenerateStructure withSeed(String seed) {
        this.seed = seed;
        return this;
    }

    public OperationGenerateStructure prepare(WorldServer world) {
        return this.prepare(this.generator(world).instanceData());
    }

    public OperationGenerateStructure prepare(Optional<GenericStructure.InstanceData> instanceData) {
        this.instanceData.setInstanceData((GenericStructure.InstanceData)((NBTStorable)instanceData.orElse(null)));
        return this;
    }

    @Override
    public void perform(WorldServer world) {
        if (!this.instanceData.exists()) {
            throw new IllegalStateException();
        }
        StructureGenerator<GenericStructure.InstanceData> generator = this.generator(world);
        this.instanceData.load(generator);
        generator.generate();
    }

    public StructureGenerator<GenericStructure.InstanceData> generator(WorldServer world) {
        StructureGenerator<GenericStructure.InstanceData> generator = new StructureGenerator<GenericStructure.InstanceData>(this.structure).world(world).generationInfo(this.generationInfoID).seed(RCStrings.seed(this.seed)).transform(this.transform).lowerCoord(this.lowerCoord).maturity(StructureSpawnContext.GenerateMaturity.FIRST).asSource(this.generateAsSource);
        this.instanceData.register(generator);
        if (this.structureID != null) {
            generator.structureID(this.structureID);
        }
        return generator;
    }

    @Override
    public boolean checkDead(ICommandSender target) {
        if (!this.instanceData.exists() || this.lowerCoord == null) {
            String reason = StructureGenerator.GenerationResult.Failure.placement.description;
            target.func_145747_a(RecurrentComplex.translations.format("commands.strucGen.failure", reason));
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("structureInfo", StructureSaveHandler.INSTANCE.toJSON(this.structure));
        compound.func_74782_a("structureData", (NBTBase)this.structure.worldDataCompound);
        RCAxisAlignedTransform.write(compound, this.transform, "rotation", "mirrorX");
        BlockPositions.writeToNBT((String)"lowerCoord", (BlockPos)this.lowerCoord, (NBTTagCompound)compound);
        compound.func_74757_a("generateAsSource", this.generateAsSource);
        if (this.structureID != null) {
            compound.func_74778_a("structureIDForSaving", this.structureID);
        }
        if (this.seed != null) {
            compound.func_74778_a("seed", this.seed);
        }
        this.instanceData.writeToNBT("instanceData", compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.structure = StructureSaveHandler.INSTANCE.fromJSON(compound.func_74779_i("structureInfo"), compound.func_74775_l("structureData"));
        this.transform = RCAxisAlignedTransform.read(compound, "rotation", "mirrorX");
        this.lowerCoord = BlockPositions.readFromNBT((String)"lowerCoord", (NBTTagCompound)compound);
        this.generateAsSource = compound.func_74767_n("generateAsSource");
        this.structureID = compound.func_150297_b("structureIDForSaving", 8) ? compound.func_74779_i("structureIDForSaving") : null;
        this.seed = compound.func_74764_b("seed") ? compound.func_74779_i("seed") : null;
        this.instanceData.readFromNBT("instanceData", compound);
    }

    public void invalidateCache() {
        this.cachedShapeGrid = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPreview(Operation.PreviewType previewType, World world, int ticks, float partialTicks) {
        if (previewType == Operation.PreviewType.SHAPE) {
            GlStateManager.func_179124_c((float)0.8f, (float)0.75f, (float)1.0f);
            OperationRenderer.renderGridQuadCache(this.cachedShapeGrid != null ? this.cachedShapeGrid : (this.cachedShapeGrid = BlockQuadCache.createQuadCache((IvBlockCollection)this.structure.constructWorldData().blockCollection, (float[])new float[]{1.0f, 1.0f, 1.0f})), this.transform, this.lowerCoord, ticks, partialTicks);
        }
        if (previewType == Operation.PreviewType.BOUNDING_BOX || previewType == Operation.PreviewType.SHAPE) {
            OperationRenderer.renderBoundingBox(this.generationArea(), ticks, partialTicks);
        }
    }

    @Nullable
    public BlockArea generationArea() {
        if (this.structure == null) {
            return null;
        }
        int[] size = this.structure.size();
        return OperationRenderer.blockAreaFromSize(this.lowerCoord, RCAxisAlignedTransform.applySize(this.transform, size));
    }
}

