/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.ivtoolkit.item.IvItemStacks;
import ivorius.reccomplex.gui.loot.GuiEditItemStack;
import ivorius.reccomplex.gui.loot.TableDataSourceLootGeneratorSingleTag;
import ivorius.reccomplex.item.ItemLootGenerationTag;
import ivorius.reccomplex.item.ItemSyncableTags;
import ivorius.reccomplex.world.storage.loot.LootTable;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLootGenSingleTag
extends ItemLootGenerationTag
implements ItemSyncableTags {
    @Override
    public void generateInInventory(WorldServer server, IItemHandlerModifiable inventory, Random random, ItemStack stack, int fromSlot) {
        LootTable lootTable = ItemLootGenSingleTag.lootTable(stack);
        if (lootTable != null) {
            ItemStack generated;
            ItemStack itemStack = generated = random.nextFloat() < this.getItemChance(stack) ? lootTable.getRandomItemStack(server, random) : null;
            if (generated != null) {
                inventory.setStackInSlot(fromSlot, generated);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            this.openGui(playerIn, playerIn.field_71071_by.field_70461_c);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, int slot) {
        Minecraft.func_71410_x().func_147108_a(new GuiEditItemStack<TableDataSourceLootGeneratorSingleTag>(player, slot, new TableDataSourceLootGeneratorSingleTag()));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(String.format("%f Chance", Float.valueOf(this.getItemChance(stack))));
    }

    public float getItemChance(ItemStack stack) {
        return IvItemStacks.getNBT((ItemStack)stack, (String)"itemChance", (float)1.0f);
    }

    public void setItemChance(ItemStack stack, float chance) {
        stack.func_77983_a("itemChance", (NBTBase)new NBTTagFloat(chance));
    }

    @Override
    public List<Pair<String, Integer>> getSyncedNBTTags() {
        return Collections.singletonList(Pair.of((Object)"itemChance", (Object)5));
    }
}

