/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.tweak;

import gnu.trove.map.TObjectFloatMap;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.gui.GuiHider;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.utils.scale.Scales;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceTweakStructuresList
extends TableDataSourceSegmented {
    protected TObjectFloatMap<String> tweaks;
    protected List<String> editingIDs = new ArrayList<String>();
    protected TableDelegate delegate;

    public TableDataSourceTweakStructuresList(TableDelegate delegate, TObjectFloatMap<String> tweaks) {
        this.tweaks = tweaks;
        this.delegate = delegate;
        this._search(null, false);
    }

    public void search(@Nullable String search) {
        this._search(search, true);
    }

    protected void _search(@Nullable String search, boolean reload) {
        this.editingIDs.clear();
        this.editingIDs.addAll(StructureRegistry.INSTANCE.ids());
        if (search != null) {
            this.editingIDs.removeIf(id -> !id.toLowerCase().contains(search.toLowerCase()));
        }
        this.editingIDs.sort(String::compareTo);
        if (reload) {
            this.delegate.reloadData();
        }
    }

    public static void suggest(GuiChat chat, String command) {
        GuiTextField inputField = (GuiTextField)ReflectionHelper.getPrivateValue(GuiChat.class, (Object)chat, (String)"inputField", (String)"field_146415_a");
        inputField.func_146180_a(command);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        String id = this.editingIDs.get(index);
        return TableCellMultiBuilder.create(null, this.delegate).addCell(() -> {
            TableCellFloatNullable cell = new TableCellFloatNullable(null, this.getTweak(id), 1.0f, 0.0f, 10.0f, "D", "T");
            cell.setScale(Scales.pow(5.0f));
            cell.addListener(value -> {
                if (value == null) {
                    this.tweaks.remove((Object)id);
                } else {
                    this.tweaks.put((Object)id, value.floatValue());
                }
            });
            return cell;
        }).addAction(() -> {
            GuiHider.hideGUI();
            GuiChat chat = new GuiChat();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)chat);
            String genCommand = String.format("/%s %s", RCCommands.generate.func_71517_b(), id);
            TableDataSourceTweakStructuresList.suggest(chat, genCommand);
        }, () -> IvTranslations.get((String)"gui.tweakStructures.generate"), () -> IvTranslations.getLines((String)"gui.tweakStructures.generate.tooltip")).sized(() -> Float.valueOf(0.3f)).withTitle(id, Collections.singletonList(id)).build();
    }

    public Float getTweak(String id) {
        return this.tweaks.containsKey((Object)id) ? Float.valueOf(this.tweaks.get((Object)id)) : null;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return this.editingIDs.size();
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }
}

