/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.loot;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.ivtoolkit.gui.GuiSliderRange;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.gui.Ranges;
import ivorius.ivtoolkit.network.PacketGuiAction;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.GuiHider;
import ivorius.reccomplex.gui.InventoryWatcher;
import ivorius.reccomplex.gui.RCGuiHandler;
import ivorius.reccomplex.gui.loot.ContainerEditLootTableItems;
import ivorius.reccomplex.utils.SaveDirectoryData;
import ivorius.reccomplex.utils.scale.Scale;
import ivorius.reccomplex.utils.scale.Scales;
import ivorius.reccomplex.world.storage.loot.GenericLootTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditLootTableItems
extends GuiContainer
implements InventoryWatcher {
    public static ResourceLocation textureBackground = new ResourceLocation("reccomplex", RecurrentComplex.filePathTextures + "gui_edit_inventory_gen.png");
    public static Scale WEIGHT_SCALE = Scales.pow(5.0f);
    public String key;
    public GenericLootTable.Component component;
    public SaveDirectoryData saveDirectoryData;
    private GuiButton backBtn;
    private GuiButton nextPageBtn;
    private GuiButton prevPageBtn;
    private List<GuiSlider> weightSliders = new ArrayList<GuiSlider>();
    private List<GuiSliderRange> minMaxSliders = new ArrayList<GuiSliderRange>();
    private int currentPage;

    public GuiEditLootTableItems(EntityPlayer player, GenericLootTable.Component component, String key, SaveDirectoryData saveDirectoryData) {
        super((Container)new ContainerEditLootTableItems(player, key, component));
        this.key = key;
        this.component = component;
        this.saveDirectoryData = saveDirectoryData;
        this.field_146999_f = 308;
        this.field_147000_g = 219;
        ((ContainerEditLootTableItems)this.field_147002_h).inventory.addWatcher(this);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.weightSliders.clear();
        this.minMaxSliders.clear();
        int leftEdge = this.field_146294_l / 2 - this.field_146999_f / 2;
        int topEdge = this.field_146295_m / 2 - this.field_147000_g / 2;
        int shiftRightPage = leftEdge + 288;
        this.backBtn = new GuiButton(0, leftEdge, this.field_146295_m / 2 + 90, this.field_146999_f / 3 - 1, 20, IvTranslations.get((String)"gui.back"));
        this.field_146292_n.add(this.backBtn);
        GuiButton saveButton = new GuiButton(1, leftEdge + this.field_146999_f / 3 + 1, this.field_146295_m / 2 + 90, this.field_146999_f / 3 - 2, 20, TextFormatting.GREEN + IvTranslations.get((String)"reccomplex.gui.save"));
        saveButton.field_146124_l = false;
        this.field_146292_n.add(saveButton);
        GuiButton hideButton = new GuiButton(2, leftEdge + this.field_146999_f / 3 * 2 + 1, this.field_146295_m / 2 + 90, this.field_146999_f / 3 - 1, 20, IvTranslations.get((String)"reccomplex.gui.hidegui"));
        hideButton.field_146124_l = false;
        this.field_146292_n.add(hideButton);
        this.nextPageBtn = new GuiButton(10, shiftRightPage, this.field_146295_m / 2 - 80, 20, 20, ">");
        this.field_146292_n.add(this.nextPageBtn);
        this.prevPageBtn = new GuiButton(11, shiftRightPage, this.field_146295_m / 2 - 50, 20, 20, "<");
        this.field_146292_n.add(this.prevPageBtn);
        for (int col = 0; col < 1; ++col) {
            for (int row = 0; row < 4; ++row) {
                int availableSize = 262;
                int baseX = leftEdge + 20 + col * 288;
                int onePart = availableSize / 5;
                GuiSliderRange minMaxSlider = new GuiSliderRange(100, baseX, topEdge + 18 + row * 18, onePart * 2 - 2, 18, "");
                minMaxSlider.addListener(slider -> {
                    int stackIndex;
                    List<GenericLootTable.RandomizedItemStack> chestContents = this.component.items;
                    if (slider.field_146127_k < 300 && (stackIndex = slider.field_146127_k - 200) < chestContents.size()) {
                        GenericLootTable.RandomizedItemStack chestContent = chestContents.get(stackIndex);
                        IntegerRange intRange = Ranges.roundedIntRange((FloatRange)minMaxSlider.getRange());
                        chestContent.min = intRange.getMin();
                        chestContent.max = intRange.getMax();
                        minMaxSlider.setRange(new FloatRange((float)chestContent.min, (float)chestContent.max));
                        this.updateAllItemSliders();
                    }
                });
                minMaxSlider.setMinValue(1.0f);
                this.field_146292_n.add(minMaxSlider);
                this.minMaxSliders.add(minMaxSlider);
                GuiSlider weightSlider = new GuiSlider(200, baseX + onePart * 2, topEdge + 18 + row * 18, onePart * 3, 18, IvTranslations.get((String)"reccomplex.gui.random.weight"));
                weightSlider.addListener(slider -> {
                    int stackIndex;
                    List<GenericLootTable.RandomizedItemStack> chestContents = this.component.items;
                    if (slider.field_146127_k < 200 && slider.field_146127_k >= 100 && (stackIndex = slider.field_146127_k - 100) < chestContents.size()) {
                        chestContents.get((int)stackIndex).weight = WEIGHT_SCALE.in(slider.getValue());
                        this.updateAllItemSliders();
                    }
                });
                weightSlider.setMinValue(WEIGHT_SCALE.out(0.0f));
                weightSlider.setMaxValue(WEIGHT_SCALE.out(100.0f));
                this.field_146292_n.add(weightSlider);
                this.weightSliders.add(weightSlider);
            }
        }
        this.setPage(this.currentPage);
    }

    public void setPage(int colShift) {
        this.currentPage = colShift;
        ((ContainerEditLootTableItems)this.field_147002_h).scrollTo(colShift);
        this.updateAllItemSliders();
        this.updatePageButtons();
    }

    private void updateAllItemSliders() {
        List<GenericLootTable.RandomizedItemStack> chestContents = this.component.items;
        for (int i = 0; i < this.weightSliders.size(); ++i) {
            GuiSlider weightSlider = this.weightSliders.get(i);
            GuiSliderRange minMaxSlider = this.minMaxSliders.get(i);
            int index = i + this.currentPage * 4;
            weightSlider.field_146127_k = index + 100;
            minMaxSlider.field_146127_k = index + 200;
            if (index < chestContents.size()) {
                GenericLootTable.RandomizedItemStack chestContent = chestContents.get(index);
                minMaxSlider.setRange(new FloatRange((float)chestContent.min, (float)chestContent.max));
                minMaxSlider.setMaxValue((float)chestContent.itemStack.func_77976_d());
                minMaxSlider.field_146124_l = true;
                minMaxSlider.field_146126_j = IvTranslations.format((String)"reccomplex.gui.inventorygen.minMax", (Object[])new Object[]{chestContent.min, chestContent.max});
                weightSlider.setValue(WEIGHT_SCALE.out((float)chestContent.weight));
                weightSlider.field_146124_l = true;
                weightSlider.field_146126_j = IvTranslations.format((String)"reccomplex.gui.inventorygen.weightNumber", (Object[])new Object[]{String.format("%.4f", Float.valueOf(WEIGHT_SCALE.in(weightSlider.getValue())))});
                continue;
            }
            minMaxSlider.setRange(new FloatRange(1.0f, 1.0f));
            minMaxSlider.setMaxValue(64.0f);
            minMaxSlider.field_146124_l = false;
            minMaxSlider.field_146126_j = IvTranslations.get((String)"reccomplex.gui.inventorygen.range");
            weightSlider.setValue(weightSlider.getMinValue());
            weightSlider.field_146124_l = false;
            weightSlider.field_146126_j = IvTranslations.format((String)"reccomplex.gui.random.weight", (Object[])new Object[0]);
        }
    }

    private void updatePageButtons() {
        List<GenericLootTable.RandomizedItemStack> chestContents = this.component.items;
        int neededSlots = chestContents.size() + 1;
        this.nextPageBtn.field_146124_l = (this.currentPage + 1) * 4 <= neededSlots;
        this.prevPageBtn.field_146124_l = this.currentPage > 0;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                RCGuiHandler.editLootTableComponent((EntityPlayer)this.field_146297_k.field_71439_g, this.key, this.component, this.saveDirectoryData);
            } else if (button.field_146127_k == 2) {
                GuiHider.hideGUI();
            } else if (button.field_146127_k == 10) {
                this.setPage(this.currentPage + 1);
                RecurrentComplex.network.sendToServer((IMessage)PacketGuiAction.packetGuiAction((String)"igSelectCol", (Number[])new Number[]{this.currentPage}));
            } else if (button.field_146127_k == 11) {
                this.setPage(this.currentPage - 1);
                RecurrentComplex.network.sendToServer((IMessage)PacketGuiAction.packetGuiAction((String)"igSelectCol", (Number[])new Number[]{this.currentPage}));
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) throws IOException {
        if (keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            return;
        }
        if (keyCode == 1) {
            if (this.backBtn != null) {
                this.func_146284_a(this.backBtn);
            }
            return;
        }
        super.func_73869_a(keyChar, keyCode);
        if (keyCode == 203 && this.prevPageBtn.field_146124_l) {
            this.func_146284_a(this.prevPageBtn);
        } else if (keyCode == 205 && this.nextPageBtn.field_146124_l) {
            this.func_146284_a(this.nextPageBtn);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return true;
    }

    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(textureBackground);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146294_l / 2 - 88 - 10 - 1, this.field_146295_m / 2 - 13, 0, 0, 176, 90);
        for (int i = 0; i < 4; ++i) {
            this.func_73729_b(this.field_146294_l / 2 - 144 - 11, this.field_146295_m / 2 - 91 + i * 18, 7, 7, 18, 18);
        }
    }

    private void drawPlaceholderString(GuiTextField textField, String string) {
        if (StringUtils.func_151246_b((String)textField.func_146179_b())) {
            this.func_73731_b(this.field_146289_q, string, textField.field_146209_f + 5, textField.field_146210_g + 7, -7829368);
        }
    }

    @Override
    public void inventoryChanged(IInventory inventory) {
        this.updateAllItemSliders();
        this.updatePageButtons();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0) {
            for (Object object : this.field_146292_n) {
                GuiButton button = (GuiButton)object;
                button.func_146118_a(mouseX, mouseY);
            }
        }
    }
}

