/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceGenerationType
extends TableDataSourceSegmented {
    public GenerationType genInfo;
    public TableDelegate delegate;

    public TableDataSourceGenerationType(GenerationType genInfo, TableNavigator navigator, TableDelegate delegate) {
        this.genInfo = genInfo;
        this.delegate = delegate;
        this.addSegment(0, () -> {
            TableCellString idCell = new TableCellString("genInfoID", genInfo.id());
            idCell.setShowsValidityState(true);
            idCell.setValidityState(this.currentIDState());
            idCell.addListener(val -> {
                genInfo.setID((String)val);
                idCell.setValidityState(this.currentIDState());
            });
            TableCellButton randomizeCell = new TableCellButton(null, null, IvTranslations.get((String)"reccomplex.gui.randomize.short"), IvTranslations.getLines((String)"reccomplex.gui.randomize"));
            randomizeCell.addAction(() -> {
                genInfo.setID(GenerationType.randomID(genInfo.getClass()));
                delegate.reloadData();
            });
            TableCellMulti cell = new TableCellMulti(idCell, randomizeCell);
            cell.setSize(1, 0.1f);
            return new TitledCell(IvTranslations.get((String)"reccomplex.structure.generation.id"), cell).withTitleTooltip(IvTranslations.formatLines((String)"reccomplex.structure.generation.id.tooltip", (Object[])new Object[0]));
        });
    }

    @Override
    @Nonnull
    public String title() {
        return this.genInfo.displayString();
    }

    protected GuiValidityStateIndicator.State currentIDState() {
        return Structures.isSimpleIDState(this.genInfo.id());
    }
}

