/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.tileentity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.sync.client.core.SyncSkinManager;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.block.BlockDualVertical;
import me.ichun.mods.sync.common.packet.PacketNBT;
import me.ichun.mods.sync.common.packet.PacketZoomCamera;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.shell.TeleporterShell;
import me.ichun.mods.sync.common.tileentity.TileEntityShellConstructor;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import me.ichun.mods.sync.common.tileentity.TileEntityTreadmill;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public abstract class TileEntityDualVertical<T extends TileEntityDualVertical>
extends TileEntity
implements ITickable {
    public T pair = null;
    public boolean top = false;
    public EnumFacing face = EnumFacing.SOUTH;
    public boolean vacating = false;
    public boolean isHomeUnit = false;
    protected String playerName = "";
    protected UUID playerUUID = null;
    protected String name = "";
    public T resyncOrigin = null;
    protected NBTTagCompound playerNBT = new NBTTagCompound();
    public ResourceLocation locationSkin;
    public boolean resync = false;
    public int resyncPlayer = 0;
    public int canSavePlayer = 0;
    public static final int animationTime = 40;
    protected int powReceived = 0;
    protected int rfIntake = 0;
    public boolean wasDead = false;

    public void func_73660_a() {
        if (this.resync) {
            EntityPlayerMP player;
            boolean hasPlayer;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, this.top ? -1 : 1, 0));
            if (tileEntity != null && tileEntity.getClass() == ((Object)((Object)this)).getClass()) {
                TileEntityDualVertical dualVertical = (TileEntityDualVertical)tileEntity;
                dualVertical.pair = this;
                this.pair = dualVertical;
            }
            if (this.field_145850_b.field_72995_K && (hasPlayer = StringUtils.isNotBlank((CharSequence)this.playerName))) {
                SyncSkinManager.get(this.playerName, this.playerUUID, resourceLocation -> {
                    this.locationSkin = resourceLocation;
                });
            }
            if (!this.field_145850_b.field_72995_K && this.playerUUID == null && this.field_145850_b.func_82737_E() % 100L == 0L && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(this.playerName)) != null && !player.func_110124_au().equals(EntityPlayer.func_175147_b((String)this.playerName))) {
                this.playerUUID = player.func_110124_au();
                IBlockState here = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, here, here, 19);
            }
        }
        if (this.top && this.pair != null) {
            this.setPlayerName(((TileEntityDualVertical)((Object)this.pair)).getPlayerName(), ((TileEntityDualVertical)((Object)this.pair)).playerUUID);
            this.setName(((TileEntityDualVertical)((Object)this.pair)).getName());
            this.vacating = ((TileEntityDualVertical)((Object)this.pair)).vacating;
        }
        if (!this.top && !this.field_145850_b.field_72995_K) {
            if (this.resyncPlayer > -10) {
                TileEntityShellStorage ss;
                EntityPlayerMP player;
                TileEntityShellStorage shellStorage;
                --this.resyncPlayer;
                if (this.resyncPlayer == 60) {
                    if (((Object)((Object)this)).getClass() == TileEntityShellStorage.class) {
                        shellStorage = (TileEntityShellStorage)this;
                        shellStorage.occupied = true;
                    }
                    if ((player = this.getPlayerIfAvailable()) != null) {
                        if (!player.func_70089_S()) {
                            player.func_70606_j(20.0f);
                            player.field_70128_L = false;
                        }
                        player.func_70066_B();
                        int dim = player.field_71093_bK;
                        if (player.field_71093_bK != this.field_145850_b.field_73011_w.getDimension()) {
                            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().transferPlayerToDimension(player, this.field_145850_b.field_73011_w.getDimension(), (Teleporter)new TeleporterShell((WorldServer)this.field_145850_b, this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v(), this.face.func_176734_d().func_185119_l(), 0.0f));
                            player = this.getPlayerIfAvailable();
                            if (dim == 1 && player.func_70089_S()) {
                                this.field_145850_b.func_72838_d((Entity)player);
                                player.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, this.face.func_176734_d().func_185119_l(), 0.0f);
                                this.field_145850_b.func_72866_a((Entity)player, false);
                                player.field_70143_R = 0.0f;
                            }
                        } else {
                            player.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, this.face.func_176734_d().func_185119_l(), 0.0f);
                            player.field_70143_R = 0.0f;
                        }
                        Sync.channel.sendTo((AbstractPacket)new PacketZoomCamera(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension(), this.face, true, false), (EntityPlayer)player);
                    }
                }
                if (this.resyncPlayer == 40) {
                    this.vacating = true;
                    if (((Object)((Object)this)).getClass() == TileEntityShellStorage.class) {
                        shellStorage = (TileEntityShellStorage)this;
                        shellStorage.occupied = true;
                        shellStorage.occupationTime = 40;
                    } else if (((Object)((Object)this)).getClass() == TileEntityShellConstructor.class) {
                        TileEntityShellConstructor shellConstructor = (TileEntityShellConstructor)this;
                        shellConstructor.doorOpen = true;
                    }
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                    IBlockState state1 = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, 1, 0));
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                    this.field_145850_b.func_184138_a(this.func_174877_v().func_177982_a(0, 1, 0), state1, state1, 3);
                }
                if (this.resyncPlayer == 30 && (player = this.getPlayerIfAvailable()) != null && player.func_70089_S()) {
                    EntityPlayerMP dummy;
                    player.func_70674_bp();
                    if (Sync.config.transferPersistentItems == 1) {
                        if (this.wasDead) {
                            EntityPlayerMP deadDummy = this.setupDummy(player);
                            this.mergeStoredInv(deadDummy.field_71071_by);
                        }
                        NBTTagCompound tag = new NBTTagCompound();
                        dummy = this.setupDummy(player);
                        dummy.func_189511_e(tag);
                        if (this.resyncOrigin != null) {
                            TileEntityDualVertical.deleteItemsFrom((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, (List<ItemStack>)dummy.field_71071_by.field_70462_a);
                            TileEntityDualVertical.deleteItemsFrom((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, (List<ItemStack>)dummy.field_71071_by.field_70460_b);
                            TileEntityDualVertical.deleteItemsFrom((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, (List<ItemStack>)dummy.field_71071_by.field_184439_c);
                            ((TileEntityDualVertical)((Object)this.resyncOrigin)).getPlayerNBT().func_74782_a("Inventory", (NBTBase)player.field_71071_by.func_70442_a(new NBTTagList()));
                            this.resyncOrigin.func_70296_d();
                            if (this.getPlayerNBT().func_74764_b("Inventory")) {
                                this.mergeStoredInv(dummy.field_71071_by);
                            }
                        } else {
                            dummy.field_71071_by.func_174888_l();
                        }
                        if (!this.getPlayerNBT().func_74764_b("Inventory")) {
                            tag.func_74768_a("sync_playerGameMode", player.field_71134_c.func_73081_b().func_77148_a());
                            this.setPlayerNBT(tag);
                        }
                    } else if (!this.getPlayerNBT().func_74764_b("Inventory")) {
                        NBTTagCompound tag = new NBTTagCompound();
                        dummy = this.setupDummy(player);
                        dummy.field_71071_by.func_174888_l();
                        dummy.func_189511_e(tag);
                        tag.func_74768_a("sync_playerGameMode", player.field_71134_c.func_73081_b().func_77148_a());
                        this.setPlayerNBT(tag);
                    }
                    this.wasDead = false;
                    NBTTagCompound persistentData = player.getEntityData();
                    if (persistentData != null) {
                        NBTTagCompound forgeData = this.playerNBT.func_74775_l("ForgeData");
                        forgeData.func_74782_a("PlayerPersisted", (NBTBase)player.getEntityData().func_74775_l("PlayerPersisted"));
                        persistentData.func_74757_a("isDeathSyncing", false);
                        forgeData.func_74757_a("isDeathSyncing", false);
                        this.playerNBT.func_74782_a("ForgeData", (NBTBase)forgeData);
                    }
                    NBTTagCompound persistent = player.getEntityData().func_74775_l("PlayerPersisted");
                    int healthReduction = persistent.func_74762_e("Sync_HealthReduction");
                    this.playerNBT.func_74782_a("EnderItems", (NBTBase)player.func_71005_bN().func_70487_g());
                    player.func_70020_e(this.getPlayerNBT());
                    if (healthReduction > 0) {
                        double curMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                        double morphMaxHealth = curMaxHealth - (double)healthReduction;
                        if (morphMaxHealth < 1.0) {
                            morphMaxHealth = 1.0;
                        }
                        if (morphMaxHealth != curMaxHealth) {
                            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(morphMaxHealth);
                        }
                    }
                    player.field_71134_c.func_73077_b(GameType.func_77146_a((int)this.getPlayerNBT().func_74762_e("sync_playerGameMode")));
                    Sync.channel.sendTo((AbstractPacket)new PacketNBT(this.getPlayerNBT()), (EntityPlayer)player);
                }
                if (this.resyncPlayer == 25) {
                    ShellHandler.syncInProgress.remove(this.getPlayerName());
                }
                if (this.resyncPlayer == 0) {
                    ShellHandler.removeShell(this.getPlayerName(), this);
                    if (((Object)((Object)this)).getClass() == TileEntityShellStorage.class) {
                        ss = (TileEntityShellStorage)this;
                        ss.occupied = true;
                    }
                }
                if (this.resyncPlayer == -10 && ((Object)((Object)this)).getClass() == TileEntityShellStorage.class) {
                    ss = (TileEntityShellStorage)this;
                    ss.occupied = true;
                }
            }
            if (this.canSavePlayer > 0) {
                --this.canSavePlayer;
            }
            if (this.canSavePlayer < 0) {
                this.canSavePlayer = 60;
            }
        }
        this.resync = false;
    }

    public void setup(T scPair, boolean isTop, EnumFacing placeYaw) {
        this.pair = scPair;
        this.top = isTop;
        this.face = placeYaw;
    }

    public float powerAmount() {
        float power = 0.0f;
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                TileEntity te;
                if (i == 0 && k == 0 || !((te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(i, 0, k))) instanceof TileEntityTreadmill) || ((TileEntityTreadmill)te).back) continue;
                power += ((TileEntityTreadmill)te).powerOutput();
            }
        }
        return power + (float)(this.field_145850_b.field_72995_K ? this.rfIntake : this.powReceived);
    }

    public float getBuildProgress() {
        return this.playerName.equals("") ? 0.0f : (float)Sync.config.shellConstructionPowerRequirement;
    }

    public boolean shouldRenderInPass(int pass) {
        BlockDualVertical.renderPass = pass;
        return pass == 0 || pass == 1;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74757_a("top", this.top);
        tag.func_74768_a("face", this.face.func_176736_b());
        tag.func_74757_a("vacating", this.vacating);
        tag.func_74757_a("isHomeUnit", this.isHomeUnit);
        tag.func_74778_a("playerName", this.canSavePlayer > 0 ? "" : this.playerName);
        if (this.playerUUID != null) {
            tag.func_186854_a("playerUUID", this.playerUUID);
        }
        tag.func_74778_a("name", this.name);
        tag.func_74782_a("playerNBT", (NBTBase)(this.canSavePlayer > 0 ? new NBTTagCompound() : this.playerNBT));
        tag.func_74768_a("rfIntake", this.rfIntake);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.top = tag.func_74767_n("top");
        this.face = EnumFacing.func_176731_b((int)tag.func_74762_e("face"));
        this.vacating = tag.func_74767_n("vacating");
        this.isHomeUnit = tag.func_74767_n("isHomeUnit");
        this.playerName = tag.func_74779_i("playerName");
        this.playerUUID = tag.func_150297_b("playerUUIDMost", 4) && tag.func_150297_b("playerUUIDLeast", 4) ? tag.func_186857_a("playerUUID") : null;
        System.err.println("Read playerUUID:" + (this.playerUUID == null ? "null" : this.playerUUID) + " for name " + this.playerName);
        this.name = tag.func_74779_i("name");
        this.playerNBT = tag.func_74775_l("playerNBT");
        this.rfIntake = tag.func_74762_e("rfIntake");
        this.resync = true;
    }

    private EntityPlayerMP setupDummy(EntityPlayerMP player) {
        boolean keepInv = this.field_145850_b.func_82736_K().func_82766_b("keepInventory");
        this.field_145850_b.func_82736_K().func_82764_b("keepInventory", "false");
        EntityPlayerMP dummy = new EntityPlayerMP(FMLCommonHandler.instance().getMinecraftServerInstance(), FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_71093_bK), EntityHelper.getGameProfile((String)player.func_70005_c_()), new PlayerInteractionManager((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_71093_bK)));
        dummy.field_71135_a = player.field_71135_a;
        dummy.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, this.face.func_176734_d().func_185119_l(), 0.0f);
        dummy.field_70143_R = 0.0f;
        dummy.func_193104_a(player, false);
        dummy.field_71093_bK = player.field_71093_bK;
        dummy.func_145769_d(player.func_145782_y());
        this.field_145850_b.func_82736_K().func_82764_b("keepInventory", Boolean.toString(keepInv));
        return dummy;
    }

    private static void deleteItemsFrom(NonNullList<ItemStack> inv, List<ItemStack> toDelete) {
        for (ItemStack stack : toDelete) {
            int index;
            if (stack.func_190926_b() || (index = inv.indexOf((Object)stack)) == -1) continue;
            inv.set(index, (Object)ItemStack.field_190927_a);
        }
    }

    private void mergeStoredInv(InventoryPlayer toMerge) {
        InventoryPlayer nbtSavedInv = new InventoryPlayer(null);
        nbtSavedInv.func_70443_b(this.getPlayerNBT().func_150295_c("Inventory", 10));
        this.mergeInvOrDrop((NonNullList<ItemStack>)nbtSavedInv.field_70462_a, (NonNullList<ItemStack>)toMerge.field_70462_a);
        this.mergeInvOrDrop((NonNullList<ItemStack>)nbtSavedInv.field_70460_b, (NonNullList<ItemStack>)toMerge.field_70460_b);
        this.mergeInvOrDrop((NonNullList<ItemStack>)nbtSavedInv.field_184439_c, (NonNullList<ItemStack>)toMerge.field_184439_c);
        this.getPlayerNBT().func_74782_a("Inventory", (NBTBase)nbtSavedInv.func_70442_a(new NBTTagList()));
    }

    private void mergeInvOrDrop(NonNullList<ItemStack> mergeInto, NonNullList<ItemStack> from) {
        for (ItemStack toInsert : from) {
            if (toInsert.func_190926_b()) continue;
            boolean inserted = false;
            for (int i = 0; i < mergeInto.size(); ++i) {
                ItemStack origStack = (ItemStack)mergeInto.get(i);
                if (!origStack.func_190926_b()) continue;
                mergeInto.set(i, (Object)toInsert);
                inserted = true;
                break;
            }
            if (inserted) continue;
            BlockPos dropPos = this.field_174879_c.func_177972_a(this.face).func_177984_a();
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)dropPos.func_177958_n(), (double)dropPos.func_177956_o(), (double)dropPos.func_177952_p(), toInsert);
            entityItem.func_174867_a(60);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    public void writeShellStateData(ByteBuf buffer) {
        if (this.top && this.pair != null) {
            ((TileEntityDualVertical)((Object)this.pair)).writeShellStateData(buffer);
            return;
        }
        buffer.writeLong(this.field_174879_c.func_177986_g());
        buffer.writeInt(this.field_145850_b.field_73011_w.getDimension());
        buffer.writeFloat(this.getBuildProgress());
        buffer.writeFloat(this.powerAmount());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.field_145850_b.field_73011_w.func_186058_p().func_186065_b());
        buffer.writeBoolean(((Object)((Object)this)).getClass() == TileEntityShellConstructor.class);
        buffer.writeBoolean(this.isHomeUnit);
        NBTTagCompound invTag = new NBTTagCompound();
        invTag.func_74782_a("Inventory", (NBTBase)TileEntityDualVertical.generateShowableEquipTags(this.playerNBT));
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)invTag);
    }

    public static NBTTagList generateShowableEquipTags(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        NBTTagList nbttaglist = tag.func_150295_c("Inventory", 10);
        boolean setMainHand = false;
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 9 && !setMainHand) {
                ItemStack itemstack = new ItemStack(nbttagcompound);
                if (itemstack.func_190926_b()) continue;
                setMainHand = true;
                list.func_74742_a((NBTBase)nbttagcompound);
                continue;
            }
            if (j > 100 && j < 104) {
                if (!setMainHand) {
                    list.func_74742_a((NBTBase)ItemStack.field_190927_a.serializeNBT());
                }
                list.func_74742_a((NBTBase)nbttagcompound);
                continue;
            }
            if (j != 150) continue;
            list.func_74742_a((NBTBase)nbttagcompound);
        }
        return list;
    }

    public static void addShowableEquipToPlayer(EntityPlayer player, NBTTagCompound tag) {
        NBTTagList nbttaglist = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = new ItemStack(nbttagcompound);
            if (itemstack.func_190926_b()) continue;
            if (j < 9) {
                player.func_184611_a(EnumHand.MAIN_HAND, itemstack);
                continue;
            }
            if (j == 150) {
                player.func_184611_a(EnumHand.OFF_HAND, itemstack);
                continue;
            }
            if (j >= 100 && j < 104) {
                player.field_71071_by.field_70460_b.set(j - 100, (Object)itemstack);
                continue;
            }
            Sync.LOGGER.error("Invalid slotID for showable equip " + j);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public Block func_145838_q() {
        return Sync.blockDualVertical;
    }

    public double func_145833_n() {
        return Sync.eventHandlerClient != null && Sync.eventHandlerClient.zoomTimer > 0 ? 16384.0 : 9216.0;
    }

    public void reset() {
        this.setPlayerName(null);
        this.setPlayerNBT(new NBTTagCompound());
        this.resyncOrigin = null;
    }

    public boolean matchesPlayer(EntityPlayer player) {
        UUID playerUUID = player.func_110124_au();
        String rightName = player.func_70005_c_();
        if (this.playerUUID != null && !EntityPlayer.func_175147_b((String)this.playerName).equals(playerUUID) && playerUUID.equals(this.playerUUID)) {
            if (!player.field_70170_p.field_72995_K && !rightName.equals(this.playerName)) {
                String oldPlayerName = this.playerName;
                Sync.LOGGER.info("Updating player name for UUID " + playerUUID + ": " + oldPlayerName + " -> " + rightName);
                Set dualVerticals = ShellHandler.playerShells.removeAll((Object)oldPlayerName);
                for (TileEntityDualVertical dualVertical : dualVerticals) {
                    if (!dualVertical.playerName.equals(oldPlayerName)) continue;
                    dualVertical.playerUUID = this.playerUUID;
                    dualVertical.playerName = rightName;
                    IBlockState state = this.field_145850_b.func_180495_p(dualVertical.field_174879_c);
                    this.field_145850_b.func_184138_a(dualVertical.field_174879_c, state, state, 19);
                }
                ShellHandler.playerShells.putAll((Object)rightName, (Iterable)dualVerticals);
                if (!rightName.equals(this.playerName)) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 19);
                    this.playerName = rightName;
                }
                ShellHandler.updatePlayerOfShells(player, null, true);
            }
            return true;
        }
        return this.playerName.equals(rightName);
    }

    @Nullable
    public EntityPlayerMP getPlayerIfAvailable() {
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        return this.playerUUID == null ? playerList.func_152612_a(this.getPlayerName()) : playerList.func_177451_a(this.playerUUID);
    }

    public void setPlayerName(String playerName, UUID uuid) {
        if (playerName == null) {
            playerName = "";
        }
        this.playerName = playerName;
        this.playerUUID = uuid;
    }

    public void setPlayerName(EntityPlayer player) {
        if (player == null) {
            this.setPlayerName("", null);
            return;
        }
        String playerName = player.func_70005_c_();
        if (!playerName.equals(this.playerName)) {
            UUID playerUUID = player.func_110124_au();
            this.setPlayerName(playerName, playerUUID == EntityPlayer.func_175147_b((String)playerName) ? null : playerUUID);
        }
    }

    public void setPlayerNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        this.playerNBT = tagCompound;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public String getPlayerName() {
        if (this.playerName == null) {
            this.setPlayerName(null);
        }
        return this.playerName;
    }

    @Nullable
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public NBTTagCompound getPlayerNBT() {
        if (this.playerNBT == null) {
            this.setPlayerNBT(new NBTTagCompound());
        }
        return this.playerNBT;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }
}

