/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common;

import java.util.HashMap;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.network.PacketChannel;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import me.ichun.mods.sync.client.core.EventHandlerClient;
import me.ichun.mods.sync.common.core.ChunkLoadHandler;
import me.ichun.mods.sync.common.core.CommandSync;
import me.ichun.mods.sync.common.core.Config;
import me.ichun.mods.sync.common.core.EventHandlerServer;
import me.ichun.mods.sync.common.core.ProxyCommon;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityTreadmill;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="sync", name="Sync", version="7.1.0", certificateFingerprint="4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:ichunutil@[7.2.0,8.0.0);after:waila", acceptableRemoteVersions="[7.1.0,7.2.0)", acceptedMinecraftVersions="[1.12,1.13)")
public class Sync {
    public static final String VERSION = "7.1.0";
    public static final String MOD_NAME = "Sync";
    public static final String MOD_ID = "sync";
    @Mod.Instance(value="sync")
    public static Sync instance;
    @SidedProxy(clientSide="me.ichun.mods.sync.client.core.ProxyClient", serverSide="me.ichun.mods.sync.common.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static final Logger LOGGER;
    public static final HashMap<Class, Integer> TREADMILL_ENTITY_HASH_MAP;
    public static EventHandlerServer eventHandlerServer;
    public static EventHandlerClient eventHandlerClient;
    public static CreativeTabs creativeTabSync;
    public static Config config;
    public static Block blockDualVertical;
    public static PacketChannel channel;
    public static Item itemShellConstructor;
    public static Item itemShellStorage;
    public static Item itemTreadmill;
    public static Item itemSyncCore;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile()));
        proxy.preInitMod();
        UpdateChecker.registerMod((UpdateChecker.ModVersionInfo)new UpdateChecker.ModVersionInfo(MOD_NAME, "1.12.2", VERSION, false));
        FMLInterModComms.sendMessage((String)"backtools", (String)"blacklist", (ItemStack)new ItemStack(itemShellConstructor, 1));
        FMLInterModComms.sendMessage((String)"backtools", (String)"blacklist", (ItemStack)new ItemStack(itemShellStorage, 1));
        FMLInterModComms.sendMessage((String)"backtools", (String)"blacklist", (ItemStack)new ItemStack(itemTreadmill, 1));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadHandler());
        FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"movabletile", (String)TileEntityDualVertical.class.getName());
        FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"movabletile", (String)TileEntityTreadmill.class.getName());
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"me.ichun.mods.sync.client.HUDHandlerWaila.callbackRegister");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"me.ichun.mods.sync.client.HUDHandlerTheOneProbe");
        TREADMILL_ENTITY_HASH_MAP.put(EntityWolf.class, 4);
        TREADMILL_ENTITY_HASH_MAP.put(EntityPig.class, 2);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSync());
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        ChunkLoadHandler.shellTickets.clear();
        ShellHandler.syncInProgress.clear();
        ShellHandler.playerShells.clear();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equals("treadmill")) continue;
            String[] s = message.getStringValue().split(":");
            if (s.length != 2) {
                LOGGER.log(Level.WARN, "Invalid IMC treadmill register (incorrect length) received from " + message.getSender());
                continue;
            }
            try {
                String entityClassName = s[0];
                int entityPower = Integer.valueOf(s[1]);
                Class<?> entityClass = Class.forName(entityClassName);
                if (EntityPlayer.class.isAssignableFrom(entityClass)) {
                    LOGGER.log(Level.WARN, "Seriously? You're gonna try that?");
                    continue;
                }
                TREADMILL_ENTITY_HASH_MAP.put(entityClass, entityPower);
                LOGGER.info(String.format("Registered IMC treadmill register from %s for %s with power %s", message.getSender(), entityClassName, entityPower));
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARN, "Invalid IMC treadmill register (power not integer) received from " + message.getSender());
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.WARN, "Invalid IMC treadmill register (class not found) received from " + message.getSender());
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_NAME);
        TREADMILL_ENTITY_HASH_MAP = new HashMap();
    }
}

