/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.List;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageModuleItem
extends GenericRFToolsItem
implements INBTPreservingIngredient {
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 0, 0, 0, -1};

    public StorageModuleItem() {
        super("storage_module");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("rftools:storage_module0", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation("rftools:storage_module1", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation("rftools:storage_module2", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)6, (ModelResourceLocation)new ModelResourceLocation("rftools:storage_module_remote", "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Place this module in a storage module tablet to access contents"));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void updateStackSize(ItemStack stack, int numStacks) {
        if (stack.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("count", numStacks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        int max = MAXSIZE[itemStack.func_77952_i()];
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            StorageModuleItem.addModuleInformation(list, max, tagCompound);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This storage module is for the Modular Storage block.");
            if (max == -1) {
                list.add(TextFormatting.WHITE + "This module supports a remote inventory.");
                list.add(TextFormatting.WHITE + "Link to another storage module in the remote storage block.");
            } else {
                list.add(TextFormatting.WHITE + "This module supports " + max + " stacks");
            }
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static void addModuleInformation(List<String> list, int max, NBTTagCompound tagCompound) {
        if (max == -1) {
            if (tagCompound.func_74764_b("id")) {
                int id = tagCompound.func_74762_e("id");
                list.add(TextFormatting.GREEN + "Remote id: " + id);
            } else {
                list.add(TextFormatting.YELLOW + "Unlinked");
            }
        } else {
            int cnt = tagCompound.func_74762_e("count");
            if (tagCompound.func_74764_b("id")) {
                int id = tagCompound.func_74762_e("id");
                list.add(TextFormatting.GREEN + "Contents id: " + id);
            }
            list.add(TextFormatting.GREEN + "Contents: " + cnt + "/" + max + " stacks");
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + itemStack.func_77952_i();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 7; ++i) {
                if (MAXSIZE[i] == 0) continue;
                items.add((Object)new ItemStack((Item)ModularStorageSetup.storageModuleItem, 1, i));
            }
        }
    }
}

