/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.metatileentities.multiblock.standard;

import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregicality.multiblocks.api.metatileentity.GCYMMultiblockAbility;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityLargeDistillery
extends GCYMRecipeMapMultiblockController
implements IDistillationTower {
    protected final DistillationTowerLogicHandler handler;

    public MetaTileEntityLargeDistillery(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, new RecipeMap[]{RecipeMaps.DISTILLATION_RECIPES, RecipeMaps.DISTILLERY_RECIPES});
        this.recipeMapWorkable = new LargeDistilleryRecipeLogic((RecipeMapMultiblockController)this);
        this.handler = new DistillationTowerLogicHandler((IDistillationTower)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityLargeDistillery(this.metaTileEntityId);
    }

    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.UP.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        FluidStack stackInTank;
        if (this.isStructureFormed() && (stackInTank = this.importFluids.drain(Integer.MAX_VALUE, false)) != null && stackInTank.amount > 0) {
            ITextComponent fluidName = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation((FluidStack)stackInTank), (TextFormatting)TextFormatting.AQUA);
            textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.distillation_tower.distilling_fluid", (Object[])new Object[]{fluidName}));
        }
        super.addDisplayText(textList);
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (!this.usesAdvHatchLogic() || this.structurePattern == null) {
            return;
        }
        this.handler.determineLayerCount(this.structurePattern);
        this.handler.determineOrderedFluidOutputs();
    }

    protected boolean usesAdvHatchLogic() {
        return this.getCurrentRecipeMap() == RecipeMaps.DISTILLATION_RECIPES;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.usesAdvHatchLogic()) {
            this.handler.invalidate();
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casingPredicate = MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeDistillery.getCasingState()}).setMinGlobalLimited(40);
        TraceabilityPredicate maintenancePredicate = this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance ? MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH}).setMinGlobalLimited(1).setMaxGlobalLimited(1) : casingPredicate;
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.DOWN).aisle(new String[]{"#####", "#ZZZ#", "#ZCZ#", "#ZZZ#", "#####"}).aisle(new String[]{"##X##", "#XAX#", "XAPAX", "#XAX#", "##X##"}).setRepeatable(1, 12).aisle(new String[]{"#YSY#", "YAAAY", "YATAY", "YAAAY", "#YYY#"}).aisle(new String[]{"#YYY#", "YYYYY", "YYYYY", "YYYYY", "#YYY#"}).where('S', this.selfPredicate()).where('Y', casingPredicate.or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS})).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(2)).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMinGlobalLimited(1)).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS})).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{GCYMMultiblockAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1).setPreviewCount(1)).or(maintenancePredicate)).where('X', casingPredicate.or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}).setMinLayerLimited(1).setMaxLayerLimited(1, 1))).where('Z', casingPredicate).where('P', MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeDistillery.getCasingState2()})).where('C', MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('T', MetaTileEntityLargeDistillery.tieredCasing().or(MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{MetaTileEntityLargeDistillery.getCasingState2()}))).where('A', MetaTileEntityLargeDistillery.air()).where('#', MetaTileEntityLargeDistillery.any()).build();
    }

    public boolean allowSameFluidFillForOutputs() {
        return !this.usesAdvHatchLogic();
    }

    private static IBlockState getCasingState() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState(BlockLargeMultiblockCasing.CasingType.WATERTIGHT_CASING);
    }

    private static IBlockState getCasingState2() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GCYMTextures.WATERTIGHT_CASING;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @NotNull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return GCYMTextures.LARGE_DISTILLERY_OVERLAY;
    }

    public int getFluidOutputLimit() {
        if (this.usesAdvHatchLogic()) {
            return this.handler.getLayerCount();
        }
        return super.getFluidOutputLimit();
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean isTiered() {
        return false;
    }

    private class LargeDistilleryRecipeLogic
    extends GCYMMultiblockRecipeLogic {
        public LargeDistilleryRecipeLogic(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        protected void outputRecipeOutputs() {
            if (MetaTileEntityLargeDistillery.this.usesAdvHatchLogic()) {
                GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), (boolean)false, (List)this.itemOutputs);
                MetaTileEntityLargeDistillery.this.handler.applyFluidToOutputs(this.fluidOutputs, true);
            } else {
                super.outputRecipeOutputs();
            }
        }

        protected boolean setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory, @NotNull IMultipleTankHandler importFluids) {
            if (!MetaTileEntityLargeDistillery.this.usesAdvHatchLogic()) {
                return super.setupAndConsumeRecipeInputs(recipe, importInventory, importFluids);
            }
            this.overclockResults = this.calculateOverclock(recipe);
            this.modifyOverclockPost(this.overclockResults, recipe.getRecipePropertyStorage());
            if (!this.hasEnoughPower(this.overclockResults)) {
                return false;
            }
            IItemHandlerModifiable exportInventory = this.getOutputInventory();
            if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)exportInventory, (boolean)true, (List)recipe.getAllItemOutputs())) {
                this.isOutputsFull = true;
                return false;
            }
            if (!this.metaTileEntity.canVoidRecipeFluidOutputs() && !MetaTileEntityLargeDistillery.this.handler.applyFluidToOutputs(recipe.getAllFluidOutputs(), false)) {
                this.isOutputsFull = true;
                return false;
            }
            this.isOutputsFull = false;
            if (recipe.matches(true, importInventory, importFluids)) {
                this.metaTileEntity.addNotifiedInput((Object)importInventory);
                return true;
            }
            return false;
        }

        protected IMultipleTankHandler getOutputTank() {
            if (MetaTileEntityLargeDistillery.this.usesAdvHatchLogic()) {
                return MetaTileEntityLargeDistillery.this.handler.getFluidTanks();
            }
            return super.getOutputTank();
        }
    }
}

