/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.block.blocks;

import gregtech.api.block.VariantActiveBlock;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public class BlockUniqueCasing
extends VariantActiveBlock<UniqueCasingType> {
    public BlockUniqueCasing() {
        super(Material.field_151573_f);
        this.func_149663_c("unique_casing");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 2);
        this.func_180632_j(this.getState(UniqueCasingType.CRUSHING_WHEELS));
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        UniqueCasingType type = (UniqueCasingType)this.getState(state);
        if (type == UniqueCasingType.MOLYBDENUM_DISILICIDE_COIL ? layer == BlockRenderLayer.SOLID : layer == BlockRenderLayer.CUTOUT) {
            return true;
        }
        if (this.isBloomEnabled(type)) {
            return layer == BloomEffectUtil.getEffectiveBloomLayer((BlockRenderLayer)layer);
        }
        return layer == BlockRenderLayer.CUTOUT;
    }

    protected boolean isBloomEnabled(UniqueCasingType value) {
        if (ConfigHolder.client.coilsActiveEmissiveTextures && value == UniqueCasingType.MOLYBDENUM_DISILICIDE_COIL) {
            return true;
        }
        return value == UniqueCasingType.HEAT_VENT;
    }

    public static enum UniqueCasingType implements IStringSerializable
    {
        CRUSHING_WHEELS("crushing_wheels"),
        SLICING_BLADES("slicing_blades"),
        ELECTROLYTIC_CELL("electrolytic_cell"),
        HEAT_VENT("heat_vent"),
        MOLYBDENUM_DISILICIDE_COIL("molybdenum_disilicide_coil");

        private final String name;

        private UniqueCasingType(String name) {
            this.name = name;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }
    }
}

