/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.unification.properties;

import com.google.common.base.Preconditions;
import gregicality.multiblocks.api.recipes.alloyblast.AlloyBlastRecipeProducer;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import org.jetbrains.annotations.NotNull;

public class AlloyBlastProperty
implements IMaterialProperty {
    private int temperature;
    private boolean canGenerateMolten = true;
    private boolean forceGenerateMolten = false;
    private AlloyBlastRecipeProducer recipeProducer = AlloyBlastRecipeProducer.DEFAULT_PRODUCER;

    public AlloyBlastProperty(int temperature) {
        this.temperature = temperature;
    }

    public void verifyProperty(@NotNull MaterialProperties materialProperties) {
        materialProperties.ensureSet(PropertyKey.BLAST);
        materialProperties.ensureSet(PropertyKey.FLUID);
        this.temperature = ((BlastProperty)materialProperties.getProperty(PropertyKey.BLAST)).getBlastTemperature();
    }

    public void setTemperature(int fluidTemperature) {
        Preconditions.checkArgument((fluidTemperature > 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        this.temperature = fluidTemperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setRecipeProducer(@NotNull AlloyBlastRecipeProducer recipeProducer) {
        this.recipeProducer = recipeProducer;
    }

    @NotNull
    public AlloyBlastRecipeProducer getRecipeProducer() {
        return this.recipeProducer;
    }

    public void setCanGenerateMolten(boolean canGenerateMolten) {
        this.canGenerateMolten = canGenerateMolten;
    }

    public void setForceGenerateMolten(boolean forceGenerateMolten) {
        this.forceGenerateMolten = forceGenerateMolten;
    }

    public boolean shouldGenerateMolten(@NotNull Material material) {
        if (this.forceGenerateMolten) {
            return true;
        }
        return this.canGenerateMolten && OrePrefix.ingotHot.doGenerateItem(material);
    }
}

