/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.recipes.alloyblast;

import com.google.common.base.Preconditions;
import gregicality.multiblocks.api.recipes.alloyblast.AlloyBlastRecipeProducer;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.unification.material.Material;
import org.jetbrains.annotations.NotNull;

public class CustomAlloyBlastRecipeProducer
extends AlloyBlastRecipeProducer {
    private final int circuitNum;
    private final int gasCircuitNum;
    private final int outputAmount;

    public CustomAlloyBlastRecipeProducer(int circuitNum, int gasCircuitNum, int outputAmount) {
        this.circuitNum = circuitNum;
        this.gasCircuitNum = gasCircuitNum;
        Preconditions.checkArgument((outputAmount != 0 ? 1 : 0) != 0, (Object)"output amount cannot be zero");
        this.outputAmount = outputAmount;
    }

    @Override
    protected int addInputs(@NotNull Material material, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        int amount = super.addInputs(material, builder);
        return this.outputAmount < 0 ? amount : this.outputAmount;
    }

    @Override
    protected int getCircuitNum(int componentAmount) {
        return this.circuitNum < 0 ? super.getCircuitNum(componentAmount) : this.circuitNum;
    }

    @Override
    protected int getGasCircuitNum(int componentAmount) {
        return this.gasCircuitNum < 0 ? super.getGasCircuitNum(componentAmount) : this.gasCircuitNum;
    }
}

