/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DecompositionRecipeHandler {
    public static void runRecipeGeneration() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            OrePrefix prefix = material.hasProperty(PropertyKey.DUST) ? OrePrefix.dust : null;
            DecompositionRecipeHandler.processDecomposition(prefix, material);
        }
    }

    private static void processDecomposition(OrePrefix decomposePrefix, Material material) {
        if (material.getMaterialComponents().isEmpty() || !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) && !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION) || material.getMaterialComponents().size() > 6) {
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        int totalInputAmount = 0;
        for (MaterialStack component : material.getMaterialComponents()) {
            totalInputAmount = (int)((long)totalInputAmount + component.amount);
            if (component.material.hasProperty(PropertyKey.DUST)) {
                outputs.add(OreDictUnifier.get(OrePrefix.dust, component.material, (int)component.amount));
                continue;
            }
            if (!component.material.hasProperty(PropertyKey.FLUID)) continue;
            fluidOutputs.add(component.material.getFluid((int)(1000L * component.amount)));
        }
        if (decomposePrefix != null) {
            ArrayList<Integer> materialAmounts = new ArrayList<Integer>();
            materialAmounts.add(totalInputAmount);
            outputs.forEach(itemStack -> materialAmounts.add(itemStack.func_190916_E()));
            fluidOutputs.forEach(fluidStack -> materialAmounts.add(fluidStack.amount / 1000));
            int highestDivisor = 1;
            int smallestMaterialAmount = DecompositionRecipeHandler.getSmallestMaterialAmount(materialAmounts);
            for (int i = 2; i <= smallestMaterialAmount; ++i) {
                if (!DecompositionRecipeHandler.isEveryMaterialReducible(i, materialAmounts)) continue;
                highestDivisor = i;
            }
            if (highestDivisor != 1) {
                ArrayList<ItemStack> reducedOutputs = new ArrayList<ItemStack>();
                for (ItemStack itemStack2 : outputs) {
                    ItemStack reducedStack = itemStack2.func_77946_l();
                    reducedStack.func_190920_e(reducedStack.func_190916_E() / highestDivisor);
                    reducedOutputs.add(reducedStack);
                }
                ArrayList<FluidStack> reducedFluidOutputs = new ArrayList<FluidStack>();
                for (FluidStack fluidStack2 : fluidOutputs) {
                    FluidStack reducedFluidStack = fluidStack2.copy();
                    reducedFluidStack.amount /= highestDivisor;
                    reducedFluidOutputs.add(reducedFluidStack);
                }
                outputs = reducedOutputs;
                fluidOutputs = reducedFluidOutputs;
                totalInputAmount /= highestDivisor;
            }
        }
        Object builder = material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) ? ((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().duration((int)material.getProtons() * totalInputAmount * 2)).EUt(material.getMaterialComponents().size() <= 2 ? GTValues.VA[1] : 2 * GTValues.VA[1]) : ((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration((int)Math.ceil((double)(material.getMass() * (long)totalInputAmount) * 1.5))).EUt(GTValues.VA[1]);
        ((RecipeBuilder)builder).outputs(outputs);
        ((RecipeBuilder)builder).fluidOutputs(fluidOutputs);
        if (decomposePrefix != null) {
            ((RecipeBuilder)builder).input(decomposePrefix, material, totalInputAmount);
        } else {
            ((RecipeBuilder)builder).fluidInputs(material.getFluid(1000));
        }
        ((RecipeBuilder)builder).buildAndRegister();
    }

    private static boolean isEveryMaterialReducible(int divisor, List<Integer> materialAmounts) {
        for (int amount : materialAmounts) {
            if (amount % divisor == 0) continue;
            return false;
        }
        return true;
    }

    private static int getSmallestMaterialAmount(List<Integer> materialAmounts) {
        return materialAmounts.stream().min(Integer::compare).orElse(0);
    }
}

