/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.GTValues;
import gregtech.api.items.OreDictNames;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class VanillaOverrideRecipes {
    public static void init() {
        VanillaOverrideRecipes.woodRecipes();
        if (ConfigHolder.recipes.hardGlassRecipes) {
            VanillaOverrideRecipes.glassRecipes();
        }
        if (ConfigHolder.recipes.hardRedstoneRecipes) {
            VanillaOverrideRecipes.redstoneRecipes();
        }
        if (ConfigHolder.recipes.hardIronRecipes) {
            VanillaOverrideRecipes.metalRecipes();
        }
        if (ConfigHolder.recipes.hardAdvancedIronRecipes) {
            VanillaOverrideRecipes.metalAdvancedRecipes();
        }
        if (ConfigHolder.recipes.hardMiscRecipes) {
            VanillaOverrideRecipes.miscRecipes();
        }
        if (ConfigHolder.recipes.hardDyeRecipes) {
            VanillaOverrideRecipes.dyeRecipes();
        }
        if (ConfigHolder.recipes.harderBrickRecipes) {
            ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151119_aD, 1, Short.MAX_VALUE));
            ModHandler.removeRecipeByName("minecraft:brick_block");
            ModHandler.addShapedRecipe("brick_from_water", new ItemStack(Blocks.field_150336_V, 2), "BBB", "BWB", "BBB", Character.valueOf('B'), new ItemStack(Items.field_151118_aC), Character.valueOf('W'), new ItemStack(Items.field_151131_as));
            ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150424_aL));
        }
        VanillaOverrideRecipes.removeCompressionRecipes();
        VanillaOverrideRecipes.toolArmorRecipes();
        VanillaOverrideRecipes.alwaysRemovedRecipes();
    }

    private static void woodRecipes() {
        if (ConfigHolder.recipes.nerfWoodCrafting) {
            ModHandler.removeRecipeByName(new ResourceLocation("minecraft:stick"));
            ModHandler.addShapedRecipe("stick_saw", new ItemStack(Items.field_151055_y, 4), "s", "P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
            ModHandler.addShapedRecipe("stick_normal", new ItemStack(Items.field_151055_y, 2), "P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        }
        if (ConfigHolder.recipes.nerfPaperCrafting) {
            ModHandler.removeRecipeByName(new ResourceLocation("minecraft:paper"));
            ModHandler.removeRecipeByName(new ResourceLocation("minecraft:sugar"));
            ModHandler.addShapedRecipe("paper_dust", OreDictUnifier.get(OrePrefix.dust, Materials.Paper, 2), "SSS", " m ", Character.valueOf('S'), new ItemStack(Items.field_151120_aE));
            ModHandler.addShapedRecipe("sugar", OreDictUnifier.get(OrePrefix.dust, Materials.Sugar, 1), "Sm ", Character.valueOf('S'), new ItemStack(Items.field_151120_aE));
            ModHandler.addShapedRecipe("paper", new ItemStack(Items.field_151121_aF, 2), " r ", "SSS", " B ", Character.valueOf('S'), OreDictUnifier.get(OrePrefix.dust, Materials.Paper), Character.valueOf('B'), new ItemStack(Items.field_151131_as));
        }
        if (!ConfigHolder.recipes.hardWoodRecipes) {
            return;
        }
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:ladder"));
        ModHandler.addShapedRecipe("ladder", new ItemStack(Blocks.field_150468_ap, 2), "SrS", "SRS", "ShS", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.bolt, Materials.Wood));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:trapdoor"));
        ModHandler.addShapedRecipe("trapdoor", new ItemStack(Blocks.field_150415_aT), "SRS", "RRR", "SRS", Character.valueOf('S'), new UnificationEntry(OrePrefix.slab, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("bowl", new ItemStack(Items.field_151054_z), "k", "X", Character.valueOf('X'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:bowl"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:chest"));
        ModHandler.addShapedRecipe("chest", new ItemStack((Block)Blocks.field_150486_ae), "LPL", "PFP", "LPL", Character.valueOf('L'), new UnificationEntry(OrePrefix.log, Materials.Wood), Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak));
    }

    private static void glassRecipes() {
        ModHandler.removeFurnaceSmelting(new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
        ModHandler.removeRecipeByOutput(new ItemStack(Items.field_151069_bo, 3));
    }

    private static void redstoneRecipes() {
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:dispenser"));
        ModHandler.addShapedRecipe("dispenser", new ItemStack(Blocks.field_150367_z), new Object[]{"CRC", "STS", "GAG", Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.spring, Materials.Iron), Character.valueOf('T'), new ItemStack(Items.field_151007_F), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('A'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy)});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).inputs(new ItemStack(Blocks.field_150347_e, 2))).input(OrePrefix.ring, Materials.Iron)).input(OrePrefix.spring, Materials.Iron, 2)).input(OrePrefix.gearSmall, Materials.Iron, 2)).input(OrePrefix.stick, Materials.RedAlloy)).inputs(new ItemStack(Items.field_151007_F))).outputs(new ItemStack(Blocks.field_150367_z))).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:sticky_piston"));
        ModHandler.addShapedRecipe("sticky_piston", new ItemStack((Block)Blocks.field_150320_F, 1), "h", "R", "P", Character.valueOf('R'), "slimeball", Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:piston"));
        ModHandler.addShapedRecipe("piston_iron", new ItemStack((Block)Blocks.field_150331_J), new Object[]{"WWW", "GFG", "CRC", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.plate, Materials.RedAlloy), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('F'), OreDictNames.fenceWood});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Iron)).input(OrePrefix.gearSmall, Materials.Iron)).input(OrePrefix.slab, Materials.Wood, 1)).input("cobblestone", 1)).fluidInputs(Materials.RedAlloy.getFluid(144))).outputs(new ItemStack((Block)Blocks.field_150331_J))).duration(240)).EUt(GTValues.VA[0])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Steel)).input(OrePrefix.gearSmall, Materials.Steel)).input(OrePrefix.slab, Materials.Wood, 2)).input("cobblestone", 2)).fluidInputs(Materials.RedAlloy.getFluid(288))).outputs(new ItemStack((Block)Blocks.field_150331_J, 2))).duration(240)).EUt(16)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Aluminium)).input(OrePrefix.gearSmall, Materials.Aluminium)).input(OrePrefix.slab, Materials.Wood, 4)).input("cobblestone", 4)).fluidInputs(Materials.RedAlloy.getFluid(432))).outputs(new ItemStack((Block)Blocks.field_150331_J, 4))).duration(240)).EUt(GTValues.VA[1])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.StainlessSteel)).input(OrePrefix.gearSmall, Materials.StainlessSteel)).input(OrePrefix.slab, Materials.Wood, 8)).input("cobblestone", 8)).fluidInputs(Materials.RedAlloy.getFluid(576))).outputs(new ItemStack((Block)Blocks.field_150331_J, 8))).duration(600)).EUt(GTValues.VA[1])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Titanium)).input(OrePrefix.gearSmall, Materials.Titanium)).input(OrePrefix.slab, Materials.Wood, 16)).input("cobblestone", 16)).fluidInputs(Materials.RedAlloy.getFluid(1152))).outputs(new ItemStack((Block)Blocks.field_150331_J, 16))).duration(800)).EUt(GTValues.VA[1])).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:stone_pressure_plate"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:wooden_pressure_plate"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:heavy_weighted_pressure_plate"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:light_weighted_pressure_plate"));
        ModHandler.addShapedRecipe("stone_pressure_plate", new ItemStack(Blocks.field_150456_au, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('L'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('C'), new UnificationEntry(OrePrefix.spring, Materials.Iron));
        ModHandler.addShapedRecipe("wooden_pressure_plate", new ItemStack(Blocks.field_150452_aw, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(OrePrefix.bolt, Materials.Wood), Character.valueOf('L'), new UnificationEntry(OrePrefix.plate, Materials.Wood), Character.valueOf('C'), new UnificationEntry(OrePrefix.spring, Materials.Iron));
        ModHandler.addShapedRecipe("heavy_weighted_pressure_plate", new ItemStack(Blocks.field_150445_bS), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel), Character.valueOf('L'), new UnificationEntry(OrePrefix.plate, Materials.Gold), Character.valueOf('C'), new UnificationEntry(OrePrefix.spring, Materials.Steel));
        ModHandler.addShapedRecipe("light_weighted_pressure_plate", new ItemStack(Blocks.field_150443_bT), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel), Character.valueOf('L'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('C'), new UnificationEntry(OrePrefix.spring, Materials.Steel));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.spring, Materials.Iron)).inputs(new ItemStack((Block)Blocks.field_150333_U, 2))).outputs(new ItemStack(Blocks.field_150456_au, 2))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.spring, Materials.Iron)).input(OrePrefix.plank, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_150452_aw, 2))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.spring, Materials.Steel)).input(OrePrefix.plate, Materials.Gold)).outputs(new ItemStack(Blocks.field_150445_bS))).duration(200)).EUt(16)).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.spring, Materials.Steel)).input(OrePrefix.plate, Materials.Iron)).outputs(new ItemStack(Blocks.field_150443_bT))).duration(200)).EUt(16)).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:stone_button"));
        ModHandler.addShapedRecipe("stone_button", new ItemStack(Blocks.field_150430_aB, 6), "sP", Character.valueOf('P'), new ItemStack(Blocks.field_150456_au));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:wooden_button"));
        ModHandler.addShapedRecipe("wooden_button", new ItemStack(Blocks.field_150471_bO, 6), "sP", Character.valueOf('P'), new ItemStack(Blocks.field_150452_aw));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150456_au))).outputs(new ItemStack(Blocks.field_150430_aB, 12))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150452_aw))).outputs(new ItemStack(Blocks.field_150471_bO, 12))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:lever"));
        ModHandler.addShapedRecipe("lever", new ItemStack(Blocks.field_150442_at), "B", "S", Character.valueOf('B'), new ItemStack(Blocks.field_150430_aB), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:daylight_detector"));
        ModHandler.removeRecipeByName(new ResourceLocation("appliedenergistics2:misc/vanilla_daylight_detector"));
        ModHandler.addShapedRecipe("daylight_detector", new ItemStack((Block)Blocks.field_150453_bW), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.NetherQuartz), Character.valueOf('S'), new UnificationEntry(OrePrefix.slab, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ModHandler.addShapedRecipe("daylight_detector_certus", new ItemStack((Block)Blocks.field_150453_bW), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.CertusQuartz), Character.valueOf('S'), new UnificationEntry(OrePrefix.slab, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ModHandler.addShapedRecipe("daylight_detector_quartzite", new ItemStack((Block)Blocks.field_150453_bW), "GGG", "PPP", "SRS", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Quartzite), Character.valueOf('S'), new UnificationEntry(OrePrefix.slab, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:redstone_lamp"));
        ModHandler.addShapedRecipe("redstone_lamp", new ItemStack(Blocks.field_150379_bu), "PPP", "PGP", "PRP", Character.valueOf('P'), new ItemStack(Blocks.field_150410_aZ, 1, Short.MAX_VALUE), Character.valueOf('G'), new UnificationEntry(OrePrefix.block, Materials.Glowstone), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:tripwire_hook"));
        ModHandler.addShapedRecipe("tripwire_hook", new ItemStack((Block)Blocks.field_150479_bC), "IRI", "SRS", " S ", Character.valueOf('I'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('S'), new ItemStack(Items.field_151007_F));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:dropper"));
        ModHandler.addShapedRecipe("dropper", new ItemStack(Blocks.field_150409_cd), new Object[]{"CRC", "STS", "GAG", Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.springSmall, Materials.Iron), Character.valueOf('T'), new ItemStack(Items.field_151007_F), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('A'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy)});
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:observer"));
        ModHandler.addShapedRecipe("observer", new ItemStack(Blocks.field_190976_dk), new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.NetherQuartz), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy)});
        ModHandler.addShapedRecipe("observer_certus", new ItemStack(Blocks.field_190976_dk), new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.CertusQuartz), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy)});
        ModHandler.addShapedRecipe("observer_quartzite", new ItemStack(Blocks.field_190976_dk), new Object[]{"RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.Quartzite), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy)});
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:repeater"));
        ModHandler.addShapedRecipe("repeater", new ItemStack(Items.field_151107_aW), "S S", "TdT", "PRP", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('P'), new ItemStack(Blocks.field_150456_au), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:comparator"));
        ModHandler.removeRecipeByName(new ResourceLocation("appliedenergistics2:misc/vanilla_comparator"));
        ModHandler.addShapedRecipe("comparator", new ItemStack(Items.field_151132_bS), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.NetherQuartz), Character.valueOf('P'), new ItemStack(Blocks.field_150456_au));
        ModHandler.addShapedRecipe("comparator_certus", new ItemStack(Items.field_151132_bS), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.CertusQuartz), Character.valueOf('P'), new ItemStack(Blocks.field_150456_au));
        ModHandler.addShapedRecipe("comparator_quartzite", new ItemStack(Items.field_151132_bS), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('Q'), new UnificationEntry(OrePrefix.plate, Materials.Quartzite), Character.valueOf('P'), new ItemStack(Blocks.field_150456_au));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:golden_rail"));
        ModHandler.addShapedRecipe("golden_rail", new ItemStack(Blocks.field_150318_D, 6), "SPS", "IWI", "GdG", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.RedAlloy), Character.valueOf('I'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('W'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('G'), new UnificationEntry(OrePrefix.stick, Materials.Gold));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:detector_rail"));
        ModHandler.addShapedRecipe("detector_rail", new ItemStack(Blocks.field_150319_E, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('P'), new ItemStack(Blocks.field_150443_bT), Character.valueOf('I'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('W'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:rail"));
        ModHandler.addShapedRecipe("rail", new ItemStack(Blocks.field_150448_aq, 8), "ShS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('I'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('W'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:activator_rail"));
        ModHandler.addShapedRecipe("activator_rail", new ItemStack(Blocks.field_150408_cc, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('P'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('I'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('W'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:redstone_torch"));
        ModHandler.addShapedRecipe("redstone_torch", new ItemStack(Blocks.field_150429_aA), "R", "T", Character.valueOf('R'), new UnificationEntry(OrePrefix.dust, Materials.Redstone), Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa));
    }

    private static void metalRecipes() {
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:cauldron"));
        ModHandler.addShapedRecipe("cauldron", new ItemStack(Items.field_151066_bu), "X X", "XhX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:hopper"));
        ModHandler.addShapedRecipe("hopper", new ItemStack((Block)Blocks.field_150438_bZ), "XCX", "XGX", "wXh", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('C'), "chestWood", Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:iron_bars"));
        ModHandler.addShapedRecipe("iron_bars", new ItemStack(Blocks.field_150411_aY, 8), " h ", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, Materials.Iron));
        ModHandler.addShapedRecipe("iron_bucket", new ItemStack(Items.field_151133_ar), "XhX", " X ", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:bucket"));
    }

    private static void metalAdvancedRecipes() {
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:iron_door"));
        ModHandler.addShapedRecipe("iron_door", new ItemStack(Items.field_151139_aw), "PTh", "PRS", "PPd", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Steel), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 4)).inputs(new ItemStack(Blocks.field_150411_aY))).fluidInputs(Materials.Steel.getFluid(16))).outputs(new ItemStack(Items.field_151139_aw))).duration(400)).EUt(GTValues.VA[0])).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:anvil"));
        ModHandler.addShapedRecipe("anvil", new ItemStack(Blocks.field_150467_bQ), "BBB", "SBS", "PBP", Character.valueOf('B'), new UnificationEntry(OrePrefix.block, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:iron_trapdoor"));
        ModHandler.addShapedRecipe("iron_trapdoor", new ItemStack(Blocks.field_180400_cw), "SPS", "PTP", "sPd", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT));
    }

    private static void miscRecipes() {
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:tnt"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:beacon"));
        ModHandler.addShapedRecipe("beacon", new ItemStack((Block)Blocks.field_150461_bJ), "GLG", "GSG", "OOO", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('L'), new UnificationEntry(OrePrefix.lens, Materials.NetherStar), Character.valueOf('S'), new ItemStack(Items.field_151156_bN), Character.valueOf('O'), new UnificationEntry(OrePrefix.plate, Materials.Obsidian));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:lit_pumpkin"));
        ModHandler.addShapedRecipe("lit_pumpkin", new ItemStack(Blocks.field_150428_aP), "PT", "k ", Character.valueOf('P'), new ItemStack(Blocks.field_150423_aK), Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:golden_apple"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:book"));
        ModHandler.addShapedRecipe("book", new ItemStack(Items.field_151122_aG), "SPL", "SPG", "SPL", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('G'), MetaItems.STICKY_RESIN.getStackForm().func_77946_l());
        ModHandler.removeRecipeByName(new ResourceLocation("brewing_stand"));
        ModHandler.addShapedRecipe("brewing_stand", new ItemStack(Items.field_151067_bt), "RBR", "ABA", "SCS", Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Aluminium), Character.valueOf('B'), new UnificationEntry(OrePrefix.stick, Materials.Blaze), Character.valueOf('A'), new UnificationEntry(OrePrefix.stick, Materials.Aluminium), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Aluminium), Character.valueOf('C'), new ItemStack(Items.field_151066_bu));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:ender_eye"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:speckled_melon"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:golden_carrot"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:magma_cream"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:enchanting_table"));
        ModHandler.addShapedRecipe("enchanting_table", new ItemStack(Blocks.field_150381_bn), "DCD", "PBP", "DPD", Character.valueOf('D'), new UnificationEntry(OrePrefix.gem, Materials.Diamond), Character.valueOf('C'), new ItemStack(Blocks.field_150404_cg, 1, 14), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Obsidian), Character.valueOf('B'), new ItemStack(Blocks.field_150342_X));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:jukebox"));
        ModHandler.addShapedRecipe("jukebox", new ItemStack(Blocks.field_150421_aI), "LBL", "NRN", "LGL", Character.valueOf('L'), new UnificationEntry(OrePrefix.log, Materials.Wood), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Diamond), Character.valueOf('N'), new ItemStack(Blocks.field_150323_B), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Iron));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.bolt, Materials.Diamond)).input(OrePrefix.gear, Materials.Iron)).input(OrePrefix.ring, Materials.Iron)).input(OrePrefix.plate, Materials.Wood, 4)).inputs(new ItemStack(Blocks.field_150323_B, 2))).outputs(new ItemStack(Blocks.field_150421_aI))).duration(100)).EUt(16)).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:noteblock"));
        ModHandler.addShapedRecipe("noteblock", new ItemStack(Blocks.field_150323_B), "PPP", "BGB", "PRP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Wood), Character.valueOf('B'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Wood), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.RedAlloy));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Wood, 4)).input(OrePrefix.gear, Materials.Wood)).input(OrePrefix.stick, Materials.RedAlloy)).inputs(new ItemStack(Blocks.field_150411_aY, 2))).outputs(new ItemStack(Blocks.field_150323_B))).duration(100)).EUt(16)).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:furnace"));
        ModHandler.addShapedRecipe("furnace", new ItemStack(Blocks.field_150460_al), new Object[]{"CCC", "FFF", "CCC", Character.valueOf('F'), new ItemStack(Items.field_151145_ak), Character.valueOf('C'), OreDictNames.stoneCobble});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().circuitMeta(8)).input(OreDictNames.stoneCobble.name(), 8)).inputs(new ItemStack(Items.field_151145_ak))).outputs(new ItemStack(Blocks.field_150460_al))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:crafting_table"));
        ModHandler.addShapedRecipe("crafting_table", new ItemStack(Blocks.field_150462_ai), "FF", "WW", Character.valueOf('F'), new ItemStack(Items.field_151145_ak), Character.valueOf('W'), new UnificationEntry(OrePrefix.log, Materials.Wood));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(6)).input("logWood", 1)).inputs(new ItemStack(Items.field_151145_ak))).outputs(new ItemStack(Blocks.field_150462_ai))).buildAndRegister();
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150417_aV));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:polished_granite"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:polished_diorite"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:polished_andesite"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:lead"));
        ModHandler.addShapedRecipe("lead", new ItemStack(Items.field_151058_ca), "SSS", "SBS", "SSS", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('B'), new ItemStack(Items.field_151123_aH));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:bow"));
        ModHandler.addShapedRecipe("bow", new ItemStack((Item)Items.field_151031_f), "hLS", "LRS", "fLS", Character.valueOf('L'), new UnificationEntry(OrePrefix.stickLong, Materials.Wood), Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:item_frame"));
        ModHandler.addShapedRecipe("item_frame", new ItemStack(Items.field_151160_bD), "SRS", "TLT", "TTT", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('T'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('L'), new ItemStack(Items.field_151116_aA));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:painting"));
        ModHandler.addShapedRecipe("painting", new ItemStack(Items.field_151159_an), "SRS", "TCT", "TTT", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('T'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('C'), new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:chest_minecart"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:furnace_minecart"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:tnt_minecart"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:hopper_minecart"));
        ModHandler.addShapedRecipe("chest_minecart", new ItemStack(Items.field_151108_aI), "hIw", " M ", " d ", Character.valueOf('I'), "chestWood", Character.valueOf('M'), new ItemStack(Items.field_151143_au));
        ModHandler.addShapedRecipe("furnace_minecart", new ItemStack(Items.field_151109_aJ), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack(Blocks.field_150460_al), Character.valueOf('M'), new ItemStack(Items.field_151143_au));
        ModHandler.addShapedRecipe("tnt_minecart", new ItemStack(Items.field_151142_bV), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack(Blocks.field_150335_W), Character.valueOf('M'), new ItemStack(Items.field_151143_au));
        ModHandler.addShapedRecipe("hopper_minecart", new ItemStack(Items.field_151140_bW), "hIw", " M ", " d ", Character.valueOf('I'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('M'), new ItemStack(Items.field_151143_au));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:flower_pot"));
        ModHandler.addShapedRecipe("flower_pot", new ItemStack(Items.field_151162_bE), "BfB", " B ", Character.valueOf('B'), new ItemStack(Items.field_151118_aC));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:armor_stand"));
        ModHandler.addShapedRecipe("armor_stand", new ItemStack((Item)Items.field_179565_cj), "BSB", "hSs", "IPI", Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Wood), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('I'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('P'), new ItemStack(Blocks.field_150456_au));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(Blocks.field_150456_au)).input(OrePrefix.plate, Materials.Iron, 2)).input(OrePrefix.stick, Materials.Wood, 2)).output((Item)Items.field_179565_cj)).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:trapped_chest"));
        ModHandler.addShapedRecipe("trapped_chest", new ItemStack(Blocks.field_150447_bR), " H ", "SCS", " d ", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150479_bC), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:ender_chest"));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OreDictNames.chestWood.name())).input(OrePrefix.plateDense, Materials.Obsidian, 6)).input(OrePrefix.plate, Materials.EnderEye)).output(Blocks.field_150477_bB)).duration(200)).EUt(GTValues.VA[2])).buildAndRegister();
        for (int i = 0; i <= 15; ++i) {
            VanillaOverrideRecipes.addBedRecipe(i);
        }
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:fermented_spider_eye"));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:fire_charge"));
    }

    private static void addBedRecipe(int meta) {
        String colorName = EnumDyeColor.func_176764_b((int)meta).func_176610_l();
        if ("silver".equals(colorName)) {
            colorName = "light_gray";
        }
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:" + colorName + "_bed"));
        ModHandler.addShapedRecipe(colorName + "_bed", new ItemStack(Items.field_151104_aV, 1, meta), new Object[]{"WWW", "PPP", "FrF", Character.valueOf('W'), new ItemStack(Blocks.field_150404_cg, 1, meta), Character.valueOf('P'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('F'), OreDictNames.fenceWood});
    }

    private static void dyeRecipes() {
        for (MarkerMaterial colorMaterial : MarkerMaterials.Color.VALUES) {
            ModHandler.removeRecipeByName(new ResourceLocation(String.format("minecraft:%s_concrete_powder", colorMaterial)));
            ModHandler.removeRecipeByName(new ResourceLocation(String.format("minecraft:%s_stained_hardened_clay", colorMaterial)));
            ModHandler.removeRecipeByName(new ResourceLocation(String.format("minecraft:%s_stained_glass", colorMaterial)));
            ModHandler.removeRecipeByName(new ResourceLocation(String.format("minecraft:%s_wool", colorMaterial)));
        }
        ModHandler.removeRecipeByName("minecraft:dark_prismarine");
    }

    private static void removeCompressionRecipes() {
        if (ConfigHolder.recipes.disableManualCompression) {
            ModHandler.removeRecipeByName("minecraft:gold_block");
            ModHandler.removeRecipeByName("minecraft:gold_nugget");
            ModHandler.removeRecipeByName("minecraft:gold_ingot_from_block");
            ModHandler.removeRecipeByName("minecraft:gold_ingot_from_nuggets");
            ModHandler.removeRecipeByName("minecraft:coal_block");
            ModHandler.removeRecipeByName("minecraft:coal");
            ModHandler.removeRecipeByName("minecraft:redstone_block");
            ModHandler.removeRecipeByName("minecraft:redstone");
            ModHandler.removeRecipeByName("minecraft:emerald_block");
            ModHandler.removeRecipeByName("minecraft:emerald");
            ModHandler.removeRecipeByName("minecraft:diamond_block");
            ModHandler.removeRecipeByName("minecraft:diamond");
            ModHandler.removeRecipeByName("minecraft:iron_block");
            ModHandler.removeRecipeByName("minecraft:iron_nugget");
            ModHandler.removeRecipeByName("minecraft:iron_ingot_from_block");
            ModHandler.removeRecipeByName("minecraft:iron_ingot_from_nuggets");
            ModHandler.removeRecipeByName("minecraft:lapis_block");
            ModHandler.removeRecipeByName("minecraft:lapis_lazuli");
            ModHandler.removeRecipeByName("minecraft:quartz_block");
            ModHandler.removeRecipeByName("appliedenergistics2:decorative/quartz_block_pure");
            ModHandler.removeRecipeByName("minecraft:clay");
            ModHandler.removeRecipeByName("minecraft:nether_brick");
            ModHandler.removeRecipeByName("minecraft:glowstone");
        }
        if (ConfigHolder.recipes.removeVanillaBlockRecipes) {
            ModHandler.removeRecipeByName("minecraft:slime");
            ModHandler.removeRecipeByName("minecraft:slime_ball");
            ModHandler.removeRecipeByName("minecraft:melon_block");
            ModHandler.removeRecipeByName("minecraft:hay_block");
            ModHandler.removeRecipeByName("minecraft:wheat");
            ModHandler.removeRecipeByName("minecraft:magma");
            ModHandler.removeRecipeByName("minecraft:nether_wart_block");
            ModHandler.removeRecipeByName("minecraft:bone_block");
            ModHandler.removeRecipeByName("minecraft:bone_meal_from_block");
            ModHandler.removeRecipeByName("minecraft:purpur_block");
            ModHandler.removeRecipeByName("minecraft:prismarine_bricks");
            ModHandler.removeRecipeByName("minecraft:prismarine");
            ModHandler.removeRecipeByName("minecraft:snow");
            ModHandler.removeRecipeByName("minecraft:sandstone");
            ModHandler.removeRecipeByName("minecraft:polished_andesite");
            ModHandler.removeRecipeByName("minecraft:polished_diorite");
            ModHandler.removeRecipeByName("minecraft:polished_granite");
            ModHandler.removeRecipeByName("minecraft:coarse_dirt");
            ModHandler.removeRecipeByName("minecraft:smooth_sandstone");
            ModHandler.removeRecipeByName("minecraft:chiseled_sandstone");
            ModHandler.removeRecipeByName("minecraft:chiseled_quartz_block");
            ModHandler.removeRecipeByName("minecraft:stonebrick");
            ModHandler.removeRecipeByName("minecraft:chiseled_stonebrick");
            ModHandler.removeRecipeByName("minecraft:purpur_pillar");
            ModHandler.removeRecipeByName("minecraft:end_bricks");
            ModHandler.removeRecipeByName("minecraft:red_nether_brick");
            ModHandler.removeRecipeByName("minecraft:red_sandstone");
            ModHandler.removeRecipeByName("minecraft:chiseled_red_sandstone");
            ModHandler.removeRecipeByName("minecraft:smooth_red_sandstone");
            ModHandler.removeRecipeByName("minecraft:bookshelf");
            ModHandler.removeRecipeByName("minecraft:pillar_quartz_block");
            ModHandler.removeRecipeByName("minecraft:sea_lantern");
            ModHandler.removeRecipeByName("minecraft:stone_slab");
            ModHandler.addShapedRecipe("stone_slab_saw", new ItemStack((Block)Blocks.field_150333_U), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b));
            ModHandler.removeRecipeByName("minecraft:sandstone_slab");
            ModHandler.addShapedRecipe("sandstone_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 1), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE));
            ModHandler.removeRecipeByName("minecraft:cobblestone_slab");
            ModHandler.addShapedRecipe("cobblestone_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 3), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150347_e));
            ModHandler.removeRecipeByName("minecraft:brick_slab");
            ModHandler.addShapedRecipe("brick_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 4), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150336_V));
            ModHandler.removeRecipeByName("minecraft:stone_brick_slab");
            ModHandler.addShapedRecipe("stone_brick_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 5), new Object[]{"sS", Character.valueOf('S'), OreDictNames.stoneBricks});
            ModHandler.removeRecipeByName("minecraft:nether_brick_slab");
            ModHandler.addShapedRecipe("nether_brick_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 6), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150385_bj));
            ModHandler.removeRecipeByName("minecraft:quartz_slab");
            ModHandler.addShapedRecipe("quartz_slab_saw", new ItemStack((Block)Blocks.field_150333_U, 1, 7), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE));
            ModHandler.removeRecipeByName("minecraft:red_sandstone_slab");
            ModHandler.addShapedRecipe("red_sandstone_slab_saw", new ItemStack((Block)Blocks.field_180389_cP), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_180395_cM, 1, Short.MAX_VALUE));
            ModHandler.removeRecipeByName("minecraft:purpur_slab");
            ModHandler.addShapedRecipe("purpur_slab_saw", new ItemStack((Block)Blocks.field_185771_cX), "sS", Character.valueOf('S'), new ItemStack(Blocks.field_185767_cT));
        }
    }

    private static void toolArmorRecipes() {
        if (ConfigHolder.recipes.flintAndSteelRequireSteel) {
            ModHandler.removeRecipeByName(new ResourceLocation("minecraft:flint_and_steel"));
            ModHandler.addShapedRecipe("flint_and_steel", new ItemStack(Items.field_151033_d), "G", "F", "S", Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, Materials.Steel), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1), Character.valueOf('S'), new UnificationEntry(OrePrefix.springSmall, Materials.Steel));
        }
        if (!ConfigHolder.recipes.hardToolArmorRecipes) {
            return;
        }
        VanillaOverrideRecipes.createShovelRecipe("iron_shovel", new ItemStack(Items.field_151037_a), Materials.Iron);
        VanillaOverrideRecipes.createPickaxeRecipe("iron_pickaxe", new ItemStack(Items.field_151035_b), Materials.Iron);
        VanillaOverrideRecipes.createAxeRecipe("iron_axe", new ItemStack(Items.field_151036_c), Materials.Iron);
        VanillaOverrideRecipes.createSwordRecipe("iron_sword", new ItemStack(Items.field_151040_l), Materials.Iron);
        VanillaOverrideRecipes.createHoeRecipe("iron_hoe", new ItemStack(Items.field_151019_K), Materials.Iron);
        VanillaOverrideRecipes.createHelmetRecipe("iron_helmet", new ItemStack((Item)Items.field_151028_Y), Materials.Iron);
        VanillaOverrideRecipes.createChestplateRecipe("iron_chestplate", new ItemStack((Item)Items.field_151030_Z), Materials.Iron);
        VanillaOverrideRecipes.createLeggingsRecipe("iron_leggings", new ItemStack((Item)Items.field_151165_aa), Materials.Iron);
        VanillaOverrideRecipes.createBootsRecipe("iron_boots", new ItemStack((Item)Items.field_151167_ab), Materials.Iron);
        VanillaOverrideRecipes.createShovelRecipe("golden_shovel", new ItemStack(Items.field_151011_C), Materials.Gold);
        VanillaOverrideRecipes.createPickaxeRecipe("golden_pickaxe", new ItemStack(Items.field_151005_D), Materials.Gold);
        VanillaOverrideRecipes.createAxeRecipe("golden_axe", new ItemStack(Items.field_151006_E), Materials.Gold);
        VanillaOverrideRecipes.createSwordRecipe("golden_sword", new ItemStack(Items.field_151010_B), Materials.Gold);
        VanillaOverrideRecipes.createHoeRecipe("golden_hoe", new ItemStack(Items.field_151013_M), Materials.Gold);
        VanillaOverrideRecipes.createHelmetRecipe("golden_helmet", new ItemStack((Item)Items.field_151169_ag), Materials.Gold);
        VanillaOverrideRecipes.createChestplateRecipe("golden_chestplate", new ItemStack((Item)Items.field_151171_ah), Materials.Gold);
        VanillaOverrideRecipes.createLeggingsRecipe("golden_leggings", new ItemStack((Item)Items.field_151149_ai), Materials.Gold);
        VanillaOverrideRecipes.createBootsRecipe("golden_boots", new ItemStack((Item)Items.field_151151_aj), Materials.Gold);
        VanillaOverrideRecipes.createShovelRecipe("diamond_shovel", new ItemStack(Items.field_151047_v), Materials.Diamond);
        VanillaOverrideRecipes.createPickaxeRecipe("diamond_pickaxe", new ItemStack(Items.field_151046_w), Materials.Diamond);
        VanillaOverrideRecipes.createAxeRecipe("diamond_axe", new ItemStack(Items.field_151056_x), Materials.Diamond);
        VanillaOverrideRecipes.createSwordRecipe("diamond_sword", new ItemStack(Items.field_151048_u), Materials.Diamond);
        VanillaOverrideRecipes.createHoeRecipe("diamond_hoe", new ItemStack(Items.field_151012_L), Materials.Diamond);
        VanillaOverrideRecipes.createHelmetRecipe("diamond_helmet", new ItemStack((Item)Items.field_151161_ac), Materials.Diamond);
        VanillaOverrideRecipes.createChestplateRecipe("diamond_chestplate", new ItemStack((Item)Items.field_151163_ad), Materials.Diamond);
        VanillaOverrideRecipes.createLeggingsRecipe("diamond_leggings", new ItemStack((Item)Items.field_151173_ae), Materials.Diamond);
        VanillaOverrideRecipes.createBootsRecipe("diamond_boots", new ItemStack((Item)Items.field_151175_af), Materials.Diamond);
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:compass"));
        ModHandler.addShapedRecipe("compass", new ItemStack(Items.field_151111_aL), "SGB", "RPR", "AdS", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('G'), new ItemStack(Blocks.field_150410_aZ, 1, Short.MAX_VALUE), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.IronMagnetic), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Zinc), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('A'), new UnificationEntry(OrePrefix.bolt, Materials.RedAlloy));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron)).input(OrePrefix.ring, Materials.Zinc)).input(OrePrefix.bolt, Materials.RedAlloy)).input(OrePrefix.bolt, Materials.IronMagnetic)).input(OrePrefix.screw, Materials.Iron, 2)).outputs(new ItemStack(Items.field_151111_aL))).duration(100)).EUt(16)).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:fishing_rod"));
        ModHandler.addShapedRecipe("fishing_rod", new ItemStack((Item)Items.field_151112_aM), "  S", " SL", "SxR", Character.valueOf('S'), new UnificationEntry(OrePrefix.stickLong, Materials.Wood), Character.valueOf('L'), new ItemStack(Items.field_151007_F), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:clock"));
        ModHandler.addShapedRecipe("clock", new ItemStack(Items.field_151113_aN), "RPR", "BCB", "dSw", Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Gold), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Gold), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Gold), Character.valueOf('C'), new ItemStack(Items.field_151132_bS), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Gold));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Gold)).input(OrePrefix.ring, Materials.Gold)).input(OrePrefix.bolt, Materials.Gold, 2)).input(OrePrefix.screw, Materials.Gold)).inputs(new ItemStack(Items.field_151132_bS))).outputs(new ItemStack(Items.field_151113_aN))).duration(100)).EUt(16)).buildAndRegister();
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:shears"));
        ModHandler.addShapedRecipe("shears", new ItemStack((Item)Items.field_151097_aZ), "PSP", "hRf", "TdT", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('T'), new ItemStack(Items.field_151055_y));
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:shield"));
        ModHandler.addShapedRecipe("shield", new ItemStack(Items.field_185159_cQ), "BRB", "LPL", "BRB", Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Iron), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('L'), new UnificationEntry(OrePrefix.stickLong, Materials.Iron), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Wood));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151028_Y, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151030_Z, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151165_aa, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151167_ab, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151138_bX, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151035_b, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151037_a, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151036_c, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151040_l, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151019_K, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151169_ag, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151171_ah, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151149_ai, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack((Item)Items.field_151151_aj, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151136_bY, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151005_D, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151011_C, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151006_E, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151010_B, 1, Short.MAX_VALUE));
        ModHandler.removeFurnaceSmelting(new ItemStack(Items.field_151013_M, 1, Short.MAX_VALUE));
    }

    private static void createShovelRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "hPf", " S ", " S ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
    }

    private static void createPickaxeRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PII", "hSf", " S ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(Materials.Diamond) ? OrePrefix.gem : OrePrefix.ingot, material), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
    }

    private static void createAxeRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PIf", "PS ", "hS ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(Materials.Diamond) ? OrePrefix.gem : OrePrefix.ingot, material), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
    }

    private static void createSwordRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, " P ", "hPf", " S ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
    }

    private static void createHoeRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PIf", "hS ", " S ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(Materials.Diamond) ? OrePrefix.gem : OrePrefix.ingot, material), Character.valueOf('S'), new ItemStack(Items.field_151055_y));
    }

    private static void createHelmetRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PPP", "PhP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
    }

    private static void createChestplateRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PhP", "PPP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
    }

    private static void createLeggingsRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "PPP", "PhP", "P P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
    }

    private static void createBootsRecipe(String regName, ItemStack output, Material material) {
        ModHandler.removeRecipeByName(new ResourceLocation(regName));
        ModHandler.addShapedRecipe(regName, output, "P P", "PhP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
    }

    private static void alwaysRemovedRecipes() {
        ModHandler.removeRecipeByName(new ResourceLocation("minecraft:tnt"));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150365_q));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150366_p));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150352_o));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150482_ag));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150412_bA));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150369_x));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150450_ax));
        ModHandler.removeFurnaceSmelting(new ItemStack(Blocks.field_150449_bY));
    }
}

