/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.dungeon;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStringUtils;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public final class ChestGenHooks {
    private static final Map<ResourceLocation, List<GTLootEntryItem>> lootEntryItems = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, RandomValueRange> rollValues = new Object2ObjectOpenHashMap();
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static final ItemStackHashStrategy HASH_STRATEGY = ItemStackHashStrategy.comparingAllButCount();

    private ChestGenHooks() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ChestGenHooks.class);
    }

    @SubscribeEvent
    public static void onWorldLoad(@NotNull LootTableLoadEvent event) {
        LootPool mainPool = event.getTable().getPool("main");
        if (mainPool == null) {
            return;
        }
        ResourceLocation name = event.getName();
        if (lootEntryItems.containsKey(name)) {
            List<GTLootEntryItem> entryItems = lootEntryItems.get(name);
            for (GTLootEntryItem entry : entryItems) {
                if (ConfigHolder.misc.debug) {
                    GTLog.logger.info("adding {} to lootTable {}", (Object)entry, (Object)name);
                }
                try {
                    mainPool.addEntry((LootEntry)entry);
                }
                catch (RuntimeException e) {
                    GTLog.logger.error("Couldn't add {} to lootTable {}: {}", (Object)entry, (Object)name, (Object)e.getMessage());
                }
            }
        }
        if (rollValues.containsKey(event.getName())) {
            RandomValueRange rangeAdd = rollValues.get(event.getName());
            RandomValueRange range = mainPool.getRolls();
            mainPool.setRolls(new RandomValueRange(range.func_186509_a() + rangeAdd.func_186509_a(), range.func_186512_b() + rangeAdd.func_186512_b()));
        }
    }

    public static void addItem(@NotNull ResourceLocation lootTable, @NotNull ItemStack stack, int minAmount, int maxAmount, int weight) {
        RandomWeightLootFunction lootFunction = new RandomWeightLootFunction(stack, minAmount, maxAmount);
        String modid = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110624_b();
        String entryName = ChestGenHooks.createEntryName(stack, modid, weight, lootFunction);
        GTLootEntryItem itemEntry = new GTLootEntryItem(stack, weight, lootFunction, entryName);
        if (lootEntryItems.containsKey(lootTable)) {
            lootEntryItems.get(lootTable).add(itemEntry);
        } else {
            lootEntryItems.put(lootTable, Lists.newArrayList((Object[])new GTLootEntryItem[]{itemEntry}));
        }
    }

    public static void addRolls(ResourceLocation tableLocation, int minAdd, int maxAdd) {
        rollValues.put(tableLocation, new RandomValueRange((float)minAdd, (float)maxAdd));
    }

    @NotNull
    private static String createEntryName(@NotNull ItemStack stack, @NotNull String modid, int weight, @NotNull RandomWeightLootFunction function) {
        int hashCode = Objects.hash(HASH_STRATEGY.hashCode(stack), modid, weight, function.getMinAmount(), function.getMaxAmount());
        return String.format("#%s:loot_%s", modid, hashCode);
    }

    private static class GTLootEntryItem
    extends LootEntryItem {
        private final ItemStack stack;

        public GTLootEntryItem(@NotNull ItemStack stack, int weight, LootFunction lootFunction, @NotNull String entryName) {
            super(stack.func_77973_b(), weight, 1, new LootFunction[]{lootFunction}, NO_CONDITIONS, entryName);
            this.stack = stack;
        }

        @NotNull
        public String toString() {
            return "GTLootEntryItem{name=" + this.getEntryName() + ", stack=" + GTStringUtils.itemStackToString(this.stack) + '}';
        }
    }

    private static class RandomWeightLootFunction
    extends LootFunction {
        private final ItemStack stack;
        private final int minAmount;
        private final int maxAmount;

        public RandomWeightLootFunction(@NotNull ItemStack stack, int minAmount, int maxAmount) {
            super(NO_CONDITIONS);
            Preconditions.checkArgument((minAmount <= maxAmount ? 1 : 0) != 0, (Object)"minAmount must be <= maxAmount");
            this.stack = stack;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public int getMinAmount() {
            return this.minAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }

        @NotNull
        public ItemStack func_186553_a(@NotNull ItemStack itemStack, @NotNull Random rand, @NotNull LootContext context) {
            itemStack.func_77964_b(this.stack.func_77952_i());
            NBTTagCompound tagCompound = this.stack.func_77978_p();
            if (tagCompound != null) {
                itemStack.func_77982_d(tagCompound.func_74737_b());
            }
            if (this.minAmount == this.maxAmount) {
                itemStack.func_190920_e(this.minAmount);
                return itemStack;
            }
            int count = Math.min(this.minAmount + rand.nextInt(this.maxAmount - this.minAmount + 1), this.stack.func_77976_d());
            itemStack.func_190920_e(count);
            return itemStack;
        }
    }
}

