/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.ComputationRecipeLogic;
import gregtech.api.util.TextFormattingUtil;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class WorkableInfoProvider
extends CapabilityInfoProvider<IWorkable> {
    public String getID() {
        return "gregtech:workable_provider";
    }

    @Override
    @NotNull
    protected Capability<IWorkable> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_WORKABLE;
    }

    @Override
    protected void addProbeInfo(@NotNull IWorkable capability, @NotNull IProbeInfo probeInfo, @NotNull EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        String text;
        ComputationRecipeLogic logic;
        if (!capability.isActive()) {
            return;
        }
        int currentProgress = capability.getProgress();
        int maxProgress = capability.getMaxProgress();
        if (capability instanceof ComputationRecipeLogic && !(logic = (ComputationRecipeLogic)capability).shouldShowDuration()) {
            int color = capability.isWorkingEnabled() ? -16722738 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(" / " + maxProgress + " CWU").filledColor(color).alternateFilledColor(color).borderColor(-11184811));
            return;
        }
        if (maxProgress < 20) {
            text = " / " + maxProgress + " t";
        } else {
            currentProgress = Math.round((float)currentProgress / 20.0f);
            maxProgress = Math.round((float)maxProgress / 20.0f);
            text = " / " + TextFormattingUtil.formatNumbers(maxProgress) + " s";
        }
        if (maxProgress > 0) {
            int color = capability.isWorkingEnabled() ? -11748585 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(color).alternateFilledColor(color).borderColor(-11184811).numberFormat(NumberFormat.COMMAS));
        }
    }
}

