/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.recipes.RecipeMap;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class MultiRecipeMapInfoProvider
extends CapabilityInfoProvider<IMultipleRecipeMaps> {
    public String getID() {
        return "gregtech:multi_recipemap_provider";
    }

    @Override
    @NotNull
    protected Capability<IMultipleRecipeMaps> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_MULTIPLE_RECIPEMAPS;
    }

    @Override
    protected void addProbeInfo(@NotNull IMultipleRecipeMaps iMultipleRecipeMaps, @NotNull IProbeInfo iProbeInfo, @NotNull EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        if (iMultipleRecipeMaps.getAvailableRecipeMaps().length == 1) {
            return;
        }
        iProbeInfo.text(TextStyleClass.INFO + "{*" + "gregtech.multiblock.multiple_recipemaps.header" + "*}");
        for (RecipeMap<?> recipeMap : iMultipleRecipeMaps.getAvailableRecipeMaps()) {
            if (recipeMap.equals(iMultipleRecipeMaps.getCurrentRecipeMap())) {
                iProbeInfo.text("   " + TextStyleClass.INFOIMP + "{*" + recipeMap.getTranslationKey() + "*} {*<*}");
                continue;
            }
            iProbeInfo.text("   " + TextStyleClass.LABEL + "{*" + recipeMap.getTranslationKey() + "*}");
        }
    }
}

