/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.util.TextFormattingUtil;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ElectricContainerInfoProvider
extends CapabilityInfoProvider<IEnergyContainer> {
    public String getID() {
        return "gregtech:energy_container_provider";
    }

    @Override
    @NotNull
    protected Capability<IEnergyContainer> getCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Override
    protected boolean allowDisplaying(@NotNull IEnergyContainer capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected void addProbeInfo(@NotNull IEnergyContainer capability, @NotNull IProbeInfo probeInfo, EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        long maxStorage = capability.getEnergyCapacity();
        if (maxStorage == 0L) {
            return;
        }
        probeInfo.progress(capability.getEnergyStored(), maxStorage, probeInfo.defaultProgressStyle().suffix(" / " + TextFormattingUtil.formatNumbers(maxStorage) + " EU").filledColor(-1120768).alternateFilledColor(-1120768).borderColor(-11184811).numberFormat(NumberFormat.COMMAS));
    }
}

