/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverSimpleMachine
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return SimpleMachineMetaTileEntity.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof SimpleMachineMetaTileEntity;
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return new EnvironmentSimpleMachine((IGregTechTileEntity)tileEntity, (SimpleMachineMetaTileEntity)((IGregTechTileEntity)tileEntity).getMetaTileEntity());
        }
        return null;
    }

    public static final class EnvironmentSimpleMachine
    extends EnvironmentMetaTileEntity<SimpleMachineMetaTileEntity> {
        public EnvironmentSimpleMachine(IGregTechTileEntity holder, SimpleMachineMetaTileEntity tileEntity) {
            super(holder, tileEntity, "gt_machine");
        }

        @Callback(doc="function():number --  Returns the tier of machine.")
        public Object[] getTier(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).getTier()};
        }

        @Callback(doc="function():boolean --  Returns is autoOutputItems enabled.")
        public Object[] isAutoOutputItems(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).isAutoOutputItems()};
        }

        @Callback(doc="function(autoOutputItems:boolean):boolean -- Sets autoOutputItems enabled.")
        public Object[] setAutoOutputItems(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAutoOutputItems(args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function():boolean --  Returns is autoOutputFluids enabled.")
        public Object[] isAutoOutputFluids(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).isAutoOutputFluids()};
        }

        @Callback(doc="function(autoOutputFluids:boolean):boolean -- Sets autoOutputFluids enabled.")
        public Object[] setAutoOutputFluids(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAutoOutputFluids(args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function():boolean --  Returns is allowInputFromOutputSide enabled for BOTH items and fluids.")
        public Object[] isAllowInputFromOutputSide(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideItems() && ((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideFluids()};
        }

        @Callback(doc="function():boolean --  Returns is allowInputFromOutputSide enabled for items.")
        public Object[] isAllowInputFromOutputSideItems(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideItems() && ((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideFluids()};
        }

        @Callback(doc="function():boolean --  Returns is allowInputFromOutputSide enabled for fluids.")
        public Object[] isAllowInputFromOutputSideFluids(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideItems() && ((SimpleMachineMetaTileEntity)this.tileEntity).isAllowInputFromOutputSideFluids()};
        }

        @Callback(doc="function(allowInputFromOutputSide:boolean):boolean -- Sets allowInputFromOutputSide enabled for BOTH items and fluids.")
        public Object[] setAllowInputFromOutputSide(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAllowInputFromOutputSideItems(args.checkBoolean(0));
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAllowInputFromOutputSideFluids(args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function(allowInputFromOutputSide:boolean):boolean -- Sets allowInputFromOutputSide enabled for items.")
        public Object[] setAllowInputFromOutputSideItems(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAllowInputFromOutputSideItems(args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function(allowInputFromOutputSide:boolean):boolean -- Sets allowInputFromOutputSide enabled for fluids.")
        public Object[] setAllowInputFromOutputSideFluids(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setAllowInputFromOutputSideFluids(args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function():number --  Returns is outputFacing.")
        public Object[] getOutputFacing(Context context, Arguments args) {
            return new Object[]{((SimpleMachineMetaTileEntity)this.tileEntity).getOutputFacing().ordinal()};
        }

        @Callback(doc="function(side:number) -- Sets outputFacing.")
        public Object[] setOutputFacing(Context context, Arguments args) {
            ((SimpleMachineMetaTileEntity)this.tileEntity).setOutputFacing(EnumFacing.values()[args.checkInteger(0)]);
            return new Object[0];
        }
    }
}

