/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers;

import li.cil.oc.api.machine.Arguments;

public class InputValidator {
    public static int getInteger(Arguments args, int index, int min, int max) {
        int value = args.checkInteger(index);
        if (value > max || value < min) {
            throw new IllegalArgumentException("Passed value must be within " + min + " and " + max);
        }
        return value;
    }

    public static <T extends Enum<?>> T getEnumArrayIndex(Arguments args, int argsIndex, T[] array) {
        int value = args.checkInteger(argsIndex);
        if (value < 0 || value >= array.length) {
            throw new IllegalArgumentException("Passed value must be within 0 and " + (array.length - 1));
        }
        return array[value];
    }

    public static String getColorString(Arguments args, int index) {
        String colorString = args.checkString(index);
        if (colorString == null) {
            throw new IllegalArgumentException("Must pass a color string.");
        }
        if (colorString.startsWith("0x")) {
            colorString = colorString.substring(2);
        }
        if (colorString.length() != 8) {
            throw new IllegalArgumentException("String " + colorString + " is not valid, must be 8 characters long beyond \"0x\".");
        }
        try {
            Long.parseLong(colorString, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("String " + colorString + " is not a valid code, must be only numbers (0-9) and letters (A-F).");
        }
        return colorString;
    }
}

