/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils.render;

import java.util.LinkedList;
import java.util.List;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class CompositeRenderer<T>
implements IIngredientRenderer<T> {
    private final TooltipSupplier<T> tooltipSupplier;
    private final FontRendererSupplier<T> fontRendererSupplier;
    private final List<RenderNode<T>> steps;

    public CompositeRenderer(TooltipSupplier<T> tooltipSupplier, FontRendererSupplier<T> fontRendererSupplier, List<RenderNode<T>> steps) {
        this.tooltipSupplier = tooltipSupplier;
        this.fontRendererSupplier = fontRendererSupplier;
        this.steps = steps;
    }

    public static <T> Builder<T> startBuilder(TooltipSupplier<T> tooltipSupplier, FontRendererSupplier<T> fontRendererSupplier) {
        return new Builder<T>(tooltipSupplier, fontRendererSupplier);
    }

    public static <T> Builder<T> startBuilder(IIngredientRenderer<T> ingredientRenderer) {
        return CompositeRenderer.startBuilder((arg_0, arg_1, arg_2) -> ingredientRenderer.getTooltip(arg_0, arg_1, arg_2), (arg_0, arg_1) -> ingredientRenderer.getFontRenderer(arg_0, arg_1));
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable T ingredient) {
        for (RenderNode<T> step : this.steps) {
            step.render(minecraft, xPosition, yPosition, ingredient);
        }
    }

    public List<String> getTooltip(Minecraft minecraft, T ingredient, ITooltipFlag tooltipFlag) {
        return this.tooltipSupplier.getTooltip(minecraft, ingredient, tooltipFlag);
    }

    public FontRenderer getFontRenderer(Minecraft minecraft, T ingredient) {
        return this.fontRendererSupplier.getFontRenderer(minecraft, ingredient);
    }

    @FunctionalInterface
    public static interface TooltipSupplier<T> {
        public List<String> getTooltip(Minecraft var1, T var2, ITooltipFlag var3);
    }

    @FunctionalInterface
    public static interface FontRendererSupplier<T> {
        public FontRenderer getFontRenderer(Minecraft var1, T var2);
    }

    public static class Builder<T> {
        private final TooltipSupplier<T> tooltipSupplier;
        private final FontRendererSupplier<T> fontRendererSupplier;
        private final List<RenderNode<T>> steps = new LinkedList<RenderNode<T>>();

        public Builder(TooltipSupplier<T> tooltipSupplier, FontRendererSupplier<T> fontRendererSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            this.fontRendererSupplier = fontRendererSupplier;
        }

        public Builder<T> then(Runnable step) {
            return this.then((Minecraft minecraft, int xPosition, int yPosition, T ingredient) -> step.run());
        }

        public Builder<T> then(RenderNode<T> step) {
            this.steps.add(step);
            return this;
        }

        public CompositeRenderer<T> build() {
            return new CompositeRenderer<T>(this.tooltipSupplier, this.fontRendererSupplier, this.steps);
        }
    }

    @FunctionalInterface
    public static interface RenderNode<T> {
        public void render(Minecraft var1, int var2, int var3, @Nullable T var4);
    }
}

