/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils;

import gregtech.api.gui.resources.IGuiTexture;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;

public class JeiButton {
    private IGuiTexture[] textures = new IGuiTexture[0];
    private final float x;
    private final float y;
    private final int width;
    private final int height;
    private ClickAction clickAction;
    private BooleanSupplier activeSupplier = () -> true;
    private Consumer<List<String>> tooltipBuilder = null;

    public JeiButton(float x, float y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public JeiButton setTextures(IGuiTexture ... textures) {
        this.textures = textures;
        return this;
    }

    public JeiButton setClickAction(ClickAction clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public JeiButton setActiveSupplier(BooleanSupplier activeSupplier) {
        this.activeSupplier = activeSupplier;
        return this;
    }

    public JeiButton setTooltipBuilder(Consumer<List<String>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
        return this;
    }

    public void buildTooltip(List<String> lines) {
        if (this.tooltipBuilder != null) {
            this.tooltipBuilder.accept(lines);
        }
    }

    public boolean isHovering(int mouseX, int mouseY) {
        return (float)mouseX >= this.x && (float)mouseY >= this.y && (float)mouseX <= this.x + (float)this.width && (float)mouseY <= this.y + (float)this.height && this.activeSupplier.getAsBoolean();
    }

    public void render(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (!this.activeSupplier.getAsBoolean()) {
            return;
        }
        for (IGuiTexture texture : this.textures) {
            texture.draw(this.x, this.y, this.width, this.height);
        }
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    @FunctionalInterface
    public static interface ClickAction {
        public boolean click(Minecraft var1, int var2, int var3, int var4);
    }
}

