/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import com.google.common.collect.ImmutableList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.integration.jei.basic.BasicRecipeCategory;
import gregtech.integration.jei.basic.MaterialTree;
import gregtech.integration.jei.utils.render.DrawableRegistry;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialTreeCategory
extends BasicRecipeCategory<MaterialTree, MaterialTree> {
    protected String materialName;
    protected String materialFormula;
    protected int materialBFTemp;
    protected String materialAvgM;
    protected String materialAvgP;
    protected String materialAvgN;
    protected final IDrawable slot;
    protected final IDrawable icon;
    protected List<Boolean> itemExists = new ArrayList<Boolean>();
    protected List<Boolean> fluidExists = new ArrayList<Boolean>();
    protected static final ImmutableList<Integer> ITEM_LOCATIONS = ImmutableList.of((Object)4, (Object)67, (Object)4, (Object)101, (Object)4, (Object)135, (Object)29, (Object)55, (Object)29, (Object)85, (Object)29, (Object)117, (Object[])new Integer[]{29, 117, 29, 147, 54, 55, 54, 85, 54, 117, 54, 147, 79, 55, 79, 85, 79, 117, 79, 147, 79, 147, 104, 55, 104, 85, 104, 117, 104, 147, 129, 55, 129, 85, 129, 117, 129, 147, 154, 55, 154, 78, 154, 124, 154, 147});
    protected ImmutableList<Integer> FLUID_LOCATIONS = ImmutableList.of((Object)154, (Object)101);

    public MaterialTreeCategory(IGuiHelper guiHelper) {
        super("material_tree", "recipemap.materialtree.name", (IDrawable)guiHelper.createBlankDrawable(176, 166), guiHelper);
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.icon = guiHelper.createDrawableIngredient((Object)OreDictUnifier.get(OrePrefix.ingot, Materials.Aluminium));
        MaterialTreeCategory.registerArrow(guiHelper, "2d12", 5, 12);
        MaterialTreeCategory.registerArrow(guiHelper, "2d16", 5, 16);
        MaterialTreeCategory.registerArrow(guiHelper, "2r16d37", 18, 40);
        MaterialTreeCategory.registerArrow(guiHelper, "d14", 5, 14);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r25u6", 28, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r50d7", 53, 14);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r50u6", 53, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r75d7", 78, 14);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r75u6", 78, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r87u22r4", 92, 25);
        MaterialTreeCategory.registerArrow(guiHelper, "d7r87u46r4", 92, 49);
        MaterialTreeCategory.registerArrow(guiHelper, "l7", 7, 5);
        MaterialTreeCategory.registerArrow(guiHelper, "r3d16r4", 7, 19);
        MaterialTreeCategory.registerArrow(guiHelper, "r3d26r4", 7, 29);
        MaterialTreeCategory.registerArrow(guiHelper, "r3u15r4", 7, 18);
        MaterialTreeCategory.registerArrow(guiHelper, "r3u32r4", 7, 35);
        MaterialTreeCategory.registerArrow(guiHelper, "r3u57r4", 7, 60);
        MaterialTreeCategory.registerArrow(guiHelper, "r7", 7, 5);
        MaterialTreeCategory.registerArrow(guiHelper, "u12", 5, 12);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r25d6", 28, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r50d6", 53, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r50u5", 53, 12);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r75d6", 78, 7);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r75u5", 78, 12);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r87d15r4", 92, 18);
        MaterialTreeCategory.registerArrow(guiHelper, "u7r87u8r4", 92, 17);
        MaterialTreeCategory.registerArrow(guiHelper, "r3u62r29", 32, 65);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull MaterialTree recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        List itemInputs = ingredients.getInputs(VanillaTypes.ITEM);
        this.itemExists.clear();
        for (int i = 0; i < ITEM_LOCATIONS.size(); i += 2) {
            itemStackGroup.init(i, true, ((Integer)ITEM_LOCATIONS.get(i)).intValue(), ((Integer)ITEM_LOCATIONS.get(i + 1)).intValue());
            this.itemExists.add(((List)itemInputs.get(i / 2)).size() > 0);
        }
        itemStackGroup.set(ingredients);
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        List fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
        this.fluidExists.clear();
        for (int i = 0; i < this.FLUID_LOCATIONS.size(); i += 2) {
            fluidStackGroup.init(0, true, (Integer)this.FLUID_LOCATIONS.get(i) + 1, (Integer)this.FLUID_LOCATIONS.get(i + 1) + 1);
            this.fluidExists.add(((List)fluidInputs.get(i / 2)).size() > 0);
        }
        fluidStackGroup.set(ingredients);
        this.materialName = recipeWrapper.getMaterialName();
        this.materialFormula = recipeWrapper.getMaterialFormula();
        this.materialBFTemp = recipeWrapper.getBlastTemp();
        this.materialAvgM = I18n.func_135052_a((String)"gregtech.jei.materials.average_mass", (Object[])new Object[]{recipeWrapper.getAvgM()});
        this.materialAvgP = I18n.func_135052_a((String)"gregtech.jei.materials.average_protons", (Object[])new Object[]{recipeWrapper.getAvgP()});
        this.materialAvgN = I18n.func_135052_a((String)"gregtech.jei.materials.average_neutrons", (Object[])new Object[]{recipeWrapper.getAvgN()});
    }

    @NotNull
    public IRecipeWrapper getRecipeWrapper(@NotNull MaterialTree recipe) {
        return recipe;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void drawExtras(@NotNull Minecraft minecraft) {
        int i;
        for (i = 0; i < ITEM_LOCATIONS.size(); i += 2) {
            if (!this.itemExists.get(i / 2).booleanValue()) continue;
            this.slot.draw(minecraft, ((Integer)ITEM_LOCATIONS.get(i)).intValue(), ((Integer)ITEM_LOCATIONS.get(i + 1)).intValue());
        }
        for (i = 0; i < this.FLUID_LOCATIONS.size(); i += 2) {
            if (!this.fluidExists.get(i / 2).booleanValue()) continue;
            this.slot.draw(minecraft, ((Integer)this.FLUID_LOCATIONS.get(i)).intValue(), ((Integer)this.FLUID_LOCATIONS.get(i + 1)).intValue());
        }
        MaterialTreeCategory.drawArrow(minecraft, "2d16", 10, 85, this.itemExists.get(0) != false && this.itemExists.get(1) != false);
        MaterialTreeCategory.drawArrow(minecraft, "2d16", 10, 119, this.itemExists.get(1) != false && this.itemExists.get(2) != false);
        MaterialTreeCategory.drawArrow(minecraft, "2r16d37", 22, 107, this.itemExists.get(5) == false && this.itemExists.get(6) == false && this.itemExists.get(1) != false && this.itemExists.get(7) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r3u15r4", 22, 92, this.itemExists.get(1) != false && this.itemExists.get(4) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r3d16r4", 22, 109, this.itemExists.get(4) == false && this.itemExists.get(1) != false && (this.itemExists.get(5) != false || this.itemExists.get(6) != false));
        MaterialTreeCategory.drawArrow(minecraft, "d14", 35, 103, this.itemExists.get(4) != false && this.itemExists.get(5) != false);
        MaterialTreeCategory.drawArrow(minecraft, "2d12", 35, 135, this.itemExists.get(7) != false && (this.itemExists.get(5) != false || this.itemExists.get(6) != false));
        MaterialTreeCategory.drawArrow(minecraft, "r3u57r4", 47, 66, this.itemExists.get(5) != false && this.itemExists.get(8) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r3u32r4", 47, 91, this.itemExists.get(9) != false && (this.itemExists.get(5) != false || this.itemExists.get(6) != false));
        MaterialTreeCategory.drawArrow(minecraft, "r7", 47, 123, this.itemExists.get(5) != false && this.itemExists.get(10) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r3d26r4", 47, 125, this.itemExists.get(5) != false && this.itemExists.get(11) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r3u62r29", 47, 61, this.itemExists.get(8) == false && this.itemExists.get(5) != false && this.itemExists.get(12) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r7", 47, 158, this.itemExists.get(7) != false && this.itemExists.get(11) != false);
        MaterialTreeCategory.drawArrow(minecraft, "l7", 47, 57, this.itemExists.get(8) != false && this.itemExists.get(3) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r7", 72, 61, this.itemExists.get(8) != false && this.itemExists.get(12) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r25u6", 62, 103, this.itemExists.get(9) != false && this.itemExists.get(13) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r50u6", 62, 103, this.itemExists.get(9) != false && this.itemExists.get(18) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r50d7", 62, 103, this.itemExists.get(9) != false && this.itemExists.get(19) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r75u6", 62, 103, this.itemExists.get(9) != false && this.itemExists.get(22) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r75d7", 62, 103, this.itemExists.get(9) != false && this.itemExists.get(23) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r87u46r4", 62, 61, this.itemExists.get(9) != false && this.itemExists.get(25) != false);
        MaterialTreeCategory.drawArrow(minecraft, "d7r87u22r4", 62, 85, this.itemExists.get(9) != false && this.itemExists.get(26) != false);
        MaterialTreeCategory.drawArrow(minecraft, "r7", 72, 123, this.itemExists.get(10) != false && this.itemExists.get(14) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r25d6", 62, 140, this.itemExists.get(11) != false && (this.itemExists.get(15) != false || this.itemExists.get(16) != false));
        MaterialTreeCategory.drawArrow(minecraft, "u7r50u5", 62, 135, this.itemExists.get(11) != false && this.itemExists.get(19) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r50d6", 62, 140, this.itemExists.get(11) != false && this.itemExists.get(20) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r75u5", 62, 135, this.itemExists.get(11) != false && this.itemExists.get(23) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r75d6", 62, 140, this.itemExists.get(11) != false && this.itemExists.get(24) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r87u8r4", 62, 130, this.itemExists.get(11) != false && this.itemExists.get(27) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u7r87d15r4", 62, 140, this.itemExists.get(11) != false && this.itemExists.get(28) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u12", 110, 73, this.itemExists.get(18) != false && this.itemExists.get(17) != false);
        MaterialTreeCategory.drawArrow(minecraft, "u12", 135, 73, this.itemExists.get(22) != false && this.itemExists.get(21) != false);
        int linesDrawn = 0;
        if (minecraft.field_71466_p.func_78256_a(this.materialName) > 176) {
            minecraft.field_71466_p.func_78276_b(minecraft.field_71466_p.func_78269_a(this.materialName, 171) + "...", 0, 0, 0x111111);
            ++linesDrawn;
        } else if (this.materialName.length() != 0) {
            minecraft.field_71466_p.func_78276_b(this.materialName, 0, 0, 0x111111);
            ++linesDrawn;
        }
        if (minecraft.field_71466_p.func_78256_a(this.materialFormula) > 176) {
            minecraft.field_71466_p.func_78276_b(minecraft.field_71466_p.func_78269_a(this.materialFormula, 171) + "...", 0, this.FONT_HEIGHT * linesDrawn, 0x111111);
            ++linesDrawn;
        } else if (this.materialFormula.length() != 0) {
            minecraft.field_71466_p.func_78276_b(this.materialFormula, 0, this.FONT_HEIGHT * linesDrawn, 0x111111);
            ++linesDrawn;
        }
        if (this.materialBFTemp != 0) {
            TemperatureProperty.getInstance().drawInfo(minecraft, 0, this.FONT_HEIGHT * linesDrawn, 0x111111, this.materialBFTemp);
            ++linesDrawn;
        }
        minecraft.field_71466_p.func_78276_b(this.materialAvgM, 0, this.FONT_HEIGHT * linesDrawn, 0x111111);
        minecraft.field_71466_p.func_78276_b(this.materialAvgN, 0, this.FONT_HEIGHT * ++linesDrawn, 0x111111);
        minecraft.field_71466_p.func_78276_b(this.materialAvgP, 0, this.FONT_HEIGHT * ++linesDrawn, 0x111111);
    }

    private static void registerArrow(IGuiHelper guiHelper, String name, int width, int height) {
        DrawableRegistry.initDrawable(guiHelper, "gregtech:textures/gui/arrows/" + name + ".png", width, height, name);
    }

    private static void drawArrow(Minecraft minecraft, String name, int x, int y, boolean shown) {
        if (shown) {
            DrawableRegistry.drawDrawable(minecraft, name, x, y);
        }
    }
}

