/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import com.google.common.collect.ImmutableList;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MaterialTree
implements IRecipeWrapper {
    private static final ImmutableList<OrePrefix> PREFIXES = ImmutableList.of((Object)OrePrefix.dustTiny, (Object)OrePrefix.dust, (Object)OrePrefix.dustSmall, (Object)OrePrefix.cableGtSingle, (Object)OrePrefix.ingotHot, (Object)OrePrefix.ingot, (Object)OrePrefix.gem, (Object)OrePrefix.block, (Object)OrePrefix.wireGtSingle, (Object)OrePrefix.stick, (Object)OrePrefix.nugget, (Object)OrePrefix.plate, (Object[])new OrePrefix[]{OrePrefix.wireFine, OrePrefix.frameGt, OrePrefix.round, OrePrefix.pipeNormalFluid, OrePrefix.pipeNormalItem, OrePrefix.screw, OrePrefix.bolt, OrePrefix.gear, OrePrefix.plateDouble, OrePrefix.spring, OrePrefix.stickLong, OrePrefix.gearSmall, OrePrefix.plateDense, OrePrefix.springSmall, OrePrefix.ring, OrePrefix.lens, OrePrefix.foil});
    private final List<List<ItemStack>> itemInputs = new ArrayList<List<ItemStack>>();
    private final List<List<FluidStack>> fluidInputs = new ArrayList<List<FluidStack>>();
    private final String name;
    private final String formula;
    private final int blastTemp;
    private final long avgM;
    private final long avgP;
    private final long avgN;

    public MaterialTree(Material material) {
        Fluid fluid;
        ArrayList<ItemStack> inputDusts = new ArrayList<ItemStack>();
        for (OrePrefix prefix : PREFIXES) {
            inputDusts.add(OreDictUnifier.get(prefix, material));
        }
        for (ItemStack stack : inputDusts) {
            ArrayList<ItemStack> matItemsStack = new ArrayList<ItemStack>();
            matItemsStack.add(stack);
            this.itemInputs.add(matItemsStack);
        }
        ArrayList<FluidStack> matFluidsStack = new ArrayList<FluidStack>();
        if (material.hasProperty(PropertyKey.FLUID) && (fluid = material.getFluid()) != null) {
            matFluidsStack.add(new FluidStack(fluid, 1000));
        }
        this.fluidInputs.add(matFluidsStack);
        this.name = material.getLocalizedName();
        this.formula = material.getChemicalFormula();
        this.avgM = material.getMass();
        this.avgP = material.getProtons();
        this.avgN = material.getNeutrons();
        this.blastTemp = material.hasProperty(PropertyKey.BLAST) ? material.getBlastTemperature() : 0;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setInputLists(VanillaTypes.FLUID, this.fluidInputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setOutputLists(VanillaTypes.FLUID, this.fluidInputs);
    }

    public String getMaterialName() {
        return this.name;
    }

    public String getMaterialFormula() {
        return this.formula;
    }

    public long getAvgM() {
        return this.avgM;
    }

    public long getAvgP() {
        return this.avgP;
    }

    public long getAvgN() {
        return this.avgN;
    }

    public int getBlastTemp() {
        return this.blastTemp;
    }
}

