/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import com.google.common.collect.ImmutableList;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Mods;
import gregtech.api.worldgen.config.FillerConfigUtils;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.filler.FillerEntry;
import gregtech.api.worldgen.filler.LayeredBlockFiller;
import gregtech.api.worldgen.populator.FluidSpringPopulator;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.SurfaceBlockPopulator;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import gregtech.common.blocks.BlockOre;
import gregtech.integration.jei.utils.JEIResourceDepositCategoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;

public class GTOreInfo
implements IRecipeWrapper {
    private final OreDepositDefinition definition;
    private final int maxHeight;
    private final int minHeight;
    private final String name;
    private final String description;
    private final int weight;
    private final IVeinPopulator veinPopulator;
    private final BlockFiller blockFiller;
    private final List<List<ItemStack>> groupedInputsAsItemStacks = new ArrayList<List<ItemStack>>();
    private final List<List<ItemStack>> groupedOutputsAsItemStacks;
    private final Function<Biome, Integer> biomeFunction;
    private final List<Integer> oreWeights = new ArrayList<Integer>();
    private int totalWeight = 0;

    public GTOreInfo(OreDepositDefinition definition) {
        this.definition = definition;
        if (Mods.CubicChunks.isModLoaded()) {
            this.maxHeight = definition.getMaximumHeight() == Integer.MAX_VALUE ? Integer.MAX_VALUE : definition.getMaximumHeight();
            this.minHeight = definition.getMinimumHeight() == Integer.MIN_VALUE ? Integer.MIN_VALUE : definition.getMinimumHeight();
        } else {
            this.maxHeight = definition.getMaximumHeight() == Integer.MAX_VALUE ? 255 : definition.getMaximumHeight();
            this.minHeight = definition.getMinimumHeight() == Integer.MIN_VALUE ? 0 : definition.getMinimumHeight();
        }
        this.name = definition.getAssignedName() == null ? FileUtility.trimFileName(definition.getDepositName()) : definition.getAssignedName();
        this.description = definition.getDescription();
        this.weight = definition.getWeight();
        this.veinPopulator = definition.getVeinPopulator();
        ItemStack identifierStack = GTOreInfo.findSurfaceBlock(this.veinPopulator);
        this.blockFiller = definition.getBlockFiller();
        this.biomeFunction = definition.getBiomeWeightModifier();
        List<ItemStack> generatedBlocksAsItemStacks = this.findComponentBlocksAsItemStacks();
        this.groupedInputsAsItemStacks.add(generatedBlocksAsItemStacks);
        this.groupedInputsAsItemStacks.add(Collections.singletonList(identifierStack));
        this.groupedOutputsAsItemStacks = this.blockFiller instanceof LayeredBlockFiller ? this.getLayeredVeinOutputStacks() : this.findUniqueBlocksAsItemStack(generatedBlocksAsItemStacks);
        List<FillerEntry> fillerEntries = this.blockFiller.getAllPossibleStates();
        for (FillerEntry entries : fillerEntries) {
            if (entries == null || entries.getEntries().isEmpty()) continue;
            for (Pair<Integer, FillerEntry> entry : entries.getEntries()) {
                this.totalWeight += ((Integer)entry.getKey()).intValue();
            }
        }
        FillerEntry entry = fillerEntries.get(0);
        if (entry.getEntries() != null && !entry.getEntries().isEmpty()) {
            for (int i = 0; i < this.getOutputCount(); ++i) {
                Pair<Integer, FillerEntry> entryWithWeight = entry.getEntries().get(i);
                this.oreWeights.add((int)Math.round((double)((Integer)entryWithWeight.getKey()).intValue() / (double)this.totalWeight * 100.0));
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.groupedInputsAsItemStacks);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.groupedOutputsAsItemStacks);
    }

    public List<ItemStack> findComponentBlocksAsItemStacks() {
        ArrayList<IBlockState> containedStates = new ArrayList<IBlockState>();
        ArrayList<ItemStack> containedBlocksAsItemStacks = new ArrayList<ItemStack>();
        this.blockFiller.getAllPossibleStates().forEach(e -> GTOreInfo.getPossibleStates(e, containedStates));
        if (this.veinPopulator instanceof FluidSpringPopulator) {
            for (IBlockState state : containedStates) {
                Block temp = state.func_177230_c();
                if (!(temp instanceof IFluidBlock)) continue;
                Fluid fluid = ((IFluidBlock)temp).getFluid();
                FluidStack fStack = new FluidStack(fluid, 1000);
                ItemStack stack = FluidUtil.getFilledBucket((FluidStack)fStack);
                containedBlocksAsItemStacks.add(stack);
            }
        } else {
            GTOreInfo.getStacksFromStates(containedStates, containedBlocksAsItemStacks);
        }
        return containedBlocksAsItemStacks;
    }

    private static Collection<IBlockState> getPossibleStates(FillerEntry entry, Collection<IBlockState> collection) {
        for (IBlockState state : entry.getPossibleResults()) {
            if (state.func_177230_c() instanceof BlockOre && !((StoneType)state.func_177229_b((IProperty)((BlockOre)state.func_177230_c()).STONE_TYPE)).shouldBeDroppedAsItem) continue;
            collection.add(state);
        }
        return collection;
    }

    private static List<ItemStack> getStacksFromStates(Collection<IBlockState> states, List<ItemStack> list) {
        for (IBlockState state : states) {
            list.add(GTUtility.toItem(state));
        }
        return list;
    }

    private List<List<ItemStack>> getLayeredVeinOutputStacks() {
        LayeredBlockFiller filler = (LayeredBlockFiller)this.blockFiller;
        return ImmutableList.of(GTOreInfo.getStacksFromStates(GTOreInfo.getPossibleStates(filler.getPrimary(), new ArrayList<IBlockState>()), new ArrayList<ItemStack>()), GTOreInfo.getStacksFromStates(GTOreInfo.getPossibleStates(filler.getSecondary(), new ArrayList<IBlockState>()), new ArrayList<ItemStack>()), GTOreInfo.getStacksFromStates(GTOreInfo.getPossibleStates(filler.getBetween(), new ArrayList<IBlockState>()), new ArrayList<ItemStack>()), GTOreInfo.getStacksFromStates(GTOreInfo.getPossibleStates(filler.getSporadic(), new ArrayList<IBlockState>()), new ArrayList<ItemStack>()));
    }

    public List<List<ItemStack>> findUniqueBlocksAsItemStack(List<ItemStack> itemList) {
        ArrayList<List<ItemStack>> groupedItems = new ArrayList<List<ItemStack>>();
        int entries = itemList.size();
        if (this.veinPopulator instanceof FluidSpringPopulator) {
            groupedItems.add(new ArrayList<ItemStack>(itemList));
            return groupedItems;
        }
        ItemStack firstItem = itemList.get(0);
        ArrayList<ItemStack> oreList = new ArrayList<ItemStack>();
        oreList.add(firstItem);
        for (int counter = 1; counter < entries; ++counter) {
            ItemStack item = itemList.get(counter);
            if (firstItem.func_77973_b() != item.func_77973_b()) {
                groupedItems.add(new ArrayList(oreList));
                oreList.clear();
            }
            oreList.add(item);
            firstItem = item;
        }
        groupedItems.add(new ArrayList(oreList));
        return groupedItems;
    }

    public static ItemStack findSurfaceBlock(IVeinPopulator veinPopulator) {
        IBlockState state;
        Block temp;
        ItemStack stack = new ItemStack(Items.field_190931_a);
        if (veinPopulator instanceof SurfaceRockPopulator) {
            Material mat = ((SurfaceRockPopulator)veinPopulator).getMaterial();
            stack = OreDictUnifier.getDust(mat.multiply(403200L));
            return stack.func_190926_b() ? new ItemStack(Items.field_190931_a) : stack;
        }
        if (veinPopulator instanceof SurfaceBlockPopulator) {
            IBlockState state2 = ((SurfaceBlockPopulator)veinPopulator).getBlockState();
            stack = GTUtility.toItem(state2);
            return stack;
        }
        if (veinPopulator instanceof FluidSpringPopulator && (temp = (state = ((FluidSpringPopulator)veinPopulator).getFluidState()).func_177230_c()) instanceof IFluidBlock) {
            Fluid fluid = ((IFluidBlock)temp).getFluid();
            FluidStack fStack = new FluidStack(fluid, 1000);
            stack = FluidUtil.getFilledBucket((FluidStack)fStack);
            return stack;
        }
        return stack;
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        if (slotIndex == 0) {
            tooltip.addAll(JEIResourceDepositCategoryUtils.createSpawnPageBiomeTooltip(this.biomeFunction, this.weight));
            if (this.description != null) {
                tooltip.add(this.description);
            }
        } else if (slotIndex == 1) {
            if (this.veinPopulator instanceof SurfaceRockPopulator) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.surface_rock_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.surface_rock_2", (Object[])new Object[0]));
            }
        } else if (this.blockFiller instanceof LayeredBlockFiller) {
            tooltip.addAll(this.createOreLayeringTooltip(slotIndex));
        } else {
            tooltip.addAll(this.createOreWeightingTooltip(slotIndex));
        }
    }

    public List<String> createOreWeightingTooltip(int slotIndex) {
        ArrayList<String> tooltip = new ArrayList<String>();
        List<FillerEntry> fillerEntries = this.blockFiller.getAllPossibleStates();
        for (FillerEntry entry : fillerEntries) {
            if (entry.getEntries() == null || entry.getEntries().isEmpty()) continue;
            Pair<Integer, FillerEntry> entryWithWeight = entry.getEntries().get(slotIndex - 2);
            double weight = Math.round((double)((Integer)entryWithWeight.getKey()).intValue() / (double)this.totalWeight * 100.0);
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.ore_weight", (Object[])new Object[]{weight}));
        }
        return tooltip;
    }

    private List<String> createOreLayeringTooltip(int slotIndex) {
        ArrayList<String> tooltip = new ArrayList<String>();
        FillerConfigUtils.LayeredFillerEntry filler = (FillerConfigUtils.LayeredFillerEntry)this.blockFiller.getAllPossibleStates().get(0);
        switch (slotIndex) {
            case 2: {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.primary_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.primary_2", (Object[])new Object[]{filler.getPrimaryLayers()}));
                break;
            }
            case 3: {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.secondary_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.secondary_2", (Object[])new Object[]{filler.getSecondaryLayers()}));
                break;
            }
            case 4: {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.between_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.between_2", (Object[])new Object[]{filler.getBetweenLayers()}));
                break;
            }
            case 5: {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.sporadic_1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.sporadic_2", (Object[])new Object[0]));
            }
        }
        return tooltip;
    }

    public int getOutputCount() {
        return this.groupedOutputsAsItemStacks.size();
    }

    public String getVeinName() {
        return this.name;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getWeight() {
        return this.weight;
    }

    public OreDepositDefinition getDefinition() {
        return this.definition;
    }

    public int getOreWeight(int index) {
        return this.oreWeights.size() > index ? this.oreWeights.get(index) : -1;
    }
}

