/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class SteamBoilerDataProvider
implements IWailaDataProvider {
    public static final SteamBoilerDataProvider INSTANCE = new SteamBoilerDataProvider();

    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.addConfig("GregTech", "gregtech.steam_boiler");
    }

    @NotNull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IGregTechTileEntity gtte;
        MetaTileEntity metaTileEntity;
        if (te instanceof IGregTechTileEntity && (metaTileEntity = (gtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof SteamBoiler) {
            SteamBoiler boiler = (SteamBoiler)metaTileEntity;
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74757_a("IsBurning", boiler.isBurning());
            subTag.func_74757_a("HasWater", boiler.hasWater());
            subTag.func_74768_a("SteamRate", boiler.getTotalSteamOutput());
            tag.func_74782_a("gregtech.SteamBoiler", (NBTBase)subTag);
        }
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag;
        IGregTechTileEntity gtte;
        TileEntity tileEntity;
        if (!(config.getConfig("gregtech.steam_boiler") && (tileEntity = accessor.getTileEntity()) instanceof IGregTechTileEntity && (gtte = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof SteamBoiler)) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.SteamBoiler") && (tag = accessor.getNBTData().func_74775_l("gregtech.SteamBoiler")).func_74767_n("IsBurning")) {
            int steamRate = tag.func_74762_e("SteamRate");
            boolean hasWater = tag.func_74767_n("HasWater");
            if (steamRate > 0 && hasWater) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_production", (Object[])new Object[0]) + ": " + TextFormattingUtil.formatNumbers(steamRate / 10) + " L/t " + I18n.func_135052_a((String)Materials.Steam.getUnlocalizedName(), (Object[])new Object[0]));
            }
            if (steamRate <= 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.steam_heating_up", (Object[])new Object[0]));
            }
            if (!hasWater) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.steam_no_water", (Object[])new Object[0]));
            }
        }
        return tooltip;
    }
}

