/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.unification.material.Materials;
import gregtech.common.items.ToolItems;
import gregtech.integration.hwyla.HWYLAModule;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class MaintenanceDataProvider
extends CapabilityDataProvider<IMaintenance> {
    public static final MaintenanceDataProvider INSTANCE = new MaintenanceDataProvider();
    private static final ItemStack WRENCH = ToolItems.WRENCH.get(Materials.Neutronium);
    private static final ItemStack SCREWDRIVER = ToolItems.SCREWDRIVER.get(Materials.Neutronium);
    private static final ItemStack SOFT_MALLET = ToolItems.SOFT_MALLET.get(Materials.Neutronium);
    private static final ItemStack HARD_HAMMER = ToolItems.HARD_HAMMER.get(Materials.Neutronium);
    private static final ItemStack WIRE_CUTTERS = ToolItems.WIRE_CUTTER.get(Materials.Neutronium);
    private static final ItemStack CROWBAR = ToolItems.CROWBAR.get(Materials.Neutronium);

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.maintenance");
    }

    @Override
    @NotNull
    protected Capability<IMaintenance> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_MAINTENANCE;
    }

    @Override
    protected NBTTagCompound getNBTData(IMaintenance capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74757_a("HasProblems", capability.hasMaintenanceProblems());
        subTag.func_74768_a("Problems", (int)capability.getMaintenanceProblems());
        tag.func_74782_a("gregtech.IMaintenance", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.maintenance") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IMaintenance")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.IMaintenance");
            IMultiblockController controller = (IMultiblockController)accessor.getTileEntity().getCapability(GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER, null);
            if (controller == null || !controller.isStructureFormed()) {
                return tooltip;
            }
            if (tag.func_74767_n("HasProblems")) {
                if (accessor.getPlayer().func_70093_af()) {
                    int problems = tag.func_74762_e("Problems");
                    for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                        if ((problems >> i & 1) != 0) continue;
                        ItemStack stack = ItemStack.field_190927_a;
                        String text = "";
                        switch (i) {
                            case 0: {
                                stack = WRENCH;
                                text = "gregtech.top.maintenance.wrench";
                                break;
                            }
                            case 1: {
                                stack = SCREWDRIVER;
                                text = "gregtech.top.maintenance.screwdriver";
                                break;
                            }
                            case 2: {
                                stack = SOFT_MALLET;
                                text = "gregtech.top.maintenance.soft_mallet";
                                break;
                            }
                            case 3: {
                                stack = HARD_HAMMER;
                                text = "gregtech.top.maintenance.hard_hammer";
                                break;
                            }
                            case 4: {
                                stack = WIRE_CUTTERS;
                                text = "gregtech.top.maintenance.wire_cutter";
                                break;
                            }
                            case 5: {
                                stack = CROWBAR;
                                text = "gregtech.top.maintenance.crowbar";
                            }
                        }
                        tooltip.add(HWYLAModule.wailaStackWithName(stack, I18n.func_135052_a((String)text, (Object[])new Object[0])));
                    }
                } else {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.top.maintenance_broken", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.maintenance_fixed", (Object[])new Object[0]));
            }
        }
        return tooltip;
    }
}

