/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.recipes;

import appeng.core.Api;
import com.google.common.collect.ImmutableMap;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.ModuleCore;
import forestry.factory.ModuleFactory;
import gregtech.api.GTValues;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Mods;
import gregtech.common.items.MetaItems;
import gregtech.integration.forestry.ForestryUtil;
import gregtech.integration.forestry.bees.GTCombItem;
import gregtech.integration.forestry.bees.GTCombType;
import gregtech.integration.forestry.bees.GTDropType;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CombRecipes {
    public static void initForestryCombs() {
        if (!ModuleFactory.machineEnabled((String)"centrifuge")) {
            return;
        }
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            ItemStack combStack;
            if (recipe.getAllProducts().isEmpty() || (combStack = recipe.getInput()).func_77973_b() instanceof GTCombItem) continue;
            Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().inputs(combStack.func_77946_l())).duration(Voltage.ULV.getCentrifugeTime())).EUt(Voltage.ULV.getCentrifugeEnergy());
            for (Map.Entry entry : recipe.getAllProducts().entrySet()) {
                if (((Float)entry.getValue()).floatValue() >= 1.0f) {
                    ((RecipeBuilder)builder).outputs((ItemStack)entry.getKey());
                    continue;
                }
                ((RecipeBuilder)builder).chancedOutput((ItemStack)entry.getKey(), Math.max(1, Math.round(((Float)entry.getValue()).floatValue() * 10000.0f)), 0);
            }
            ((RecipeBuilder)builder).buildAndRegister();
        }
    }

    public static void initGTCombs() {
        CombRecipes.addProcessGT(GTCombType.COAL, new Material[]{Materials.Coal}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.COKE, new Material[]{Materials.Coke}, Voltage.LV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.STICKY, new ItemStack[]{MetaItems.STICKY_RESIN.getStackForm(), MetaItems.PLANT_BALL.getStackForm(), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{5000, 1500, 5000}, Voltage.ULV);
        CombRecipes.addProcessGT(GTCombType.OIL, new Material[]{Materials.Oilsands}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.APATITE, new Material[]{Materials.Apatite, Materials.TricalciumPhosphate}, Voltage.LV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.ASH, new Material[]{Materials.DarkAsh, Materials.Ash}, new int[]{5000, 5000}, new int[]{9, 9}, Voltage.ULV, ItemStack.field_190927_a, 5000);
        CombRecipes.addCentrifugeToItemStack(GTCombType.BIOMASS, new ItemStack[]{ForestryUtil.getDropStack(GTDropType.BIOMASS), ForestryUtil.getDropStack(GTDropType.ETHANOL), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{7000, 3000, 5000}, Voltage.ULV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.PHOSPHORUS, new ItemStack[]{OreDictUnifier.get(OrePrefix.dust, Materials.Phosphorus), OreDictUnifier.get(OrePrefix.dust, Materials.TricalciumPhosphate), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{10000, 10000, 10000}, Voltage.HV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.COAL, new ItemStack[]{OreDictUnifier.get(OrePrefix.gem, Materials.Coal), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{500, 5000}, Voltage.ULV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.COKE, new ItemStack[]{OreDictUnifier.get(OrePrefix.gem, Materials.Coke), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{500, 5000}, Voltage.ULV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.OIL, new ItemStack[]{OreDictUnifier.get(OrePrefix.dustTiny, Materials.Oilsands), ForestryUtil.getDropStack(GTDropType.OIL), ModuleCore.getItems().beeswax.getItemStack()}, new int[]{7000, 10000, 5000}, Voltage.ULV);
        CombRecipes.addCentrifugeToItemStack(GTCombType.ENERGY, new ItemStack[]{MetaItems.ENERGIUM_DUST.getStackForm(), ModuleCore.getItems().refractoryWax.getItemStack()}, new int[]{2000, 5000}, Voltage.HV, 196);
        ItemStack wax = ModuleCore.getItems().beeswax.getItemStack();
        if (Mods.MagicBees.isModLoaded()) {
            wax = Mods.MagicBees.getItem("wax", 2);
        }
        CombRecipes.addCentrifugeToItemStack(GTCombType.LAPOTRON, new ItemStack[]{OreDictUnifier.get(OrePrefix.dust, Materials.Lapotron), wax}, new int[]{10000, 4000}, Voltage.HV, 196);
        CombRecipes.addProcessGT(GTCombType.REDALLOY, new Material[]{Materials.RedAlloy, Materials.Redstone, Materials.Copper}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.STAINLESSSTEEL, new Material[]{Materials.StainlessSteel, Materials.Iron, Materials.Chrome, Materials.Manganese, Materials.Nickel}, Voltage.HV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.REDALLOY, new Material[]{Materials.RedAlloy}, new int[]{10000}, new int[]{9}, Voltage.ULV, ModuleCore.getItems().refractoryWax.getItemStack(), 5000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.STAINLESSSTEEL, new Material[]{Materials.StainlessSteel}, new int[]{5000}, new int[]{9}, Voltage.HV, ModuleCore.getItems().refractoryWax.getItemStack(), 5000);
        CombRecipes.addProcessGT(GTCombType.STONE, new Material[]{Materials.Soapstone, Materials.Talc, Materials.Apatite, Materials.Phosphate, Materials.TricalciumPhosphate}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.CERTUS, new Material[]{Materials.CertusQuartz, Materials.Quartzite, Materials.Barite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.REDSTONE, new Material[]{Materials.Redstone, Materials.Cinnabar}, Voltage.LV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.RAREEARTH, new Material[]{Materials.RareEarth}, new int[]{10000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addProcessGT(GTCombType.LAPIS, new Material[]{Materials.Lapis, Materials.Sodalite, Materials.Lazurite, Materials.Calcite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.RUBY, new Material[]{Materials.Ruby, Materials.Redstone}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.SAPPHIRE, new Material[]{Materials.Sapphire, Materials.GreenSapphire, Materials.Almandine, Materials.Pyrope}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.DIAMOND, new Material[]{Materials.Diamond, Materials.Graphite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.OLIVINE, new Material[]{Materials.Olivine, Materials.Bentonite, Materials.Magnesite, Materials.GlauconiteSand}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.EMERALD, new Material[]{Materials.Emerald, Materials.Beryllium, Materials.Thorium}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.PYROPE, new Material[]{Materials.Pyrope, Materials.Aluminium, Materials.Magnesium, Materials.Silicon}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.GROSSULAR, new Material[]{Materials.Grossular, Materials.Aluminium, Materials.Silicon}, Voltage.LV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.STONE, new Material[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed, Materials.Basalt, Materials.Marble}, new int[]{7000, 5000, 5000, 5000, 5000}, new int[]{9, 9, 9, 9, 9}, Voltage.ULV, ItemStack.field_190927_a, 5000);
        CombRecipes.addProcessGT(GTCombType.COPPER, new Material[]{Materials.Copper, Materials.Tetrahedrite, Materials.Chalcopyrite, Materials.Malachite, Materials.Pyrite, Materials.Stibnite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.TIN, new Material[]{Materials.Tin, Materials.Cassiterite, Materials.CassiteriteSand}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.LEAD, new Material[]{Materials.Lead, Materials.Galena}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.NICKEL, new Material[]{Materials.Nickel, Materials.Garnierite, Materials.Pentlandite, Materials.Cobaltite, Materials.Wulfenite, Materials.Powellite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.ZINC, new Material[]{Materials.Sphalerite, Materials.Sulfur}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.SILVER, new Material[]{Materials.Silver, Materials.Galena}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.GOLD, new Material[]{Materials.Gold, Materials.Magnetite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.SULFUR, new Material[]{Materials.Sulfur, Materials.Pyrite, Materials.Sphalerite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.GALLIUM, new Material[]{Materials.Gallium, Materials.Niobium}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.ARSENIC, new Material[]{Materials.Realgar, Materials.Cassiterite, Materials.Zeolite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.IRON, new Material[]{Materials.Iron, Materials.Magnetite, Materials.BrownLimonite, Materials.YellowLimonite, Materials.VanadiumMagnetite, Materials.BandedIron, Materials.Pyrite}, Voltage.LV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.SLAG, new Material[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed}, new int[]{5000, 2000, 2000}, new int[]{9, 9, 9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.COPPER, new Material[]{Materials.Copper}, new int[]{7000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.TIN, new Material[]{Materials.Tin}, new int[]{6000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.LEAD, new Material[]{Materials.Lead}, new int[]{4500}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.IRON, new Material[]{Materials.Iron}, new int[]{3000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.STEEL, new Material[]{Materials.Steel}, new int[]{4000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addCentrifugeToMaterial(GTCombType.SILVER, new Material[]{Materials.Silver}, new int[]{8000}, new int[]{9}, Voltage.ULV, ItemStack.field_190927_a, 3000);
        CombRecipes.addProcessGT(GTCombType.BAUXITE, new Material[]{Materials.Bauxite, Materials.Aluminium}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.ALUMINIUM, new Material[]{Materials.Aluminium, Materials.Bauxite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.MANGANESE, new Material[]{Materials.Manganese, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.TITANIUM, new Material[]{Materials.Titanium, Materials.Ilmenite, Materials.Bauxite, Materials.Rutile}, Voltage.EV);
        CombRecipes.addProcessGT(GTCombType.MAGNESIUM, new Material[]{Materials.Magnesium, Materials.Magnesite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.CHROME, new Material[]{Materials.Chrome, Materials.Ruby, Materials.Chromite, Materials.Redstone, Materials.Neodymium, Materials.Bastnasite}, Voltage.HV);
        CombRecipes.addProcessGT(GTCombType.TUNGSTEN, new Material[]{Materials.Tungsten, Materials.Tungstate, Materials.Scheelite, Materials.Lithium}, Voltage.IV);
        CombRecipes.addProcessGT(GTCombType.PLATINUM, new Material[]{Materials.Platinum, Materials.Cooperite, Materials.Palladium}, Voltage.HV);
        CombRecipes.addProcessGT(GTCombType.MOLYBDENUM, new Material[]{Materials.Molybdenum, Materials.Molybdenite, Materials.Powellite, Materials.Wulfenite}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.LITHIUM, new Material[]{Materials.Lithium, Materials.Lepidolite, Materials.Spodumene}, Voltage.MV);
        CombRecipes.addProcessGT(GTCombType.SALT, new Material[]{Materials.Salt, Materials.RockSalt, Materials.Saltpeter}, Voltage.MV);
        CombRecipes.addProcessGT(GTCombType.ELECTROTINE, new Material[]{Materials.Electrotine, Materials.Electrum, Materials.Redstone}, Voltage.MV);
        CombRecipes.addCentrifugeToMaterial(GTCombType.SALT, new Material[]{Materials.Salt, Materials.RockSalt, Materials.Saltpeter}, new int[]{10000, 10000, 2500}, new int[]{54, 54, 54}, Voltage.MV, 160, ItemStack.field_190927_a, 5000);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().inputs(ForestryUtil.getCombStack(GTCombType.IRIDIUM, 4))).fluidInputs(Voltage.IV.getFluid())).output(OrePrefix.nugget, Materials.Iridium)).output(OrePrefix.dust, Materials.IridiumMetalResidue, 5)).cleanroom(CleanroomType.CLEANROOM)).duration(1000)).EUt(Voltage.IV.getChemicalEnergy())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().inputs(ForestryUtil.getCombStack(GTCombType.OSMIUM, 4))).fluidInputs(Voltage.IV.getFluid())).output(OrePrefix.nugget, Materials.Osmium)).fluidOutputs(Materials.AcidicOsmiumSolution.getFluid(2000))).cleanroom(CleanroomType.CLEANROOM)).duration(1000)).EUt(Voltage.IV.getChemicalEnergy())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Aluminium, 4)).inputs(ForestryUtil.getCombStack(GTCombType.INDIUM))).fluidInputs(Materials.IndiumConcentrate.getFluid(1000))).output(OrePrefix.dustSmall, Materials.Indium, 2)).output(OrePrefix.dust, Materials.AluminiumSulfite, 4)).fluidOutputs(Materials.LeadZincSolution.getFluid(1000))).duration(50)).EUt(600)).buildAndRegister();
        CombRecipes.addProcessGT(GTCombType.ALMANDINE, new Material[]{Materials.Almandine, Materials.Pyrope, Materials.Sapphire, Materials.GreenSapphire}, Voltage.LV);
        CombRecipes.addProcessGT(GTCombType.URANIUM, new Material[]{Materials.Uranium238, Materials.Pitchblende, Materials.Uraninite, Materials.Uranium235}, Voltage.EV);
        CombRecipes.addProcessGT(GTCombType.PLUTONIUM, new Material[]{Materials.Plutonium239, Materials.Uranium235}, Voltage.EV);
        CombRecipes.addProcessGT(GTCombType.NAQUADAH, new Material[]{Materials.Naquadah, Materials.NaquadahEnriched, Materials.Naquadria}, Voltage.IV);
        CombRecipes.addProcessGT(GTCombType.NAQUADRIA, new Material[]{Materials.Naquadria, Materials.NaquadahEnriched, Materials.Naquadah}, Voltage.LUV);
        CombRecipes.addProcessGT(GTCombType.THORIUM, new Material[]{Materials.Thorium, Materials.Uranium238, Materials.Coal}, Voltage.EV);
        CombRecipes.addProcessGT(GTCombType.LUTETIUM, new Material[]{Materials.Lutetium, Materials.Thorium}, Voltage.IV);
        CombRecipes.addProcessGT(GTCombType.AMERICIUM, new Material[]{Materials.Americium, Materials.Lutetium}, Voltage.LUV);
        CombRecipes.addProcessGT(GTCombType.TRINIUM, new Material[]{Materials.Trinium, Materials.Naquadah, Materials.Naquadria}, Voltage.ZPM);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().inputs(ForestryUtil.getCombStack(GTCombType.NEUTRONIUM, 4))).fluidInputs(Voltage.UV.getFluid())).output(OrePrefix.nugget, Materials.Neutronium)).fluidOutputs(Materials.Neutronium.getFluid(576))).cleanroom(CleanroomType.CLEANROOM)).duration(3000)).EUt(Voltage.UV.getChemicalEnergy())).buildAndRegister();
        if (Mods.MagicBees.isModLoaded()) {
            CombRecipes.addProcessGT(GTCombType.SPARKLING, new Material[]{Materials.NetherStar}, Voltage.EV);
            CombRecipes.addCentrifugeToItemStack(GTCombType.SPARKLING, new ItemStack[]{Mods.MagicBees.getItem("wax", 0), Mods.MagicBees.getItem("resource", 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.NetherStar)}, new int[]{5000, 1000, 1000}, Voltage.EV);
        }
        CombRecipes.addExtractorProcess(GTCombType.HELIUM, Materials.Helium.getFluid(250), Voltage.HV, 100);
        CombRecipes.addExtractorProcess(GTCombType.ARGON, Materials.Argon.getFluid(250), Voltage.MV, 100);
        CombRecipes.addExtractorProcess(GTCombType.XENON, Materials.Xenon.getFluid(250), Voltage.IV, 50);
        CombRecipes.addExtractorProcess(GTCombType.NEON, Materials.Neon.getFluid(250), Voltage.IV, 15);
        CombRecipes.addExtractorProcess(GTCombType.KRYPTON, Materials.Krypton.getFluid(250), Voltage.IV, 25);
        CombRecipes.addExtractorProcess(GTCombType.NITROGEN, Materials.Nitrogen.getFluid(500), Voltage.MV, 100);
        CombRecipes.addExtractorProcess(GTCombType.OXYGEN, Materials.Oxygen.getFluid(500), Voltage.MV, 100);
        CombRecipes.addExtractorProcess(GTCombType.HYDROGEN, Materials.Hydrogen.getFluid(500), Voltage.MV, 100);
        CombRecipes.addExtractorProcess(GTCombType.FLUORINE, Materials.Fluorine.getFluid(250), Voltage.MV, 128);
        if (Mods.AppliedEnergistics2.isModLoaded()) {
            ItemStack fluixDust = OreDictUnifier.get("dustFluix");
            if (fluixDust == ItemStack.field_190927_a) {
                fluixDust = Api.INSTANCE.definitions().materials().fluixDust().maybeStack(1).orElse(ItemStack.field_190927_a);
            }
            if (fluixDust != ItemStack.field_190927_a) {
                CombRecipes.addCentrifugeToItemStack(GTCombType.FLUIX, new ItemStack[]{fluixDust, ModuleCore.getItems().beeswax.getItemStack()}, new int[]{2500, 3000}, Voltage.ULV);
            }
        }
    }

    private static void addChemicalProcess(GTCombType comb, Material inMaterial, Material outMaterial, Voltage volt) {
        Material byproduct;
        if (OreDictUnifier.get(OrePrefix.crushedPurified, outMaterial, 4).func_190926_b() || OreDictUnifier.get(OrePrefix.crushed, inMaterial).func_190926_b() || inMaterial.hasFlag(MaterialFlags.DISABLE_ORE_BLOCK)) {
            return;
        }
        Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().inputs(GTUtility.copy(9, ForestryUtil.getCombStack(comb)))).input(OrePrefix.crushed, inMaterial)).fluidInputs(volt.getFluid())).output(OrePrefix.crushedPurified, outMaterial, 4)).duration(volt.getChemicalTime())).EUt(volt.getChemicalEnergy());
        OreProperty property = inMaterial.getProperty(PropertyKey.ORE);
        if (property != null && !property.getOreByProducts().isEmpty() && (byproduct = property.getOreByProducts().get(0)) != null && byproduct.hasProperty(PropertyKey.FLUID) && !byproduct.hasProperty(PropertyKey.BLAST)) {
            ((RecipeBuilder)builder).fluidOutputs(byproduct.getFluid(144));
        }
        if (volt.compareTo(Voltage.IV) > 0) {
            ((RecipeBuilder)builder).cleanroom(CleanroomType.CLEANROOM);
        }
        ((RecipeBuilder)builder).buildAndRegister();
    }

    private static void addAutoclaveProcess(GTCombType comb, Material material, Voltage volt, int circuitNumber) {
        if (OreDictUnifier.get(OrePrefix.crushedPurified, material, 4).func_190926_b()) {
            return;
        }
        Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(GTUtility.copy(9, ForestryUtil.getCombStack(comb)))).circuitMeta(circuitNumber)).fluidInputs(Materials.Mutagen.getFluid((int)Math.max(1L, material.getMass() + (long)volt.getMutagenAmount())))).output(OrePrefix.crushedPurified, material, 4)).duration((int)(material.getMass() * 128L))).EUt(volt.getAutoclaveEnergy());
        if (volt.compareTo(Voltage.HV) > 0) {
            ((RecipeBuilder)builder).cleanroom(CleanroomType.CLEANROOM);
        }
        ((RecipeBuilder)builder).buildAndRegister();
    }

    private static void addExtractorProcess(GTCombType comb, FluidStack fluidStack, Voltage volt, int duration) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(ForestryUtil.getCombStack(comb))).fluidOutputs(fluidStack)).duration(duration)).EUt(volt.getCentrifugeEnergy() / 2)).buildAndRegister();
    }

    private static void addProcessGT(GTCombType comb, Material[] material, Voltage volt) {
        for (int i = 0; i < material.length; ++i) {
            CombRecipes.addChemicalProcess(comb, material[i], material[i], volt);
            CombRecipes.addAutoclaveProcess(comb, material[i], volt, i + 1);
        }
    }

    private static void addCentrifugeToMaterial(GTCombType comb, Material[] material, int[] chance, int[] stackSize, Voltage volt, ItemStack beeWax, int waxChance) {
        CombRecipes.addCentrifugeToMaterial(comb, material, chance, stackSize, volt, volt.getCentrifugeTime(), beeWax, waxChance);
    }

    private static void addCentrifugeToMaterial(GTCombType comb, Material[] material, int[] chance, int[] stackSize, Voltage volt, int duration, ItemStack beeWax, int waxChance) {
        ItemStack[] output = new ItemStack[material.length + 1];
        stackSize = Arrays.copyOf(stackSize, material.length);
        chance = Arrays.copyOf(chance, output.length);
        chance[chance.length - 1] = waxChance;
        for (int i = 0; i < material.length; ++i) {
            if (chance[i] == 0) continue;
            output[i] = Math.max(1, stackSize[i]) % 9 == 0 ? OreDictUnifier.get(OrePrefix.dust, material[i], Math.max(1, stackSize[i]) / 9) : (Math.max(1, stackSize[i]) % 4 == 0 ? OreDictUnifier.get(OrePrefix.dustSmall, material[i], Math.max(1, stackSize[i]) / 4) : OreDictUnifier.get(OrePrefix.dustTiny, material[i], Math.max(1, stackSize[i])));
        }
        output[output.length - 1] = beeWax != ItemStack.field_190927_a ? beeWax : ModuleCore.getItems().beeswax.getItemStack();
        CombRecipes.addCentrifugeToItemStack(comb, output, chance, volt, duration);
    }

    private static void addCentrifugeToItemStack(GTCombType comb, ItemStack[] item, int[] chance, Voltage volt) {
        CombRecipes.addCentrifugeToItemStack(comb, item, chance, volt, volt.getCentrifugeTime());
    }

    private static void addCentrifugeToItemStack(GTCombType comb, ItemStack[] item, int[] chance, Voltage volt, int duration) {
        ItemStack combStack = ForestryUtil.getCombStack(comb);
        ImmutableMap.Builder product = new ImmutableMap.Builder();
        Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().inputs(combStack)).duration(duration)).EUt(volt.getCentrifugeEnergy());
        int numGTOutputs = 0;
        for (int i = 0; i < item.length; ++i) {
            if (item[i] == null || item[i] == ItemStack.field_190927_a) continue;
            product.put((Object)item[i], (Object)Float.valueOf((float)chance[i] / 10000.0f));
            if (numGTOutputs >= RecipeMaps.CENTRIFUGE_RECIPES.getMaxOutputs()) continue;
            if (chance[i] >= 10000) {
                ((RecipeBuilder)builder).outputs(item[i]);
            } else {
                ((RecipeBuilder)builder).chancedOutput(item[i], chance[i], 0);
            }
            ++numGTOutputs;
        }
        if (volt.compareTo(Voltage.MV) < 0 && ModuleFactory.machineEnabled((String)"centrifuge")) {
            RecipeManagers.centrifugeManager.addRecipe(duration, combStack, (Map)product.build());
        }
        ((RecipeBuilder)builder).buildAndRegister();
    }

    private static enum Voltage {
        ULV,
        LV,
        MV,
        HV,
        EV,
        IV,
        LUV,
        ZPM,
        UV,
        UHV,
        UEV,
        UIV,
        UXV,
        OPV,
        MAX;


        public int getVoltage() {
            return (int)GTValues.V[this.ordinal()];
        }

        public int getChemicalEnergy() {
            return this.getVoltage() * 3 / 4;
        }

        public int getAutoclaveEnergy() {
            return (int)((double)(this.getVoltage() * 3 / 4) * Math.max(1.0, Math.pow(2.0, 5 - this.ordinal())));
        }

        public int getCentrifugeEnergy() {
            return this == ULV ? 5 : this.getVoltage() / 16 * 15;
        }

        public int getChemicalTime() {
            return 64 + this.ordinal() * 32;
        }

        public int getCentrifugeTime() {
            return 128 * Math.max(1, this.ordinal());
        }

        public FluidStack getFluid() {
            if (this.compareTo(MV) < 0) {
                return Materials.Water.getFluid(this.compareTo(ULV) > 0 ? 1000 : 500);
            }
            if (this.compareTo(HV) < 0) {
                return Materials.DistilledWater.getFluid(1000);
            }
            if (this.compareTo(EV) < 0) {
                return Materials.SulfuricAcid.getFluid(125);
            }
            if (this.compareTo(IV) < 0) {
                return Materials.HydrochloricAcid.getFluid(125);
            }
            if (this.compareTo(LUV) < 0) {
                return Materials.HydrofluoricAcid.getFluid((int)(Math.pow(2.0, this.compareTo(HV)) * 125.0));
            }
            return Materials.FluoroantimonicAcid.getFluid((int)(Math.pow(2.0, this.compareTo(LUV)) * 125.0));
        }

        public int getMutagenAmount() {
            return 9 * (this.compareTo(MV) < 0 ? 10 : 10 * this.compareTo(MV));
        }
    }
}

