/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.frames;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import org.jetbrains.annotations.Nullable;

public enum GTFrameType implements IBeeModifier
{
    ACCELERATED("Accelerated", 175, 1.0f, 1.2f, 0.9f, 1.8f, 1.0f, 1.0f),
    MUTAGENIC("Mutagenic", 3, 1.0f, 5.0f, 1.0E-4f, 10.0f, 1.0f, 1.0f),
    WORKING("Working", 2000, 1.0f, 0.0f, 3.0f, 4.0f, 1.0f, 1.0f),
    DECAYING("Decaying", 240, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 10.0f),
    SLOWING("Slowing", 175, 1.0f, 0.5f, 2.0f, 0.5f, 1.0f, 1.0f),
    STABILIZING("Stabilizing", 60, 1.0f, 0.1f, 1.0f, 0.1f, 1.0f, 0.5f),
    ARBORIST("Arborist", 240, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f);

    private final String frameName;
    public final int maxDamage;
    private final float territoryMod;
    private final float mutationMod;
    private final float lifespanMod;
    private final float productionMod;
    private final float floweringMod;
    private final float geneticDecayMod;

    private GTFrameType(String name, int maxDamage, float territory, float mutation, float lifespan, float production, float flowering, float geneticDecay) {
        this.frameName = name;
        this.maxDamage = maxDamage;
        this.territoryMod = territory;
        this.mutationMod = mutation;
        this.lifespanMod = lifespan;
        this.productionMod = production;
        this.floweringMod = flowering;
        this.geneticDecayMod = geneticDecay;
    }

    public String getName() {
        return this.frameName;
    }

    public float getTerritoryModifier(@Nullable IBeeGenome iBeeGenome, float v) {
        return this.territoryMod;
    }

    public float getMutationModifier(@Nullable IBeeGenome iBeeGenome, @Nullable IBeeGenome iBeeGenome1, float v) {
        return this.mutationMod;
    }

    public float getLifespanModifier(@Nullable IBeeGenome iBeeGenome, @Nullable IBeeGenome iBeeGenome1, float v) {
        return this.lifespanMod;
    }

    public float getProductionModifier(@Nullable IBeeGenome iBeeGenome, float v) {
        return this.productionMod;
    }

    public float getFloweringModifier(@Nullable IBeeGenome iBeeGenome, float v) {
        return this.floweringMod;
    }

    public float getGeneticDecay(@Nullable IBeeGenome iBeeGenome, float v) {
        return this.geneticDecayMod;
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isSelfLighted() {
        return false;
    }

    public boolean isSunlightSimulated() {
        return false;
    }

    public boolean isHellish() {
        return false;
    }
}

