/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import gregtech.api.util.Mods;
import gregtech.integration.IntegrationModule;
import gregtech.integration.forestry.ForestryConfig;
import gregtech.integration.forestry.ForestryModule;
import gregtech.integration.forestry.bees.GTCombType;
import gregtech.integration.forestry.bees.GTDropType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForestryUtil {
    @Nullable
    public static IAlleleBeeEffect getEffect(@NotNull Mods mod, @NotNull String name) {
        String string;
        switch (mod) {
            case ExtraBees: {
                string = "extrabees.effect." + name;
                break;
            }
            case MagicBees: {
                string = "magicbees.effect" + name;
                break;
            }
            case GregTech: {
                string = "gregtech.effect." + name;
                break;
            }
            default: {
                string = "forestry.effect" + name;
            }
        }
        String s = string;
        return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
    }

    @Nullable
    public static IAlleleFlowers getFlowers(@NotNull Mods mod, @NotNull String name) {
        String string;
        switch (mod) {
            case ExtraBees: {
                string = "extrabees.flower." + name;
                break;
            }
            case MagicBees: {
                string = "magicbees.flower" + name;
                break;
            }
            case GregTech: {
                string = "gregtech.flower." + name;
                break;
            }
            default: {
                string = "forestry.flowers" + name;
            }
        }
        String s = string;
        return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
    }

    @Nullable
    public static IAlleleBeeSpecies getSpecies(@NotNull Mods mod, @NotNull String name) {
        String string;
        switch (mod) {
            case ExtraBees: {
                string = "extrabees.species." + name;
                break;
            }
            case MagicBees: {
                string = "magicbees.species" + name;
                break;
            }
            case GregTech: {
                string = "gregtech.species." + name;
                break;
            }
            default: {
                string = "forestry.species" + name;
            }
        }
        String s = string;
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
    }

    @NotNull
    public static ItemStack getCombStack(@NotNull GTCombType type) {
        return ForestryUtil.getCombStack(type, 1);
    }

    @NotNull
    public static ItemStack getCombStack(@NotNull GTCombType type, int amount) {
        if (!ForestryConfig.enableGTBees) {
            IntegrationModule.logger.error("Tried to get GregTech Comb stack, but GregTech Bees config is not enabled!");
            return ItemStack.field_190927_a;
        }
        if (!Mods.ForestryApiculture.isModLoaded()) {
            IntegrationModule.logger.error("Tried to get GregTech Comb stack, but Apiculture module is not enabled!");
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ForestryModule.COMBS, amount, type.ordinal());
    }

    @NotNull
    public static ItemStack getDropStack(@NotNull GTDropType type) {
        return ForestryUtil.getDropStack(type, 1);
    }

    @NotNull
    public static ItemStack getDropStack(@NotNull GTDropType type, int amount) {
        if (!ForestryConfig.enableGTBees) {
            IntegrationModule.logger.error("Tried to get GregTech Drop stack, but GregTech Bees config is not enabled!");
            return ItemStack.field_190927_a;
        }
        if (!Mods.ForestryApiculture.isModLoaded()) {
            IntegrationModule.logger.error("Tried to get GregTech Drop stack, but Apiculture module is not enabled!");
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ForestryModule.DROPS, amount, type.ordinal());
    }
}

