/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.recipe;

import com.google.common.base.Preconditions;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.util.GTLog;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTNBTMultiItemMatcher
implements NBTMatcher {
    private final Map<ItemStack, List<NBTTagCompound>> map;

    public CTNBTMultiItemMatcher(@NotNull Map<ItemStack, List<NBTTagCompound>> map) {
        Preconditions.checkArgument((!map.isEmpty() ? 1 : 0) != 0, (Object)"Map must not be empty.");
        this.map = map;
    }

    @Override
    public boolean evaluate(@Nullable NBTTagCompound nbtTagCompound, @Nullable NBTCondition nbtCondition) {
        GTLog.logger.warn("CTNBTMultiItemMatcher#evaluate(NBTTagCompound, NBTCondition) was called. This should not happen.");
        return false;
    }

    @Override
    public boolean evaluate(@NotNull ItemStack stack, @Nullable NBTCondition nbtCondition) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        List<NBTTagCompound> list = this.map.get(stack);
        if (list == null) {
            return true;
        }
        Set toCheck = tagCompound.field_74784_a.entrySet();
        for (NBTTagCompound requirement : list) {
            if (requirement.func_82582_d()) {
                return true;
            }
            if (!toCheck.containsAll(requirement.field_74784_a.entrySet())) continue;
            return true;
        }
        return false;
    }
}

