/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.network.IClientExecutor;
import gregtech.api.network.IPacket;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketFluidVeinList
implements IPacket,
IClientExecutor {
    private Map<BedrockFluidVeinHandler.FluidVeinWorldEntry, Integer> map;

    public PacketFluidVeinList() {
    }

    public PacketFluidVeinList(HashMap<BedrockFluidVeinHandler.FluidVeinWorldEntry, Integer> map) {
        this.map = map;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.map.size());
        for (Map.Entry<BedrockFluidVeinHandler.FluidVeinWorldEntry, Integer> entry : this.map.entrySet()) {
            NBTTagCompound tag = entry.getKey().writeToNBT();
            tag.func_74768_a("weight", entry.getValue().intValue());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.map = new HashMap<BedrockFluidVeinHandler.FluidVeinWorldEntry, Integer>();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
            if (tag == null || tag.func_82582_d()) continue;
            BedrockFluidVeinHandler.FluidVeinWorldEntry entry = BedrockFluidVeinHandler.FluidVeinWorldEntry.readFromNBT(tag);
            this.map.put(entry, tag.func_74762_e("weight"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(NetHandlerPlayClient handler) {
        BedrockFluidVeinHandler.veinList.clear();
        for (Map.Entry<BedrockFluidVeinHandler.FluidVeinWorldEntry, Integer> entry : this.map.entrySet()) {
            BedrockFluidVeinHandler.veinList.put(entry.getKey().getDefinition(), entry.getValue());
        }
    }
}

