/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import codechicken.lib.vec.Vector3;
import gregtech.api.block.ICustomParticleBlock;
import gregtech.api.network.IClientExecutor;
import gregtech.api.network.IPacket;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBlockParticle
implements IPacket,
IClientExecutor {
    private BlockPos blockPos;
    private Vector3 entityPos;
    private int particlesAmount;

    public PacketBlockParticle() {
    }

    public PacketBlockParticle(BlockPos blockPos, Vector3 entityPos, int particlesAmount) {
        this.blockPos = blockPos;
        this.entityPos = entityPos;
        this.particlesAmount = particlesAmount;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.blockPos);
        buf.writeFloat((float)this.entityPos.x);
        buf.writeFloat((float)this.entityPos.y);
        buf.writeFloat((float)this.entityPos.z);
        buf.func_150787_b(this.particlesAmount);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.blockPos = buf.func_179259_c();
        this.entityPos = new Vector3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        this.particlesAmount = buf.func_150792_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(NetHandlerPlayClient handler) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        IBlockState blockState = world.func_180495_p(this.blockPos);
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        ((ICustomParticleBlock)blockState.func_177230_c()).handleCustomParticle((World)world, this.blockPos, particleManager, this.entityPos, this.particlesAmount);
    }
}

