/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.internal;

import gregtech.api.GregTechAPI;
import gregtech.api.modules.ModuleStage;
import gregtech.api.network.IClientExecutor;
import gregtech.api.network.INetworkHandler;
import gregtech.api.network.IPacket;
import gregtech.api.network.IServerExecutor;
import gregtech.api.util.GTLog;
import gregtech.core.CoreModule;
import gregtech.core.network.internal.PacketHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class NetworkHandler
implements INetworkHandler {
    private static final NetworkHandler INSTANCE = new NetworkHandler();
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("gregtech");
    private final PacketHandler packetHandler;

    private NetworkHandler() {
        this.channel.register((Object)this);
        this.packetHandler = PacketHandler.getInstance();
    }

    public static INetworkHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerPacket(Class<? extends IPacket> packetClass) {
        if (GregTechAPI.moduleManager.hasPassedStage(ModuleStage.PRE_INIT)) {
            CoreModule.logger.error("Could not register packet {}, as packet registration has ended!", (Object)packetClass.getName());
            return;
        }
        boolean hasServerExecutor = IServerExecutor.class.isAssignableFrom(packetClass);
        boolean hasClientExecutor = IClientExecutor.class.isAssignableFrom(packetClass);
        if (hasServerExecutor && hasClientExecutor) {
            CoreModule.logger.error("Could not register packet {}, as it is both a Server and Client executor! Only one allowed. Skipping...", (Object)packetClass.getName());
            return;
        }
        if (!hasServerExecutor && !hasClientExecutor) {
            CoreModule.logger.error("Could not register packet {}, as it does not have an executor! Must have either IServerExecutor OR IClientExecutor. Skipping...", (Object)packetClass.getName());
            return;
        }
        this.packetHandler.registerPacket(packetClass);
    }

    @Override
    public void sendToAll(IPacket packet) {
        this.channel.sendToAll(this.toFMLPacket(packet));
    }

    @Override
    public void sendTo(IPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(this.toFMLPacket(packet), player);
    }

    @Override
    public void sendToAllAround(IPacket packet, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllAround(this.toFMLPacket(packet), point);
    }

    @Override
    public void sendToAllTracking(IPacket packet, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllTracking(this.toFMLPacket(packet), point);
    }

    @Override
    public void sendToAllTracking(IPacket packet, Entity entity) {
        this.channel.sendToAllTracking(this.toFMLPacket(packet), entity);
    }

    @Override
    public void sendToDimension(IPacket packet, int dimensionId) {
        this.channel.sendToDimension(this.toFMLPacket(packet), dimensionId);
    }

    @Override
    public void sendToServer(IPacket packet) {
        this.channel.sendToServer(this.toFMLPacket(packet));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FMLNetworkEvent.ClientCustomPacketEvent event) throws Exception {
        IPacket packet = this.toGTPacket(event.getPacket());
        if (IClientExecutor.class.isAssignableFrom(packet.getClass())) {
            IClientExecutor executor = (IClientExecutor)((Object)packet);
            NetHandlerPlayClient handler = (NetHandlerPlayClient)event.getHandler();
            IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
            if (threadListener.func_152345_ab()) {
                executor.executeClient(handler);
            } else {
                threadListener.func_152344_a(() -> executor.executeClient(handler));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FMLNetworkEvent.ServerCustomPacketEvent event) throws Exception {
        IPacket packet = this.toGTPacket(event.getPacket());
        if (IServerExecutor.class.isAssignableFrom(packet.getClass())) {
            IServerExecutor executor = (IServerExecutor)((Object)packet);
            NetHandlerPlayServer handler = (NetHandlerPlayServer)event.getHandler();
            IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
            if (threadListener.func_152345_ab()) {
                executor.executeServer(handler);
            } else {
                threadListener.func_152344_a(() -> executor.executeServer(handler));
            }
        }
    }

    @NotNull
    private FMLProxyPacket toFMLPacket(@NotNull IPacket packet) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150787_b(this.packetHandler.getPacketId(packet.getClass()));
        packet.encode(buf);
        return new FMLProxyPacket(buf, "gregtech");
    }

    @NotNull
    private IPacket toGTPacket(@NotNull FMLProxyPacket proxyPacket) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        PacketBuffer payload = (PacketBuffer)proxyPacket.payload();
        Class<? extends IPacket> clazz = this.packetHandler.getPacketClass(payload.func_150792_a());
        IPacket packet = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        packet.decode(payload);
        if (payload.readableBytes() != 0) {
            GTLog.logger.error("NetworkHandler failed to finish reading packet with class {} and {} bytes remaining", (Object)clazz.getName(), (Object)payload.readableBytes());
        }
        return packet;
    }
}

