/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockRubberLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

public class WorldGenRubberTree
extends WorldGenerator {
    public static final WorldGenRubberTree TREE_GROW_INSTANCE = new WorldGenRubberTree(true);
    public static final WorldGenRubberTree WORLD_GEN_INSTANCE = new WorldGenRubberTree(false);

    protected WorldGenRubberTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(@NotNull World world, @NotNull Random random, @NotNull BlockPos pos) {
        return this.generateImpl(world, random, new BlockPos.MutableBlockPos(pos));
    }

    public boolean generateImpl(@NotNull World world, @NotNull Random random, BlockPos.MutableBlockPos pos) {
        pos.func_181079_c(pos.func_177958_n() + 8, world.func_72800_K() - 1, pos.func_177952_p() + 8);
        while (pos.func_177956_o() > 0 && world.func_175623_d((BlockPos)pos)) {
            pos.func_185336_p(pos.func_177956_o() - 1);
        }
        pos.func_185336_p(pos.func_177956_o() + 1);
        return this.grow(world, (BlockPos)pos, random);
    }

    public boolean grow(World world, BlockPos pos, Random random) {
        if (world == null) {
            return false;
        }
        SaplingGrowTreeEvent event = new SaplingGrowTreeEvent(world, random, pos);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        IBlockState woodBlock = MetaBlocks.RUBBER_LOG.func_176223_P().func_177226_a((IProperty)BlockRubberLog.NATURAL, (Comparable)Boolean.valueOf(true));
        IBlockState leaves = MetaBlocks.RUBBER_LEAVES.func_176223_P();
        int height = this.getGrowHeight(world, pos);
        if (height < 2) {
            return false;
        }
        height -= random.nextInt(height / 2 + 1);
        height = Math.max(5, height);
        BlockPos.MutableBlockPos tmpPos = new BlockPos.MutableBlockPos();
        for (int cHeight = 0; cHeight < height; ++cHeight) {
            BlockPos cPos = pos.func_177981_b(cHeight);
            this.func_175903_a(world, cPos, woodBlock);
            if ((height >= 7 || cHeight <= 1) && cHeight <= 2) continue;
            for (int cx = pos.func_177958_n() - 2; cx <= pos.func_177958_n() + 2; ++cx) {
                for (int cz = pos.func_177952_p() - 2; cz <= pos.func_177952_p() + 2; ++cz) {
                    int chance = Math.max(1, cHeight + 4 - height);
                    int dx = Math.abs(cx - pos.func_177958_n());
                    int dz = Math.abs(cz - pos.func_177952_p());
                    if (!(dx <= 1 && dz <= 1 || dx <= 1 && random.nextInt(chance) == 0) && (dz > 1 || random.nextInt(chance) != 0)) continue;
                    tmpPos.func_181079_c(cx, pos.func_177956_o() + cHeight, cz);
                    if (!world.func_175623_d((BlockPos)tmpPos)) continue;
                    this.func_175903_a(world, new BlockPos((Vec3i)tmpPos), leaves);
                }
            }
        }
        for (int i = 0; i <= height / 4 + random.nextInt(2); ++i) {
            tmpPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + height + i, pos.func_177952_p());
            if (!world.func_175623_d((BlockPos)tmpPos)) continue;
            this.func_175903_a(world, new BlockPos((Vec3i)tmpPos), leaves);
        }
        return true;
    }

    public int getGrowHeight(@NotNull World world, @NotNull BlockPos pos) {
        int height;
        BlockPos below = pos.func_177977_b();
        IBlockState baseState = world.func_180495_p(below);
        Block baseBlock = baseState.func_177230_c();
        if (baseBlock.isAir(baseState, (IBlockAccess)world, below) || !baseBlock.canSustainPlant(baseState, (IBlockAccess)world, below, EnumFacing.UP, (IPlantable)MetaBlocks.RUBBER_SAPLING) || !world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()).func_177230_c() != MetaBlocks.RUBBER_SAPLING) {
            return 0;
        }
        pos = pos.func_177984_a();
        for (height = 1; world.func_175623_d(pos) && height < 7; ++height) {
            pos = pos.func_177984_a();
        }
        return height;
    }
}

