/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import gregtech.api.util.GTLog;
import gregtech.common.worldgen.LootEntryMetaItem;
import gregtech.common.worldgen.LootEntryOreDict;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class LootTableHelper {
    private static final Map<String, LootTableEntrySerializer<?>> serializerMap = new HashMap();

    public static void registerLootEntry(String type, LootTableEntrySerializer<?> serializer) {
        serializerMap.put(type, serializer);
    }

    public static void initialize() {
        try {
            Field gsonField = Arrays.stream(LootTableManager.class.getDeclaredFields()).filter(it -> Gson.class.isAssignableFrom(it.getType())).findFirst().orElseThrow(() -> new RuntimeException("Failed to find Gson field!"));
            gsonField.setAccessible(true);
            Gson gsonInstance = (Gson)gsonField.get(null);
            LootTableHelper.replaceGsonTypeHierarchySerializer(gsonInstance, LootEntry.class, LootTableEntrySerializerDelegate::new);
        }
        catch (Throwable exception) {
            GTLog.logger.fatal("Failed to initialize loot table helper", exception);
            throw new RuntimeException(exception);
        }
        LootTableHelper.registerLootEntry("gregtech:meta_item", LootEntryMetaItem::deserialize);
        LootTableHelper.registerLootEntry("gregtech:ore_dict", LootEntryOreDict::deserialize);
    }

    private static void replaceGsonTypeHierarchySerializer(Gson gson, Class<?> type, BiFunction<JsonSerializer<?>, JsonDeserializer<?>, Object> replacer) {
        try {
            Field field = Gson.class.getDeclaredField("factories");
            field.setAccessible(true);
            Class<?> singleTypeFactoryClass = Class.forName("com.google.gson.internal.bind.TreeTypeAdapter$SingleTypeFactory");
            Field hierarchyTypeField = singleTypeFactoryClass.getDeclaredField("hierarchyType");
            hierarchyTypeField.setAccessible(true);
            List factories = (List)field.get(gson);
            TypeAdapterFactory factoryObject = factories.stream().filter(factory -> singleTypeFactoryClass.isAssignableFrom(factory.getClass())).filter(factory -> {
                try {
                    return hierarchyTypeField.get(factory) == type;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).findFirst().orElseThrow(() -> new IllegalArgumentException("Serializer not found for " + type));
            Field serializerField = singleTypeFactoryClass.getDeclaredField("serializer");
            Field deserializerField = singleTypeFactoryClass.getDeclaredField("deserializer");
            serializerField.setAccessible(true);
            deserializerField.setAccessible(true);
            JsonSerializer serializer = (JsonSerializer)serializerField.get(factoryObject);
            JsonDeserializer deserializer = (JsonDeserializer)deserializerField.get(factoryObject);
            Object replacedSerializer = replacer.apply(serializer, deserializer);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.set(serializerField, serializerField.getModifiers() & 0xFFFFFFEF);
            modifiersField.set(deserializerField, deserializerField.getModifiers() & 0xFFFFFFEF);
            serializerField.set(factoryObject, replacedSerializer);
            deserializerField.set(factoryObject, replacedSerializer);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void fillInventory(IItemHandlerModifiable inventory, Random rand, List<ItemStack> lootList) {
        List<Integer> randomSlots = LootTableHelper.getEmptySlotsRandomized((IItemHandler)inventory, rand);
        LootTableHelper.shuffleItems(lootList, randomSlots.size(), rand);
        for (ItemStack itemstack : lootList) {
            if (randomSlots.isEmpty()) {
                return;
            }
            if (itemstack.func_190926_b()) {
                inventory.setStackInSlot(randomSlots.remove(randomSlots.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.setStackInSlot(randomSlots.remove(randomSlots.size() - 1).intValue(), itemstack);
        }
    }

    private static void shuffleItems(List<ItemStack> stacks, int slotCount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 4) continue;
            list.add(itemstack);
            iterator.remove();
        }
        slotCount -= stacks.size();
        while (slotCount > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)(itemstack2.func_190916_E() / 3), (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    private static List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static interface LootTableEntrySerializer<T extends LootEntry> {
        public T deserialize(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, LootCondition[] var5);
    }

    private static class LootTableEntrySerializerDelegate
    implements JsonSerializer<LootEntry>,
    JsonDeserializer<LootEntry> {
        private final JsonSerializer<LootEntry> delegatedSerializer;
        private final JsonDeserializer<LootEntry> delegatedDeserializer;

        public LootTableEntrySerializerDelegate(JsonSerializer<?> delegatedSerializer, JsonDeserializer<?> delegatedDeserializer) {
            this.delegatedSerializer = delegatedSerializer;
            this.delegatedDeserializer = delegatedDeserializer;
        }

        public LootEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)json, (String)"loot item");
            String type = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
            if (serializerMap.containsKey(type)) {
                int weight = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"weight", (int)1);
                int quality = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"quality", (int)0);
                LootCondition[] lootConditions = jsonobject.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"conditions", (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{};
                LootTableEntrySerializer serializer = (LootTableEntrySerializer)serializerMap.get(type);
                return serializer.deserialize(jsonobject, context, weight, quality, lootConditions);
            }
            return (LootEntry)this.delegatedDeserializer.deserialize(json, typeOfT, context);
        }

        public JsonElement serialize(LootEntry src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof SerializableLootEntry) {
                SerializableLootEntry entry = (SerializableLootEntry)src;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("weight", (Number)entry.getWeight());
                jsonObject.addProperty("quality", (Number)entry.getQuality());
                LootCondition[] conditions = entry.getConditions();
                if (conditions.length > 0) {
                    jsonObject.add("conditions", context.serialize((Object)entry.getConditions()));
                }
                jsonObject.addProperty("type", entry.getType());
                entry.serializeEntry(jsonObject, context);
                return jsonObject;
            }
            return this.delegatedSerializer.serialize((Object)src, typeOfSrc, context);
        }
    }

    public static interface SerializableLootEntry {
        public String getType();

        public int getWeight();

        public int getQuality();

        public LootCondition[] getConditions();

        public void serializeEntry(JsonObject var1, JsonSerializationContext var2);
    }
}

