/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.multiblockhelper;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternError;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.MachineSceneWidget;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.BlockInfo;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.common.inventory.handlers.CycleItemStackHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class MachineBuilderWidget
extends WidgetGroup {
    private BlockPos pos;
    private EnumFacing facing;
    private SlotWidget[] slotWidgets;
    TerminalOSWidget os;
    @SideOnly(value=Side.CLIENT)
    private MachineSceneWidget sceneWidget;
    @SideOnly(value=Side.CLIENT)
    private Set<BlockPos> highLightBlocks;
    private final MultiblockControllerBase controllerBase;
    private int selected = -1;
    @SideOnly(value=Side.CLIENT)
    private DraggableScrollableWidgetGroup candidates;
    @SideOnly(value=Side.CLIENT)
    private List<CycleItemStackHandler> handlers;

    public MachineBuilderWidget(int x, int y, int width, int height, MultiblockControllerBase controllerBase, TerminalOSWidget os) {
        super(x, y, width, height);
        this.os = os;
        this.controllerBase = controllerBase;
        this.addWidget(new ImageWidget(0, 0, width, height, GuiTextures.BACKGROUND));
        this.addWidget(new RectButtonWidget(12, 125, width - 24, 20, 1).setClickListener(this::autoBuildButton).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.multiblock_ar.builder.auto", -1)));
        this.addWidget(new RectButtonWidget(12, 150, width - 24, 20, 1).setClickListener(this::placeButton).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.multiblock_ar.builder.place", -1)));
        this.addWidget(new RectButtonWidget(12, 175, width - 24, 20, 1).setClickListener(this::debugButton).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.multiblock_ar.builder.debug", -1)));
        if (os.isRemote()) {
            this.candidates = new DraggableScrollableWidgetGroup(-20, 0, 20, 180);
            this.addWidget(this.candidates);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -2) {
            this.selected = buffer.func_150792_a();
        } else if (id == -3) {
            this.pos = buffer.func_179259_c();
            this.facing = EnumFacing.field_82609_l[buffer.readByte()];
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    public void addPlayerInventory() {
        InventoryPlayer inventoryPlayer = this.gui.entityPlayer.field_71071_by;
        this.slotWidgets = new SlotWidget[36];
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 6; ++col) {
                final int index = col + row * 6;
                boolean isActive = inventoryPlayer.func_70301_a(index).func_77973_b() instanceof ItemBlock;
                this.slotWidgets[index] = new SlotWidget((IInventory)inventoryPlayer, index, 12 + col * 18, 12 + row * 18, false, false){

                    @Override
                    public boolean mouseClicked(int mouseX, int mouseY, int button) {
                        if (this.isMouseOverElement(mouseX, mouseY) && this.isActive() && MachineBuilderWidget.this.selected != index) {
                            MachineBuilderWidget.this.selected = index;
                            MachineBuilderWidget.this.writeClientAction(-2, buf -> buf.func_150787_b(index));
                        }
                        return super.mouseClicked(mouseX, mouseY, button);
                    }

                    @Override
                    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
                        super.drawInBackground(mouseX, mouseY, partialTicks, context);
                        if (MachineBuilderWidget.this.selected == index) {
                            1.drawSolidRect(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, 0x4F00FF00);
                        }
                    }
                }.setBackgroundTexture(GuiTextures.SLOT);
                this.slotWidgets[index].setActive(isActive);
                this.addWidget(this.slotWidgets[index]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setSceneWidget(MachineSceneWidget sceneWidget) {
        this.sceneWidget = sceneWidget;
        this.highLightBlocks = new HashSet<BlockPos>();
        MachineSceneWidget.getWorldSceneRenderer().addRenderedBlocks(this.highLightBlocks, this::highLightRender);
        sceneWidget.setOnSelected(this::setFocus);
        sceneWidget.getAround().clear();
        Set<BlockPos> cores = sceneWidget.getCores();
        int rX = 5;
        int rY = 5;
        int rZ = 5;
        for (MultiblockShapeInfo shapeInfo : this.controllerBase.getMatchingShapes()) {
            BlockInfo[][][] blockInfos = shapeInfo.getBlocks();
            rX = Math.max(blockInfos.length, rX);
            rY = Math.max(blockInfos[0].length, rY);
            rZ = Math.max(blockInfos[0][0].length, rZ);
        }
        for (int x = -rX; x <= rX; ++x) {
            for (int y = -rY; y <= rY; ++y) {
                for (int z = -rZ; z <= rZ; ++z) {
                    cores.add(this.controllerBase.getPos().func_177982_a(x, y, z));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setFocus(BlockPos pos, EnumFacing facing) {
        this.pos = new BlockPos((Vec3i)pos);
        this.facing = facing;
        this.writeClientAction(-3, buf -> {
            buf.func_179255_a(pos);
            buf.writeByte(facing.func_176745_a());
        });
    }

    private void placeButton(Widget.ClickData clickData) {
        ItemStack itemStack;
        BlockPos offset;
        World world;
        if (this.pos != null && this.facing != null && this.selected != -1 && (world = this.controllerBase.getWorld()).func_180495_p(offset = this.pos.func_177972_a(this.facing)).func_177230_c() == Blocks.field_150350_a && !(itemStack = this.slotWidgets[this.selected].getHandle().func_75211_c()).func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
            float hitX = (float)this.pos.func_177958_n() + 0.5f;
            float hitY = (float)this.pos.func_177956_o() + 0.5f;
            float hitZ = (float)this.pos.func_177952_p() + 0.5f;
            Block block = itemBlock.func_179223_d();
            IBlockState state = block.func_176203_a(itemBlock.func_77647_b(itemStack.func_77960_j()));
            if (block instanceof BlockBush && !((BlockBush)block).func_180671_f(world, offset, state)) {
                if (clickData.isClient) {
                    TerminalDialogWidget.showInfoDialog(this.os, "terminal.component.error", "This Block cannot be placed here").setClientSide().open();
                }
                return;
            }
            itemBlock.placeBlockAt(itemStack, this.gui.entityPlayer, world, offset, this.facing, hitX, hitY, hitZ, state);
            itemStack.func_190918_g(1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void highLightRender(boolean isTESR, int pass, BlockRenderLayer layer) {
        if (isTESR && pass == 0) {
            return;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)5.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (BlockPos pos : this.highLightBlocks) {
            RenderBufferHelper.renderCubeFrame(buffer, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void debugButton(Widget.ClickData clickData) {
        if (clickData.isClient && this.controllerBase != null) {
            this.highLightBlocks.clear();
            if (this.controllerBase.structurePattern.checkPatternFastAt(this.controllerBase.getWorld(), this.controllerBase.getPos(), this.controllerBase.getFrontFacing().func_176734_d(), this.controllerBase.getUpwardsFacing(), this.controllerBase.allowsFlip()) == null) {
                PatternError error = this.controllerBase.structurePattern.getError();
                this.highLightBlocks.add(new BlockPos((Vec3i)error.getPos()));
                List<List<ItemStack>> candidatesItemStack = error.getCandidates();
                this.candidates.clearAllWidgets();
                int y = 1;
                this.handlers = new ArrayList<CycleItemStackHandler>();
                for (List<ItemStack> candidate : candidatesItemStack) {
                    CycleItemStackHandler handler = new CycleItemStackHandler((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])candidate.toArray(new ItemStack[0])));
                    this.handlers.add(handler);
                    this.candidates.addWidget(new SlotWidget((IItemHandler)handler, 0, 1, y, false, false).setBackgroundTexture(TerminalTheme.COLOR_B_2));
                    y += 20;
                }
                TerminalDialogWidget.showInfoDialog(this.os, "terminal.component.error", error.getErrorInfo()).setClientSide().open();
            }
        }
    }

    private void autoBuildButton(Widget.ClickData clickData) {
        if (this.controllerBase != null && !clickData.isClient && this.controllerBase.structurePattern != null) {
            this.controllerBase.structurePattern.autoBuild(this.gui.entityPlayer, this.controllerBase);
        }
    }
}

