/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuideWidgetGroup;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ItemStackConfigurator;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SlotListWidget
extends GuideWidgetGroup {
    public static final String NAME = "slots";
    public List<ItemStackInfo> item_list;

    @Override
    public Widget initFixed() {
        int xPos;
        this.clearAllWidgets();
        ItemStackHandler itemStackHandler = new ItemStackHandler(this.item_list.size());
        ColorRectTexture background = new ColorRectTexture(0x4F000000);
        int size = this.item_list.size();
        int maxXSize = this.getSize().width / 18;
        if (maxXSize < 1) {
            maxXSize = 1;
            xPos = 0;
        } else {
            xPos = (this.getSize().width - Math.min(size, maxXSize) * 18) / 2;
        }
        int maxYSize = size / maxXSize + (size % maxXSize == 0 ? 0 : 1);
        for (int y = 0; y <= size / maxXSize; ++y) {
            for (int x = 0; x < maxXSize; ++x) {
                int i = x + y * maxXSize;
                if (i >= size) continue;
                itemStackHandler.setStackInSlot(i, this.item_list.get(i).getInstance());
                SlotWidget widget = new SlotWidget((IItemHandler)itemStackHandler, i, xPos + x * 18, y * 18, false, false);
                widget.setBackgroundTexture(background);
                this.addWidget(widget);
            }
        }
        this.setSize(new Size(this.getSize().width / 18 > 0 ? this.getSize().width : 18, maxYSize * 18));
        return this;
    }

    @Override
    public String getRegistryName() {
        return NAME;
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = super.getTemplate(isFixed);
        template.add("item_list", new Gson().toJsonTree(Collections.singletonList(new ItemStackInfo("minecraft:ender_pearl", 0, 1))));
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        super.loadConfigurator(group, config, isFixed, needUpdate);
        group.addWidget(new ItemStackConfigurator(group, config, "item_list").setOnUpdated(needUpdate));
    }

    public static class ItemStackInfo {
        public String id;
        public int damage;
        public int count = 1;
        private transient ItemStack itemStack;

        public ItemStackInfo() {
        }

        public void update(ItemStack itemStack) {
            ResourceLocation resourceLocation = itemStack.func_77973_b().getRegistryName();
            this.id = resourceLocation == null ? "minecraft:air" : resourceLocation.toString();
            this.damage = itemStack.func_77952_i();
            this.count = itemStack.func_190916_E();
        }

        public ItemStackInfo(String id, int damage, int count) {
            this.id = id;
            this.damage = damage;
            this.count = count;
        }

        public ItemStack getInstance() {
            if (this.itemStack == null && this.id != null) {
                Item item = Item.func_111206_d((String)this.id);
                if (item == null) {
                    this.itemStack = ItemStack.field_190927_a;
                    return this.itemStack;
                }
                this.itemStack = item.func_190903_i();
                this.itemStack.func_190920_e(this.count);
                this.itemStack.func_77964_b(this.damage);
            }
            return this.itemStack == null ? ItemStack.field_190927_a : this.itemStack;
        }
    }
}

