/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.util.GTLog;
import gregtech.api.util.VirtualTankRegistry;
import gregtech.common.terminal.component.SearchComponent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class VirtualTankApp
extends AbstractApplication
implements SearchComponent.IWidgetSearch<Pair<UUID, String>> {
    private WidgetGroup widgetGroup;
    private Map<Pair<UUID, String>, FluidStack> cacheServer;
    @SideOnly(value=Side.CLIENT)
    private Map<Pair<UUID, String>, IFluidTank> cacheClient;

    public VirtualTankApp() {
        super("vtank_viewer");
    }

    @Override
    public AbstractApplication initApp() {
        this.addWidget(new ImageWidget(5, 5, 323, 222, TerminalTheme.COLOR_B_2));
        this.addWidget(new LabelWidget(10, 10, "terminal.vtank_viewer.title", -1));
        this.addWidget(new RectButtonWidget(216, 7, 110, 18).setClickListener(cd -> {
            if (cd.isClient) {
                this.reloadWidgets(this.cacheClient);
            }
        }).setIcon(new TextTexture("terminal.vtank_viewer.refresh", -1)).setFill(TerminalTheme.COLOR_B_2.getColor()));
        this.widgetGroup = new DraggableScrollableWidgetGroup(10, 30, 313, 195).setDraggable(true).setYScrollBarWidth(3).setYBarStyle(null, TerminalTheme.COLOR_F_1);
        if (this.isClient) {
            this.cacheClient = new HashMap<Pair<UUID, String>, IFluidTank>();
        } else {
            this.cacheServer = new HashMap<Pair<UUID, String>, FluidStack>();
        }
        this.addWidget(this.widgetGroup);
        if (!this.isRemote()) {
            this.refresh();
        }
        return this;
    }

    private List<Pair<UUID, String>> findVirtualTanks() {
        LinkedList<Pair<UUID, String>> result = new LinkedList<Pair<UUID, String>>();
        Map<UUID, Map<String, IFluidTank>> tankMap = VirtualTankRegistry.getTankMap();
        for (UUID uuid : tankMap.keySet().stream().sorted(Comparator.nullsLast(UUID::compareTo)).collect(Collectors.toList())) {
            if (uuid != null && !uuid.equals(this.gui.entityPlayer.func_110124_au())) continue;
            for (String key : tankMap.get(uuid).keySet().stream().sorted().collect(Collectors.toList())) {
                result.add((Pair<UUID, String>)new ImmutablePair((Object)uuid, (Object)key));
            }
        }
        return result;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.gui.entityPlayer.field_70173_aa % 20 == 0) {
            this.refresh();
        }
    }

    private void refresh() {
        Map<UUID, Map<String, IFluidTank>> tankMap = VirtualTankRegistry.getTankMap();
        HashMap<Pair<UUID, String>, FluidStack> access = new HashMap<Pair<UUID, String>, FluidStack>();
        for (Pair<UUID, String> virtualTankEntry : this.findVirtualTanks()) {
            UUID uuid = (UUID)virtualTankEntry.getKey();
            String key = (String)virtualTankEntry.getValue();
            FluidStack fluidStack = tankMap.get(uuid).get(key).getFluid();
            access.put((Pair<UUID, String>)new ImmutablePair((Object)uuid, (Object)key), fluidStack == null ? null : fluidStack.copy());
        }
        if (access.keySet().containsAll(this.cacheServer.keySet()) && access.size() == this.cacheServer.size()) {
            LinkedList<Pair> toUpdated = new LinkedList<Pair>();
            for (Map.Entry entry : access.entrySet()) {
                Pair pair = (Pair)entry.getKey();
                FluidStack fluidStackNew = (FluidStack)entry.getValue();
                FluidStack fluidStackOld = this.cacheServer.get(pair);
                if (fluidStackNew == null && fluidStackOld == null) continue;
                if (fluidStackNew != null && fluidStackOld == null) {
                    toUpdated.add(pair);
                    continue;
                }
                if (fluidStackNew == null) {
                    toUpdated.add(pair);
                    continue;
                }
                if (fluidStackOld.amount == fluidStackNew.amount && fluidStackNew.isFluidEqual(fluidStackOld)) continue;
                toUpdated.add(pair);
            }
            if (!toUpdated.isEmpty()) {
                this.writeUpdateInfo(-2, buffer -> {
                    buffer.func_150787_b(toUpdated.size());
                    for (Pair update : toUpdated) {
                        buffer.writeBoolean(update.getKey() != null);
                        if (update.getKey() != null) {
                            buffer.func_180714_a(((UUID)update.getKey()).toString());
                        }
                        buffer.func_180714_a((String)update.getValue());
                        FluidStack value = (FluidStack)access.get(update);
                        buffer.writeBoolean(value != null);
                        if (value == null) continue;
                        buffer.func_150786_a(value.writeToNBT(new NBTTagCompound()));
                    }
                });
            }
            return;
        }
        this.cacheServer = access;
        this.writeUpdateInfo(-1, buffer -> {
            buffer.func_150787_b(this.cacheServer.size());
            this.cacheServer.forEach((key, value) -> {
                buffer.writeBoolean(key.getKey() != null);
                if (key.getKey() != null) {
                    buffer.func_180714_a(((UUID)key.getKey()).toString());
                }
                buffer.func_180714_a((String)key.getValue());
                buffer.writeBoolean(value != null);
                if (value != null) {
                    buffer.func_150786_a(value.writeToNBT(new NBTTagCompound()));
                }
            });
        });
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            int size = buffer.func_150792_a();
            this.cacheClient.clear();
            try {
                for (int i = 0; i < size; ++i) {
                    UUID uuid = null;
                    if (buffer.readBoolean()) {
                        uuid = UUID.fromString(buffer.func_150789_c(Short.MAX_VALUE));
                    }
                    String key = buffer.func_150789_c(Short.MAX_VALUE);
                    FluidTank fluidTank = new FluidTank(64000);
                    if (buffer.readBoolean()) {
                        fluidTank.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b()), true);
                    }
                    this.cacheClient.put((Pair<UUID, String>)new ImmutablePair((Object)uuid, (Object)key), (IFluidTank)fluidTank);
                }
            }
            catch (Exception e) {
                GTLog.logger.error("error sync fluid", (Throwable)e);
            }
            this.reloadWidgets(this.cacheClient);
        } else if (id == -2) {
            int size = buffer.func_150792_a();
            try {
                for (int i = 0; i < size; ++i) {
                    IFluidTank fluidTank;
                    UUID uuid = null;
                    if (buffer.readBoolean()) {
                        uuid = UUID.fromString(buffer.func_150789_c(Short.MAX_VALUE));
                    }
                    String key = buffer.func_150789_c(Short.MAX_VALUE);
                    FluidStack fluidStack = null;
                    if (buffer.readBoolean()) {
                        fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
                    }
                    if ((fluidTank = this.cacheClient.get(new ImmutablePair((Object)uuid, (Object)key))) == null) continue;
                    fluidTank.drain(64000, true);
                    if (fluidStack == null) continue;
                    fluidTank.fill(fluidStack, true);
                }
            }
            catch (Exception e) {
                GTLog.logger.error("error sync fluid", (Throwable)e);
            }
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    private void reloadWidgets(Map<Pair<UUID, String>, IFluidTank> map) {
        this.widgetGroup.clearAllWidgets();
        AtomicInteger cy = new AtomicInteger();
        map.forEach((key, fluidTank) -> {
            if (key.getKey() != null) {
                this.widgetGroup.addWidget(new ImageWidget(0, cy.get() + 4, 8, 8, GuiTextures.LOCK_WHITE));
            }
            this.widgetGroup.addWidget(new TankWidget((IFluidTank)fluidTank, 8, cy.get(), 18, 18).setAlwaysShowFull(true).setBackgroundTexture(GuiTextures.FLUID_SLOT).setClient());
            this.widgetGroup.addWidget(new LabelWidget(36, cy.get() + 5, (String)key.getValue(), -1).setWidth(180));
            cy.addAndGet(23);
        });
    }

    @Override
    public List<IMenuComponent> getMenuComponents() {
        return Collections.singletonList(new SearchComponent<Pair<UUID, String>>(this));
    }

    @Override
    public String resultDisplay(Pair<UUID, String> result) {
        FluidStack fluidStack = VirtualTankRegistry.getTankMap().get(result.getKey()).get(result.getValue()).getFluid();
        return String.format("Lock: %b, ID: %s, Fluid: %s", result.getKey() != null, result.getValue(), fluidStack == null ? "-" : fluidStack.getLocalizedName());
    }

    @Override
    public void selectResult(Pair<UUID, String> result) {
        HashMap<Pair<UUID, String>, IFluidTank> map = new HashMap<Pair<UUID, String>, IFluidTank>();
        map.put(result, this.cacheClient.get(result));
        this.reloadWidgets(map);
    }

    @Override
    public void search(String word, Consumer<Pair<UUID, String>> find) {
        if (!this.isClient) {
            return;
        }
        for (Map.Entry<Pair<UUID, String>, IFluidTank> access : this.cacheClient.entrySet()) {
            Pair<UUID, String> accessingCover = access.getKey();
            if (accessingCover.getValue() != null && ((String)accessingCover.getValue()).toLowerCase().contains(word.toLowerCase())) {
                find.accept(accessingCover);
                continue;
            }
            FluidStack fluidStack = access.getValue().getFluid();
            if (fluidStack == null || !fluidStack.getLocalizedName().toLowerCase().contains(word.toLowerCase())) continue;
            find.accept(accessingCover);
        }
    }
}

