/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.laser.net;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.common.pipelike.laser.LaserPipeProperties;
import gregtech.common.pipelike.laser.net.LaserNetWalker;
import gregtech.common.pipelike.laser.net.LaserRoutePath;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class LaserPipeNet
extends PipeNet<LaserPipeProperties> {
    private final Map<BlockPos, LaserRoutePath> netData = new Object2ObjectOpenHashMap();

    public LaserPipeNet(WorldPipeNet<LaserPipeProperties, ? extends PipeNet<LaserPipeProperties>> world) {
        super(world);
    }

    @Nullable
    public LaserRoutePath getNetData(BlockPos pipePos, EnumFacing facing) {
        if (this.netData.containsKey(pipePos)) {
            return this.netData.get(pipePos);
        }
        LaserRoutePath data = LaserNetWalker.createNetData(this.getWorldData(), pipePos, facing);
        if (data == LaserNetWalker.FAILED_MARKER) {
            return null;
        }
        this.netData.put(pipePos, data);
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.netData.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.netData.clear();
    }

    @Override
    public void onChunkUnload() {
        this.netData.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<LaserPipeProperties>> transferredNodes, PipeNet<LaserPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.netData.clear();
        ((LaserPipeNet)parentNet).netData.clear();
    }

    @Override
    protected void writeNodeData(LaserPipeProperties nodeData, NBTTagCompound tagCompound) {
    }

    @Override
    protected LaserPipeProperties readNodeData(NBTTagCompound tagCompound) {
        return LaserPipeProperties.INSTANCE;
    }
}

