/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.net;

import gregtech.api.cover.Cover;
import gregtech.api.pipenet.PipeNetWalker;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.ItemFilterMode;
import gregtech.common.pipelike.itempipe.net.ItemRoutePath;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemNetWalker
extends PipeNetWalker<TileEntityItemPipe> {
    private ItemPipeProperties minProperties;
    private final List<ItemRoutePath> inventories;
    private final List<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
    private final EnumMap<EnumFacing, List<Predicate<ItemStack>>> nextFilters = new EnumMap(EnumFacing.class);
    private BlockPos sourcePipe;
    private EnumFacing facingToHandler;

    public static List<ItemRoutePath> createNetData(World world, BlockPos sourcePipe, EnumFacing faceToSourceHandler) {
        if (!(world.func_175625_s(sourcePipe) instanceof TileEntityItemPipe)) {
            return null;
        }
        ItemNetWalker walker = new ItemNetWalker(world, sourcePipe, 1, new ArrayList<ItemRoutePath>(), null);
        walker.sourcePipe = sourcePipe;
        walker.facingToHandler = faceToSourceHandler;
        walker.traversePipeNet();
        return walker.isFailed() ? null : walker.inventories;
    }

    protected ItemNetWalker(World world, BlockPos sourcePipe, int distance, List<ItemRoutePath> inventories, ItemPipeProperties properties) {
        super(world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    @Override
    protected PipeNetWalker<TileEntityItemPipe> createSubWalker(World world, EnumFacing facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        ItemNetWalker walker = new ItemNetWalker(world, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.filters.addAll(this.filters);
        List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(facingToNextPos);
        if (moreFilters != null && !moreFilters.isEmpty()) {
            walker.filters.addAll(moreFilters);
        }
        return walker;
    }

    @Override
    protected void checkPipe(TileEntityItemPipe pipeTile, BlockPos pos) {
        for (List<Predicate<ItemStack>> filters : this.nextFilters.values()) {
            if (filters.isEmpty()) continue;
            this.filters.addAll(filters);
        }
        this.nextFilters.clear();
        ItemPipeProperties pipeProperties = (ItemPipeProperties)pipeTile.getNodeData();
        this.minProperties = this.minProperties == null ? pipeProperties : new ItemPipeProperties(this.minProperties.getPriority() + pipeProperties.getPriority(), Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
    }

    @Override
    protected void checkNeighbour(TileEntityItemPipe pipeTile, BlockPos pipePos, EnumFacing faceToNeighbour, @Nullable TileEntity neighbourTile) {
        if (neighbourTile == null || GTUtility.arePosEqual(pipePos, this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        IItemHandler handler = (IItemHandler)neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, faceToNeighbour.func_176734_d());
        if (handler != null) {
            ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>(this.filters);
            List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(faceToNeighbour);
            if (moreFilters != null && !moreFilters.isEmpty()) {
                filters.addAll(moreFilters);
            }
            this.inventories.add(new ItemRoutePath(pipeTile, faceToNeighbour, this.getWalkedBlocks(), this.minProperties, filters));
        }
    }

    @Override
    protected Class<TileEntityItemPipe> getBasePipeClass() {
        return TileEntityItemPipe.class;
    }

    @Override
    protected boolean isValidPipe(TileEntityItemPipe currentPipe, TileEntityItemPipe neighbourPipe, BlockPos pipePos, EnumFacing faceToNeighbour) {
        Cover thisCover = currentPipe.getCoverableImplementation().getCoverAtSide(faceToNeighbour);
        Cover neighbourCover = neighbourPipe.getCoverableImplementation().getCoverAtSide(faceToNeighbour.func_176734_d());
        ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
        if (thisCover instanceof CoverShutter) {
            filters.add(stack -> !((CoverShutter)thisCover).isWorkingEnabled());
        } else if (thisCover instanceof CoverItemFilter && ((CoverItemFilter)thisCover).getFilterMode() != ItemFilterMode.FILTER_INSERT) {
            filters.add(((CoverItemFilter)thisCover)::testItemStack);
        }
        if (neighbourCover instanceof CoverShutter) {
            filters.add(stack -> !((CoverShutter)neighbourCover).isWorkingEnabled());
        } else if (neighbourCover instanceof CoverItemFilter && ((CoverItemFilter)neighbourCover).getFilterMode() != ItemFilterMode.FILTER_EXTRACT) {
            filters.add(((CoverItemFilter)neighbourCover)::testItemStack);
        }
        if (!filters.isEmpty()) {
            this.nextFilters.put(faceToNeighbour, filters);
        }
        return true;
    }
}

