/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.crafting.ShapedOreEnergyTransferRecipe;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSources;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;

public class CachedRecipeData {
    private final ItemSources itemSources;
    private IRecipe recipe;
    private final Object2IntMap<ItemStack> requiredItems = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
    private final Int2ObjectMap<Object2BooleanMap<ItemStack>> replaceAttemptMap = new Int2ObjectArrayMap();
    private final InventoryCrafting inventory;

    public CachedRecipeData(ItemSources sourceList, IRecipe recipe, InventoryCrafting inventoryCrafting) {
        this.itemSources = sourceList;
        this.recipe = recipe;
        this.inventory = inventoryCrafting;
    }

    public short attemptMatchRecipe() {
        short itemsFound = 0;
        this.requiredItems.clear();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (!this.getIngredientEquivalent(i)) continue;
            itemsFound = (short)(itemsFound + (1 << i));
        }
        if (itemsFound != CraftingRecipeLogic.ALL_INGREDIENTS_PRESENT) {
            this.requiredItems.clear();
        }
        return itemsFound;
    }

    protected boolean consumeRecipeItems() {
        boolean gathered = true;
        Object2IntOpenCustomHashMap gatheredItems = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        for (Object2IntMap.Entry entry : this.requiredItems.object2IntEntrySet()) {
            int requestedAmount;
            ItemStack stack = (ItemStack)entry.getKey();
            int extractedAmount = this.itemSources.extractItem(stack, requestedAmount = entry.getIntValue(), false);
            if (extractedAmount != requestedAmount) {
                gatheredItems.put((Object)stack.func_77946_l(), extractedAmount);
                gathered = false;
                break;
            }
            gatheredItems.put((Object)stack.func_77946_l(), requestedAmount);
        }
        if (!gathered) {
            for (Object2IntMap.Entry entry : gatheredItems.object2IntEntrySet()) {
                this.itemSources.insertItem((ItemStack)entry.getKey(), entry.getIntValue(), false, IItemList.InsertMode.HIGHEST_PRIORITY);
            }
        }
        return gathered;
    }

    public boolean getIngredientEquivalent(int slot) {
        ItemStack currentStack = this.inventory.func_70301_a(slot);
        if (currentStack.func_190926_b()) {
            return true;
        }
        if (this.simulateExtractItem(currentStack)) {
            return true;
        }
        ItemStack previousStack = this.recipe.func_77572_b(this.inventory);
        Object2BooleanMap map = (Object2BooleanMap)this.replaceAttemptMap.computeIfAbsent((Object)slot, m -> new Object2BooleanOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount()));
        for (ItemStack itemStack : this.itemSources.getStoredItems()) {
            boolean matchedPreviously = false;
            if (map.containsKey((Object)itemStack)) {
                if (!((Boolean)map.get((Object)itemStack)).booleanValue()) continue;
                matchedPreviously = true;
            }
            if (!matchedPreviously) {
                boolean matched = false;
                for (Ingredient in : this.recipe.func_192400_c()) {
                    if (!in.apply(itemStack)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    map.put((Object)itemStack.func_77946_l(), false);
                    continue;
                }
            }
            this.inventory.func_70299_a(slot, itemStack);
            if (this.recipe.func_77569_a(this.inventory, this.itemSources.getWorld()) && (ItemStack.func_77989_b((ItemStack)this.recipe.func_77572_b(this.inventory), (ItemStack)previousStack) || this.recipe instanceof ShapedOreEnergyTransferRecipe)) {
                map.put((Object)itemStack, true);
                if (this.simulateExtractItem(itemStack)) {
                    return true;
                }
            }
            map.put((Object)itemStack, false);
            this.inventory.func_70299_a(slot, currentStack);
        }
        return false;
    }

    private boolean simulateExtractItem(ItemStack itemStack) {
        int amountToExtract = (Integer)this.requiredItems.getOrDefault((Object)itemStack, (Object)0) + 1;
        int extracted = this.itemSources.extractItem(itemStack, amountToExtract, true);
        if (extracted == amountToExtract) {
            this.requiredItems.put((Object)itemStack.func_77946_l(), amountToExtract);
            return true;
        }
        return false;
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        if (this.recipe == null) {
            return false;
        }
        return this.recipe.func_77569_a(inventoryCrafting, world);
    }

    public void setRecipe(IRecipe newRecipe) {
        this.recipe = newRecipe;
        this.replaceAttemptMap.clear();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }
}

