/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SteamSolarBoiler
extends SteamBoiler {
    public SteamSolarBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.SOLAR_BOILER_OVERLAY);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamSolarBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected int getBaseSteamOutput() {
        return this.isHighPressure ? 360 : 120;
    }

    @Override
    protected void tryConsumeNewFuel() {
        if (GTUtility.canSeeSunClearly(this.getWorld(), this.getPos())) {
            this.setFuelMaxBurnTime(20);
        }
    }

    @Override
    protected int getCooldownInterval() {
        return this.isHighPressure ? 50 : 45;
    }

    @Override
    protected int getCoolDownRate() {
        return 3;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).progressBar(() -> GTUtility.canSeeSunClearly(this.getWorld(), this.getPos()) ? 1.0 : 0.0, 114, 44, 20, 20, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(this.isHighPressure), ProgressWidget.MoveType.HORIZONTAL).build(this.getHolder(), entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
    }
}

