/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SteamExtractor
extends SteamMetaTileEntity {
    public SteamExtractor(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, RecipeMaps.EXTRACTOR_RECIPES, Textures.EXTRACTOR_OVERLAY, isHighPressure);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamExtractor(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, 1, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, 1, this, true);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).slot(this.importItems, 0, 53, 25, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.EXTRACTOR_OVERLAY_STEAM.get(this.isHighPressure)).progressBar(this.workableHandler::getProgressPercent, 79, 25, 20, 18, GuiTextures.PROGRESS_BAR_EXTRACT_STEAM.get(this.isHighPressure), ProgressWidget.MoveType.HORIZONTAL, this.workableHandler.getRecipeMap()).slot(this.exportItems, 0, 107, 25, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure)).build(this.getHolder(), player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)this, EnumParticleTypes.CLOUD);
        }
    }
}

