/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.hpca;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IHPCAComponentHatch;
import gregtech.api.capability.IHPCAComputationProvider;
import gregtech.api.capability.IHPCACoolantProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityHPCA;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntityHPCAComponent
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IHPCAComponentHatch>,
IHPCAComponentHatch {
    private boolean damaged;

    public MetaTileEntityHPCAComponent(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 7);
    }

    public abstract boolean isAdvanced();

    public boolean doesAllowBridging() {
        return false;
    }

    public abstract SimpleOverlayRenderer getFrontOverlay();

    public SimpleOverlayRenderer getFrontActiveOverlay() {
        return this.getFrontOverlay();
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public MultiblockAbility<IHPCAComponentHatch> getAbility() {
        return MultiblockAbility.HPCA_COMPONENT;
    }

    @Override
    public void registerAbilities(List<IHPCAComponentHatch> abilityList) {
        abilityList.add(this);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        MultiblockControllerBase controller;
        SimpleOverlayRenderer renderer;
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay() && (renderer = (controller = this.getController()) != null && controller.isActive() ? this.getFrontActiveOverlay() : this.getFrontOverlay()) != null) {
            EnumFacing facing = this.getFrontFacing();
            if (controller instanceof MetaTileEntityHPCA) {
                facing = RelativeDirection.RIGHT.getRelativeFacing(controller.getFrontFacing(), controller.getUpwardsFacing(), controller.isFlipped());
            }
            renderer.renderSided(facing, renderState, translation, pipeline);
        }
    }

    @Override
    public ICubeRenderer getBaseTexture() {
        return this.isAdvanced() ? Textures.ADVANCED_COMPUTER_CASING : Textures.COMPUTER_CASING;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        IHPCAComponentHatch provider;
        MetaTileEntityHPCAComponent metaTileEntityHPCAComponent;
        if (this.isBridge()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.bridge", (Object[])new Object[0]));
        }
        int upkeepEUt = this.getUpkeepEUt();
        int maxEUt = this.getMaxEUt();
        if (upkeepEUt != 0 && upkeepEUt != maxEUt) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_general.upkeep_eut", (Object[])new Object[]{upkeepEUt}));
        }
        if (maxEUt != 0) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_general.max_eut", (Object[])new Object[]{maxEUt}));
        }
        if ((metaTileEntityHPCAComponent = this) instanceof IHPCACoolantProvider) {
            provider = (IHPCACoolantProvider)((Object)metaTileEntityHPCAComponent);
            if (provider.isActiveCooler()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.cooler_active", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.cooler_active_coolant", (Object[])new Object[]{provider.getMaxCoolantPerTick(), I18n.func_135052_a((String)Materials.PCBCoolant.getUnlocalizedName(), (Object[])new Object[0])}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.cooler_passive", (Object[])new Object[0]));
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.cooler_cooling", (Object[])new Object[]{provider.getCoolingAmount()}));
        }
        if ((metaTileEntityHPCAComponent = this) instanceof IHPCAComputationProvider) {
            provider = (IHPCAComputationProvider)((Object)metaTileEntityHPCAComponent);
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.computation_cwut", (Object[])new Object[]{provider.getCWUPerTick()}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.computation_cooling", (Object[])new Object[]{provider.getCoolingPerTick()}));
        }
        if (this.canBeDamaged()) {
            tooltip.add(TooltipHelper.BLINKING_ORANGE + I18n.func_135052_a((String)"gregtech.machine.hpca.component_type.damaged", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    @Override
    public final boolean isBridge() {
        return this.doesAllowBridging() && (!this.canBeDamaged() || !this.isDamaged());
    }

    @Override
    public boolean isDamaged() {
        return this.canBeDamaged() && this.damaged;
    }

    @Override
    public void setDamaged(boolean damaged) {
        if (!this.canBeDamaged()) {
            return;
        }
        if (this.damaged != damaged) {
            this.damaged = damaged;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.DAMAGE_STATE, buf -> buf.writeBoolean(damaged));
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.canBeDamaged()) {
            data.func_74757_a("Damaged", this.damaged);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (this.canBeDamaged()) {
            this.damaged = data.func_74767_n("Damaged");
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.canBeDamaged()) {
            buf.writeBoolean(this.damaged);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (this.canBeDamaged()) {
            this.damaged = buf.readBoolean();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (this.canBeDamaged() && dataId == GregtechDataCodes.DAMAGE_STATE) {
            this.damaged = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean shouldDropWhenDestroyed() {
        return super.shouldDropWhenDestroyed() && (!this.canBeDamaged() || !this.isDamaged());
    }

    @Override
    public void getDrops(NonNullList<ItemStack> dropsList, @Nullable EntityPlayer harvester) {
        if (this.canBeDamaged() && this.isDamaged()) {
            if (this.isAdvanced()) {
                dropsList.add((Object)MetaBlocks.COMPUTER_CASING.getItemVariant(BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING));
            } else {
                dropsList.add((Object)MetaBlocks.COMPUTER_CASING.getItemVariant(BlockComputerCasing.CasingType.COMPUTER_CASING));
            }
        }
    }

    @Override
    public String getMetaName() {
        if (this.canBeDamaged() && this.isDamaged()) {
            return super.getMetaName() + ".damaged";
        }
        return super.getMetaName();
    }
}

